/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingWorkerModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.guardtype.GuardType;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.modules.WorkAtHomeBuildingModule;
import com.minecolonies.coremod.colony.jobs.JobArcherTraining;
import com.minecolonies.coremod.colony.jobs.JobCombatTraining;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import org.jetbrains.annotations.NotNull;

public class GuardBuildingModule
extends WorkAtHomeBuildingModule
implements IBuildingEventsModule,
ITickingModule,
IPersistentModule,
IBuildingWorkerModule,
ICreatesResolversModule {
    private static final Random random = new Random();

    public GuardBuildingModule(GuardType type, boolean canWorkingDuringRain, Function<IBuilding, Integer> sizeLimit) {
        super(type.getJobEntry().get(), type.getPrimarySkill(), type.getSecondarySkill(), canWorkingDuringRain, sizeLimit);
    }

    @Override
    void onRemoval(ICitizenData citizen) {
        super.onRemoval(citizen);
        Optional<AbstractEntityCitizen> optCitizen = citizen.getEntity();
        if (optCitizen.isPresent()) {
            AttributeModifierUtils.removeAllHealthModifiers((LivingEntity)optCitizen.get());
            optCitizen.get().func_184201_a(EquipmentSlotType.CHEST, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EquipmentSlotType.FEET, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EquipmentSlotType.HEAD, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EquipmentSlotType.LEGS, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EquipmentSlotType.MAINHAND, ItemStackUtils.EMPTY);
            optCitizen.get().func_184201_a(EquipmentSlotType.OFFHAND, ItemStackUtils.EMPTY);
        }
    }

    @Override
    public boolean isFull() {
        return this.building.getAllAssignedCitizen().size() >= this.getModuleMax();
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (random.nextBoolean()) {
            return;
        }
        boolean hiredFromTraining = false;
        if (this.building.getSetting(AbstractBuildingGuards.HIRE_TRAINEE).getValue() && !this.isFull() && this.building.getBuildingLevel() > 0 && this.building.isBuilt() && (this.getHiringMode() == HiringMode.DEFAULT && !this.building.getColony().isManualHiring() || this.getHiringMode() == HiringMode.AUTO)) {
            ICitizenData trainingCitizen = null;
            int maxSkill = 0;
            for (ICitizenData trainee : colony.getCitizenManager().getCitizens()) {
                if ((this.getJobEntry() != ModJobs.archer || !(trainee.getJob() instanceof JobArcherTraining)) && (this.getJobEntry() != ModJobs.knight || !(trainee.getJob() instanceof JobCombatTraining) || trainee.getCitizenSkillHandler().getLevel(this.getPrimarySkill()) <= maxSkill)) continue;
                maxSkill = trainee.getCitizenSkillHandler().getLevel(this.getPrimarySkill());
                trainingCitizen = trainee;
            }
            if (trainingCitizen != null) {
                hiredFromTraining = true;
                this.assignCitizen(trainingCitizen);
            }
        }
        if (!hiredFromTraining) {
            super.onColonyTick(colony);
        }
    }

    @Override
    void onAssignment(ICitizenData citizen) {
        super.onAssignment(citizen);
        if (this.building instanceof AbstractBuildingGuards) {
            ((AbstractBuildingGuards)this.building).setPatrolTimer(5);
        }
    }
}

