/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesNamedGrave;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.GraveData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.tileentities.TileEntityGrave;
import com.minecolonies.api.tileentities.TileEntityNamedGrave;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraveyardManagementModule
extends AbstractBuildingModule
implements IBuildingModule,
IPersistentModule,
IBuildingEventsModule {
    private static final String TAG_RIP_CITIZEN_LIST = "ripCitizenList";
    private static final String TAG_GRAVE_DATA = "gravedata";
    private final List<String> restingCitizen = new ArrayList<String>();
    @Nullable
    private GraveData lastGraveData;

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        this.restingCitizen.clear();
        if (compound.func_150296_c().contains(TAG_RIP_CITIZEN_LIST)) {
            ListNBT ripCitizen = compound.func_150295_c(TAG_RIP_CITIZEN_LIST, 8);
            for (int i = 0; i < ripCitizen.size(); ++i) {
                String citizenName = ripCitizen.func_150307_f(i);
                this.restingCitizen.add(citizenName);
            }
        }
        if (compound.func_150296_c().contains(TAG_GRAVE_DATA)) {
            this.lastGraveData = new GraveData();
            this.lastGraveData.read(compound.func_74775_l(TAG_GRAVE_DATA));
        } else {
            this.lastGraveData = null;
        }
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        @NotNull ListNBT ripCitizen = new ListNBT();
        for (String citizenName : this.restingCitizen) {
            ripCitizen.add((Object)StringNBT.func_229705_a_((String)citizenName));
        }
        compound.func_218657_a(TAG_RIP_CITIZEN_LIST, (INBT)ripCitizen);
        if (this.lastGraveData != null) {
            compound.func_218657_a(TAG_GRAVE_DATA, (INBT)this.lastGraveData.write());
        }
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        IColony colony = this.building.getColony();
        ArrayList<BlockPos> graves = new ArrayList<BlockPos>(colony.getGraveManager().getGraves().keySet());
        ArrayList<BlockPos> cleanList = new ArrayList<BlockPos>();
        for (BlockPos grave : graves) {
            TileEntity tileEntity;
            if (!WorldUtil.isBlockLoaded((IWorld)colony.getWorld(), grave) || !((tileEntity = colony.getWorld().func_175625_s(grave)) instanceof TileEntityGrave)) continue;
            cleanList.add(grave);
        }
        buf.writeInt(cleanList.size());
        for (BlockPos grave : cleanList) {
            buf.func_179255_a(grave);
        }
        buf.writeInt(this.restingCitizen.size());
        for (String citizenName : this.restingCitizen) {
            buf.func_180714_a(citizenName);
        }
    }

    public void setLastGraveData(GraveData graveData) {
        this.lastGraveData = graveData;
        this.markDirty();
    }

    public GraveData getLastGraveData() {
        return this.lastGraveData;
    }

    public void buryCitizenHere(Tuple<BlockPos, Direction> positionAndDirection) {
        if (this.lastGraveData != null && !this.restingCitizen.contains(this.lastGraveData.getCitizenName())) {
            IColony colony = this.building.getColony();
            Direction facing = positionAndDirection.getB();
            if (facing == Direction.UP || facing == Direction.DOWN) {
                facing = Direction.NORTH;
            }
            colony.getWorld().func_175656_a(positionAndDirection.getA(), (BlockState)ModBlocks.blockNamedGrave.func_176223_P().func_206870_a((Property)AbstractBlockMinecoloniesNamedGrave.FACING, (Comparable)facing));
            TileEntity tileEntity = colony.getWorld().func_175625_s(positionAndDirection.getA());
            if (tileEntity instanceof TileEntityNamedGrave) {
                String firstName = StringUtils.split((String)this.lastGraveData.getCitizenName())[0];
                String lastName = this.lastGraveData.getCitizenName().replaceFirst(firstName, "");
                ArrayList<String> lines = new ArrayList<String>();
                lines.add(firstName);
                lines.add(lastName);
                if (this.lastGraveData.getCitizenJobName() != null) {
                    lines.add(this.lastGraveData.getCitizenJobName());
                }
                ((TileEntityNamedGrave)tileEntity).setTextLines(lines);
            }
            this.restingCitizen.add(this.lastGraveData.getCitizenName());
            this.markDirty();
        }
    }
}

