/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FarmerFieldModule
extends AbstractBuildingModule
implements IPersistentModule,
IBuildingEventsModule,
IBuildingModule {
    private static final String TAG_FIELDS = "fields";
    private static final String TAG_FIELDS_BLOCKPOS = "fieldsPos";
    private static final String TAG_ASSIGN_MANUALLY = "assign";
    private static final int BLOCK_UPDATE_FLAG = 3;
    private static final String LAST_FIELD_TAG = "lastField";
    @Nullable
    private BlockPos currentField;
    @Nullable
    private BlockPos lastField;
    private final Set<BlockPos> farmerFields = new HashSet<BlockPos>();
    private boolean shouldAssignManually = false;

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        ListNBT fieldTagList = compound.func_150295_c(TAG_FIELDS, 10);
        for (int i = 0; i < fieldTagList.size(); ++i) {
            CompoundNBT fieldCompound = fieldTagList.func_150305_b(i);
            BlockPos fieldLocation = BlockPosUtil.read(fieldCompound, TAG_FIELDS_BLOCKPOS);
            this.farmerFields.add(fieldLocation);
        }
        this.shouldAssignManually = compound.func_74767_n(TAG_ASSIGN_MANUALLY);
        if (compound.func_150296_c().contains(LAST_FIELD_TAG)) {
            this.lastField = BlockPosUtil.read(compound, LAST_FIELD_TAG);
        }
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        @NotNull ListNBT fieldTagList = new ListNBT();
        for (BlockPos f : this.farmerFields) {
            @NotNull CompoundNBT fieldCompound = new CompoundNBT();
            BlockPosUtil.write(fieldCompound, TAG_FIELDS_BLOCKPOS, f);
            fieldTagList.add((Object)fieldCompound);
        }
        compound.func_218657_a(TAG_FIELDS, (INBT)fieldTagList);
        compound.func_74757_a(TAG_ASSIGN_MANUALLY, this.shouldAssignManually);
        if (this.lastField != null) {
            BlockPosUtil.write(compound, LAST_FIELD_TAG, this.lastField);
        }
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        buf.writeBoolean(this.shouldAssignManually);
        int size = 0;
        ArrayList<BlockPos> fields = new ArrayList<BlockPos>(this.building.getColony().getBuildingManager().getFields());
        ArrayList<BlockPos> cleanList = new ArrayList<BlockPos>();
        WorkerBuildingModule module = this.building.getFirstModuleOccurance(WorkerBuildingModule.class);
        for (BlockPos field : fields) {
            TileEntity scareCrow;
            if (!WorldUtil.isBlockLoaded((IWorld)this.building.getColony().getWorld(), field) || !((scareCrow = this.building.getColony().getWorld().func_175625_s(field)) instanceof ScarecrowTileEntity)) continue;
            if (((ScarecrowTileEntity)scareCrow).isTaken()) {
                if (!module.getAssignedCitizen().isEmpty() && ((ScarecrowTileEntity)scareCrow).getOwnerId() != module.getFirstCitizen().getId()) continue;
                cleanList.add(field);
                ++size;
                continue;
            }
            ++size;
            cleanList.add(field);
        }
        buf.writeInt(size);
        for (BlockPos field : cleanList) {
            buf.func_179255_a(field);
        }
        buf.writeInt(this.farmerFields.size());
    }

    @Nullable
    public BlockPos getCurrentField() {
        return this.currentField;
    }

    public void setCurrentField(@Nullable BlockPos currentField) {
        this.currentField = currentField;
    }

    @Nullable
    public BlockPos getFieldToWorkOn(World world) {
        ArrayList<BlockPos> fields = new ArrayList<BlockPos>(this.farmerFields);
        Collections.shuffle(fields);
        if (!fields.isEmpty()) {
            if (((BlockPos)fields.get(0)).equals((Object)this.lastField)) {
                Collections.shuffle(fields);
            }
            this.lastField = (BlockPos)fields.get(0);
        }
        for (BlockPos field : fields) {
            TileEntity scareCrow = this.building.getColony().getWorld().func_175625_s(field);
            if (!(scareCrow instanceof ScarecrowTileEntity) || !((ScarecrowTileEntity)scareCrow).needsWork()) continue;
            this.currentField = field;
            return field;
        }
        return null;
    }

    public void syncWithColony(@NotNull World world) {
        if (!this.farmerFields.isEmpty()) {
            @NotNull ArrayList<BlockPos> tempFields = new ArrayList<BlockPos>(this.farmerFields);
            WorkerBuildingModule module = this.building.getFirstModuleOccurance(WorkerBuildingModule.class);
            for (BlockPos field : tempFields) {
                TileEntity scarecrow = world.func_175625_s(field);
                if (scarecrow instanceof ScarecrowTileEntity) {
                    this.building.getColony().getWorld().func_184138_a(scarecrow.func_174877_v(), this.building.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), this.building.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), 3);
                    ((ScarecrowTileEntity)scarecrow).setTaken(true);
                    ((ScarecrowTileEntity)scarecrow).setOwner(module.getFirstCitizen() != null ? module.getFirstCitizen().getId() : 0);
                    ((ScarecrowTileEntity)scarecrow).setColony(this.building.getColony());
                    continue;
                }
                this.farmerFields.remove(field);
                if (this.currentField == null || !this.currentField.equals((Object)field)) continue;
                this.currentField = null;
            }
        }
    }

    @NotNull
    public List<BlockPos> getFarmerFields() {
        return new ArrayList<BlockPos>(this.farmerFields);
    }

    public boolean hasNoFields() {
        return this.farmerFields.isEmpty();
    }

    public void addFarmerFields(BlockPos field) {
        TileEntity scareCrow = this.building.getColony().getWorld().func_175625_s(field);
        if (scareCrow instanceof ScarecrowTileEntity) {
            this.farmerFields.add(field);
            this.markDirty();
        }
    }

    public boolean assignManually() {
        return this.shouldAssignManually;
    }

    public void setAssignManually(boolean assignManually) {
        this.shouldAssignManually = assignManually;
    }

    public void resetFields() {
        for (BlockPos field : this.farmerFields) {
            TileEntity scareCrow = this.building.getColony().getWorld().func_175625_s(field);
            if (!(scareCrow instanceof ScarecrowTileEntity)) continue;
            ((ScarecrowTileEntity)scareCrow).setNeedsWork(true);
        }
    }

    public void freeField(BlockPos position) {
        TileEntity scarecrow = this.building.getColony().getWorld().func_175625_s(position);
        if (scarecrow instanceof ScarecrowTileEntity) {
            this.farmerFields.remove(position);
            ((ScarecrowTileEntity)scarecrow).setTaken(false);
            ((ScarecrowTileEntity)scarecrow).setOwner(0);
            this.building.getColony().getWorld().func_184138_a(scarecrow.func_174877_v(), this.building.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), this.building.getColony().getWorld().func_180495_p(scarecrow.func_174877_v()), 3);
        }
    }

    public void assignField(BlockPos position) {
        TileEntity scarecrow = this.building.getColony().getWorld().func_175625_s(position);
        if (scarecrow instanceof ScarecrowTileEntity) {
            ((ScarecrowTileEntity)scarecrow).setTaken(true);
            WorkerBuildingModule module = this.building.getFirstModuleOccurance(WorkerBuildingModule.class);
            if (module.getFirstCitizen() != null) {
                ((ScarecrowTileEntity)scarecrow).setOwner(module.getFirstCitizen().getId());
            }
            this.farmerFields.add(position);
        }
    }

    @Override
    public void onWakeUp() {
        this.resetFields();
    }

    @Override
    public void onDestroyed() {
        for (BlockPos field : this.farmerFields) {
            TileEntity scareCrow = this.building.getColony().getWorld().func_175625_s(field);
            if (!(scareCrow instanceof ScarecrowTileEntity)) continue;
            ((ScarecrowTileEntity)scareCrow).setTaken(false);
            ((ScarecrowTileEntity)scareCrow).setOwner(0);
            this.building.getColony().getWorld().func_184138_a(scareCrow.func_174877_v(), this.building.getColony().getWorld().func_180495_p(scareCrow.func_174877_v()), this.building.getColony().getWorld().func_180495_p(scareCrow.func_174877_v()), 3);
        }
    }
}

