/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IEntityListModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class EntityListModule
extends AbstractBuildingModule
implements IEntityListModule,
IPersistentModule {
    private static final String TAG_MOBLIST = "newmoblist";
    private final Set<ResourceLocation> mobsAllowed = new HashSet<ResourceLocation>();
    private final String id;

    public EntityListModule(String id) {
        this.id = id;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        ListNBT filterableList = compound.func_74775_l(this.id).func_150295_c(TAG_MOBLIST, 8);
        for (int i = 0; i < filterableList.size(); ++i) {
            ResourceLocation res = new ResourceLocation(filterableList.func_150307_f(i));
            if (!ForgeRegistries.ENTITIES.containsKey(res)) continue;
            this.mobsAllowed.add(res);
        }
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        CompoundNBT moduleCompound = new CompoundNBT();
        @NotNull ListNBT filteredMobs = new ListNBT();
        for (ResourceLocation mob : this.mobsAllowed) {
            filteredMobs.add((Object)StringNBT.func_229705_a_((String)mob.toString()));
        }
        moduleCompound.func_218657_a(TAG_MOBLIST, (INBT)filteredMobs);
        compound.func_218657_a(this.id, (INBT)moduleCompound);
    }

    @Override
    public void addEntity(ResourceLocation item) {
        this.mobsAllowed.add(item);
        this.markDirty();
    }

    @Override
    public boolean isEntityInList(ResourceLocation entity) {
        return this.mobsAllowed.contains(entity);
    }

    @Override
    public void removeEntity(ResourceLocation item) {
        this.mobsAllowed.remove(item);
        this.markDirty();
    }

    public ImmutableList<ResourceLocation> getList() {
        return ImmutableList.copyOf(this.mobsAllowed);
    }

    @Override
    public String getListIdentifier() {
        return this.id;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        buf.writeInt(this.mobsAllowed.size());
        for (ResourceLocation entity : this.mobsAllowed) {
            buf.writeRegistryIdUnsafe(ForgeRegistries.ENTITIES, entity);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }
}

