/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.jobs.IJobWithExternalWorkStations;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.utils.BuilderBucket;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.jobs.AbstractJobStructure;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildDecoration;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingResourcesModule
extends AbstractBuildingModule
implements IPersistentModule {
    private Map<String, BuildingBuilderResource> neededResources = new LinkedHashMap<String, BuildingBuilderResource>();
    private Deque<BuilderBucket> buckets = new ArrayDeque<BuilderBucket>();
    private int totalStages = 0;
    private int currentStage = 0;

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        this.currentStage = compound.func_74762_e("currStage");
        this.totalStages = compound.func_74762_e("totalStages");
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        compound.func_74768_a("totalStages", this.totalStages);
        compound.func_74768_a("currStage", this.currentStage);
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        AbstractJobStructure structureBuilderJob;
        WorkOrderBuildDecoration workOrderBuildDecoration;
        ICitizenData data;
        this.updateAvailableResources();
        buf.writeInt(this.neededResources.size());
        double qty = 0.0;
        for (BuildingBuilderResource resource : this.neededResources.values()) {
            buf.func_150788_a(resource.getItemStack());
            buf.writeInt(resource.getAvailable());
            buf.writeInt(resource.getAmount());
            qty += (double)resource.getAmount();
        }
        Set<ICitizenData> set = this.building.getAllAssignedCitizen();
        ICitizenData iCitizenData = data = set.isEmpty() ? null : set.iterator().next();
        if (data != null && data.getJob() instanceof AbstractJobStructure && (workOrderBuildDecoration = (structureBuilderJob = (AbstractJobStructure)data.getJob()).getWorkOrder()) != null) {
            String name = workOrderBuildDecoration.getDisplayName();
            buf.func_180714_a(name);
            buf.writeDouble(workOrderBuildDecoration.getAmountOfRes() == 0 ? 0.0 : qty / (double)workOrderBuildDecoration.getAmountOfRes());
            buf.writeInt(this.totalStages);
            buf.writeInt(this.currentStage);
            return;
        }
        buf.func_180714_a("");
        buf.writeDouble(0.0);
        buf.writeInt(0);
        buf.writeInt(0);
    }

    private void updateAvailableResources() {
        ICitizenData data;
        Set<ICitizenData> set = this.building.getAllAssignedCitizen();
        ICitizenData iCitizenData = data = set.isEmpty() ? null : set.iterator().next();
        if (data == null) {
            return;
        }
        data.getEntity().ifPresent(structureBuilder -> {
            InventoryCitizen structureBuilderInventory = data.getInventory();
            if (structureBuilderInventory == null) {
                return;
            }
            for (Map.Entry<String, BuildingBuilderResource> entry : this.neededResources.entrySet()) {
                BuildingBuilderResource resource = entry.getValue();
                resource.setAvailable(0);
                if (structureBuilderInventory != null) {
                    resource.addAvailable(InventoryUtils.getItemCountInItemHandler((IItemHandler)structureBuilderInventory, stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack(), true, true)));
                }
                if (this.building.getTileEntity() != null) {
                    resource.addAvailable(InventoryUtils.getItemCountInItemHandler((IItemHandler)this.building.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack(), true, true)));
                }
                if (!(data.getJob() instanceof IJobWithExternalWorkStations)) continue;
                for (IBuilding station : ((IJobWithExternalWorkStations)((Object)data.getJob())).getWorkStations()) {
                    resource.addAvailable(InventoryUtils.getItemCountInItemHandler((IItemHandler)station.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseGet(null), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack(), true, true)));
                }
            }
        });
    }

    public Map<String, BuildingBuilderResource> getNeededResources() {
        return new HashMap<String, BuildingBuilderResource>(this.neededResources);
    }

    @Nullable
    public BuilderBucket getRequiredResources() {
        return this.buckets.isEmpty() || ((AbstractBuildingStructureBuilder)this.building).getProgress() == null || ((AbstractBuildingStructureBuilder)this.building).getProgress().getB() == BuildingStructureHandler.Stage.CLEAR ? null : this.buckets.getFirst();
    }

    public BuildingBuilderResource getResourceFromIdentifier(String res) {
        return this.neededResources.get(res);
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        if (ItemStackUtils.isEmpty(res).booleanValue() || amount == 0) {
            return;
        }
        int hashCode = res.func_77942_o() ? res.func_77978_p().hashCode() : 0;
        String key = res.func_77977_a() + "-" + hashCode;
        BuildingBuilderResource resource = this.neededResources.get(key);
        if (resource == null) {
            resource = new BuildingBuilderResource(res, amount);
        } else {
            resource.setAmount(resource.getAmount() + amount);
        }
        this.neededResources.put(key, resource);
        BuilderBucket last = this.buckets.isEmpty() ? null : this.buckets.removeLast();
        int stacks = (int)Math.ceil((double)amount / (double)res.func_77976_d());
        int max = this.building.getAllAssignedCitizen().iterator().next().getInventory().getSlots() - 9;
        if (last == null || last.getTotalStacks() >= max || last.getTotalStacks() + stacks >= max) {
            if (last != null) {
                this.buckets.add(last);
            }
            last = new BuilderBucket();
            last.setTotalStacks(stacks);
            last.addOrAdjustResource(key, amount);
            this.buckets.add(last);
        } else {
            int currentQty = last.getResourceMap().getOrDefault(key, 0);
            int currentStacks = (int)Math.ceil((double)currentQty / (double)res.func_77976_d());
            int newStacks = (int)Math.ceil((double)(currentQty + amount) / (double)res.func_77976_d());
            Map<String, Integer> map = last.getResourceMap();
            last.setTotalStacks(last.getTotalStacks() + newStacks - currentStacks);
            last.addOrAdjustResource(key, currentQty + amount);
            this.buckets.add(last);
        }
        this.markDirty();
    }

    public void reduceNeededResource(ItemStack res, int amount) {
        BuilderBucket last;
        int hashCode = res.func_77942_o() ? res.func_77978_p().hashCode() : 0;
        String name = res.func_77977_a() + "-" + hashCode;
        BuilderBucket builderBucket = last = this.buckets.isEmpty() ? null : this.getRequiredResources();
        if (last != null) {
            Map<String, Integer> map = last.getResourceMap();
            if (map.containsKey(name)) {
                int qty = map.get(name) - amount;
                if (qty > 0) {
                    last.addOrAdjustResource(name, map.get(name) - amount);
                } else {
                    last.removeResources(name);
                }
            }
            if (map.isEmpty()) {
                this.buckets.remove();
            }
        }
        int preAmount = 0;
        if (this.neededResources.containsKey(name)) {
            preAmount = this.neededResources.get(name).getAmount();
        }
        if (preAmount - amount <= 0) {
            this.neededResources.remove(name);
        } else {
            this.neededResources.get(name).setAmount(preAmount - amount);
        }
        this.markDirty();
    }

    public void resetNeededResources() {
        this.neededResources = new HashMap<String, BuildingBuilderResource>();
        this.buckets.clear();
        this.markDirty();
    }

    public boolean requiresResourceForBuilding(ItemStack stack) {
        int hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
        return this.neededResources.containsKey(stack.func_77977_a() + "-" + hashCode);
    }

    public void checkOrRequestBucket(@Nullable BuilderBucket requiredResources, ICitizenData worker, boolean workerInv) {
        if (requiredResources == null) {
            return;
        }
        ImmutableList list = this.building.getOpenRequestsOfType(worker.getId(), TypeToken.of(Stack.class));
        for (Map.Entry<String, Integer> entry : requiredResources.getResourceMap().entrySet()) {
            int requestCount;
            ItemStorage itemStack = this.neededResources.get(entry.getKey());
            if (itemStack == null) continue;
            boolean hasOpenRequest = false;
            int count = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.building.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElseGet(null), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, itemStack.getItemStack()));
            int totalAmount = this.neededResources.containsKey(entry.getKey()) ? this.neededResources.get(entry.getKey()).getAmount() : 0;
            int workerInvCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)worker.getInventory(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, itemStack.getItemStack()));
            if ((!workerInv || count + workerInvCount >= entry.getValue()) && (count >= entry.getValue() || count + workerInvCount >= totalAmount) || (requestCount = entry.getValue() - count - (workerInv ? workerInvCount : 0)) <= 0) continue;
            for (IRequest request : list) {
                if (!ItemStackUtils.compareItemStacksIgnoreStackSize(((Stack)request.getRequest()).getStack(), itemStack.getItemStack()).booleanValue()) continue;
                hasOpenRequest = true;
                break;
            }
            if (hasOpenRequest) break;
            worker.createRequestAsync(new Stack(itemStack.getItemStack(), requestCount * ((AbstractBuildingStructureBuilder)this.building).getResourceBatchMultiplier(), 1));
        }
    }

    public void nextStage() {
        if (this.currentStage + 1 > this.totalStages) {
            ++this.totalStages;
        }
        ++this.currentStage;
    }

    public void setTotalStages(int total) {
        this.totalStages = total;
        this.currentStage = 0;
    }

    @Nullable
    public BuilderBucket getNextBucket() {
        Iterator<BuilderBucket> iterator = this.buckets.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

