/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.buildings.modules.IHasRequiredItemsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.workerbuildings.IWareHouse;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ClassicRecipe;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ImmutableItemStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.MultiOutputRecipe;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.CraftingWorkerBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.CrafterRecipeSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingProductionResolver;
import com.minecolonies.coremod.colony.requestsystem.resolvers.PublicWorkerCraftingRequestResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCraftingBuildingModule
extends AbstractBuildingModule
implements ICraftingBuildingModule,
IPersistentModule,
ICreatesResolversModule,
IHasRequiredItemsModule,
ITickingModule {
    public static final ISettingKey<CrafterRecipeSetting> RECIPE_MODE = new SettingKey<CrafterRecipeSetting>(CrafterRecipeSetting.class, new ResourceLocation("minecolonies", "recipemode"));
    private static final double BASE_CHANCE = 0.0625;
    private static final int EXTRA_RECIPE_MULTIPLIER = 5;
    private static final String REDUCEABLE = "reduceable";
    protected final List<IToken<?>> recipes = new ArrayList();
    protected final JobEntry jobEntry;
    protected AbstractBuilding building;

    public AbstractCraftingBuildingModule(JobEntry jobEntry) {
        this.jobEntry = jobEntry;
    }

    @Override
    public List<IToken<?>> getRecipes() {
        return this.recipes;
    }

    @Override
    public IBuildingModule setBuilding(IBuilding building) {
        this.building = (AbstractBuilding)building;
        return super.setBuilding(building);
    }

    @Override
    public boolean canRecipeBeAdded(IToken<?> token) {
        return this.hasSpaceForMoreRecipes() && this.isRecipeCompatibleWithCraftingModule(token);
    }

    private boolean hasSpaceForMoreRecipes() {
        return this.getMaxRecipes() > this.recipes.size();
    }

    protected int getMaxRecipes() {
        double increase = this.canLearnLargeRecipes() || this.canLearnFurnaceRecipes() ? (1.0 + this.building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RECIPES)) * 5.0 : 1.0 + this.building.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RECIPES);
        return (int)(Math.pow(2.0, this.building.getBuildingLevel()) * increase);
    }

    protected boolean isRecipeCompatibleWithCraftingModule(IToken<?> token) {
        IGenericRecipe recipe = GenericRecipe.of(token);
        if (recipe == null) {
            return false;
        }
        return this.isRecipeCompatible(recipe);
    }

    private boolean isPreTaughtRecipe(IRecipeStorage storage, Map<ResourceLocation, CustomRecipe> crafterRecipes) {
        ItemStack one = storage.getPrimaryOutput();
        for (CustomRecipe rec : crafterRecipes.values()) {
            ItemStack two = rec.getRecipeStorage().getPrimaryOutput();
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(one, two).booleanValue() || one.func_190916_E() != two.func_190916_E()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void serializeNBT(@NotNull CompoundNBT compound) {
        CompoundNBT moduleCompound = new CompoundNBT();
        @NotNull ListNBT recipesTagList = this.recipes.stream().map(iToken -> StandardFactoryController.getInstance().serialize(iToken)).collect(NBTUtils.toListNBT());
        moduleCompound.func_218657_a("recipes", (INBT)recipesTagList);
        compound.func_218657_a(this.getId(), (INBT)moduleCompound);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        ListNBT recipesTags;
        if (compound.func_74764_b("recipes")) {
            recipesTags = compound.func_150295_c("recipes", 10);
        } else {
            CompoundNBT compoundNBT = compound.func_74775_l(this.getId());
            recipesTags = compoundNBT.func_150295_c("recipes", 10);
        }
        for (int i = 0; i < recipesTags.size(); ++i) {
            IToken token = (IToken)StandardFactoryController.getInstance().deserialize(recipesTags.func_150305_b(i));
            if (this.recipes.contains(token)) continue;
            this.recipes.add(token);
            IColonyManager.getInstance().getRecipeManager().registerUse(token);
        }
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        if (this.jobEntry != null) {
            buf.writeBoolean(true);
            buf.writeRegistryId((IForgeRegistryEntry)this.jobEntry);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeBoolean(this.canLearnCraftingRecipes());
        buf.writeBoolean(this.canLearnFurnaceRecipes());
        buf.writeBoolean(this.canLearnLargeRecipes());
        ArrayList<IRecipeStorage> storages = new ArrayList<IRecipeStorage>();
        Map<ResourceLocation, CustomRecipe> crafterRecipes = CustomRecipeManager.getInstance().getAllRecipes().getOrDefault(this.getCustomRecipeKey(), Collections.emptyMap());
        for (IToken<?> token : new ArrayList(this.recipes)) {
            IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
            if (storage == null || storage.getRecipeSource() != null && !crafterRecipes.containsKey(storage.getRecipeSource()) || !this.isRecipeCompatibleWithCraftingModule(token) && !this.isPreTaughtRecipe(storage, crafterRecipes)) {
                this.removeRecipe(token);
                continue;
            }
            storages.add(storage);
        }
        buf.writeInt(storages.size());
        for (IRecipeStorage storage : storages) {
            buf.func_150786_a(StandardFactoryController.getInstance().serialize(storage));
        }
        buf.writeInt(this.getMaxRecipes());
        buf.func_180714_a(this.getId());
        buf.writeBoolean(this.isVisible());
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<ItemStorage, Tuple> requiredItems = new HashMap<ItemStorage, Tuple>();
        for (Tuple<IRecipeStorage, Integer> recipeStorage : this.getPendingRequestQueue()) {
            for (ItemStorage itemStorage : ((IRecipeStorage)recipeStorage.func_76341_a()).getCleanedInput()) {
                int amount = itemStorage.getAmount() * (Integer)recipeStorage.func_76340_b();
                if (requiredItems.containsKey(itemStorage)) {
                    amount += ((Integer)((Tuple)requiredItems.get(itemStorage)).func_76341_a()).intValue();
                }
                requiredItems.put(itemStorage, new Tuple((Object)amount, (Object)false));
            }
            ItemStorage output = new ItemStorage(((IRecipeStorage)recipeStorage.func_76341_a()).getPrimaryOutput());
            int amount = output.getAmount() * (Integer)recipeStorage.func_76340_b();
            if (requiredItems.containsKey(output)) {
                amount += ((Integer)((Tuple)requiredItems.get(output)).func_76341_a()).intValue();
            }
            requiredItems.put(output, new Tuple((Object)amount, (Object)false));
        }
        return new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(requiredItems.entrySet().stream().collect(Collectors.toMap(key -> stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, ((ItemStorage)key.getKey()).getItemStack(), false, true), Map.Entry::getValue)));
    }

    @Override
    public Map<ItemStorage, Integer> reservedStacks() {
        HashMap<ItemStorage, Integer> recipeOutputs = new HashMap<ItemStorage, Integer>();
        for (Tuple<IRecipeStorage, Integer> recipeStorage : this.getPendingRequestQueue()) {
            for (ItemStorage itemStorage : ((IRecipeStorage)recipeStorage.func_76341_a()).getCleanedInput()) {
                int amount = itemStorage.getAmount() * (Integer)recipeStorage.func_76340_b();
                if (recipeOutputs.containsKey(itemStorage)) {
                    amount += ((Integer)recipeOutputs.get(itemStorage)).intValue();
                }
                recipeOutputs.put(itemStorage, amount);
            }
        }
        return recipeOutputs;
    }

    private List<Tuple<IRecipeStorage, Integer>> getPendingRequestQueue() {
        ArrayList<Tuple<IRecipeStorage, Integer>> recipes = new ArrayList<Tuple<IRecipeStorage, Integer>>();
        for (ICitizenData citizen : this.building.getAllAssignedCitizen()) {
            if (!(citizen.getJob() instanceof AbstractJobCrafter)) continue;
            ArrayList assignedTasks = new ArrayList(citizen.getJob(AbstractJobCrafter.class).getAssignedTasks());
            assignedTasks.addAll(citizen.getJob(AbstractJobCrafter.class).getTaskQueue());
            for (IToken iToken : assignedTasks) {
                IRequest<?> request = this.building.getColony().getRequestManager().getRequestForToken(iToken);
                IRecipeStorage recipeStorage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(((PublicCrafting)request.getRequest()).getRecipeID());
                if (!this.holdsRecipe(((PublicCrafting)request.getRequest()).getRecipeID()) || recipeStorage == null) continue;
                recipes.add((Tuple<IRecipeStorage, Integer>)new Tuple((Object)recipeStorage, (Object)((PublicCrafting)request.getRequest()).getCount()));
            }
        }
        return recipes;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public boolean addRecipe(IToken<?> token) {
        if (this.canRecipeBeAdded(token)) {
            this.addRecipeToList(token, false);
            this.markDirty();
            if (this.building.getAllAssignedCitizen().isEmpty()) {
                return true;
            }
            IRecipeStorage recipeStorage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
            if (recipeStorage != null) {
                this.building.getColony().getRequestManager().onColonyUpdate(request -> request.getRequest() instanceof IDeliverable && ((IDeliverable)request.getRequest()).matches(recipeStorage.getPrimaryOutput()));
            }
            return true;
        }
        return false;
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        this.checkForWorkerSpecificRecipes();
    }

    @Override
    public void checkForWorkerSpecificRecipes() {
        IRecipeManager recipeManager = IColonyManager.getInstance().getRecipeManager();
        for (CustomRecipe newRecipe : CustomRecipeManager.getInstance().getRecipes(this.getCustomRecipeKey())) {
            IRecipeStorage recipeStorage = newRecipe.getRecipeStorage();
            IToken<?> recipeToken = recipeManager.checkOrAddRecipe(recipeStorage);
            if (newRecipe.isValidForBuilding(this.building)) {
                IToken<?> duplicateFound = null;
                boolean forceReplace = false;
                for (IToken<?> token : this.recipes) {
                    if (token == recipeToken) {
                        duplicateFound = token;
                        break;
                    }
                    IRecipeStorage storage = (IRecipeStorage)recipeManager.getRecipes().get(token);
                    if (storage == null || !storage.getPrimaryOutput().equals(recipeStorage.getPrimaryOutput(), true)) continue;
                    List<ItemStorage> recipeInput1 = storage.getCleanedInput();
                    List<ItemStorage> recipeInput2 = recipeStorage.getCleanedInput();
                    if (recipeInput1.size() != recipeInput2.size()) continue;
                    if (recipeInput1.size() > 1) {
                        recipeInput1.sort(Comparator.comparing(item -> Objects.hash(item.hashCode(), item.getAmount())));
                        recipeInput2.sort(Comparator.comparing(item -> Objects.hash(item.hashCode(), item.getAmount())));
                    }
                    boolean allMatch = true;
                    for (int i = 0; i < recipeInput1.size(); ++i) {
                        if (recipeInput1.get(i).getItem().equals(recipeInput2.get(i).getItem())) continue;
                        allMatch = false;
                        break;
                    }
                    if (!allMatch) continue;
                    duplicateFound = token;
                    if (storage.getRecipeType() instanceof ClassicRecipe && recipeStorage.getRecipeType() instanceof MultiOutputRecipe) {
                        forceReplace = true;
                    }
                    if (storage.getRecipeSource() == null || !storage.getRecipeSource().equals((Object)recipeStorage.getRecipeSource())) break;
                    forceReplace = true;
                    break;
                }
                if (duplicateFound == null) {
                    this.addRecipeToList(recipeToken, true);
                    this.building.getColony().getRequestManager().onColonyUpdate(request -> request.getRequest() instanceof IDeliverable && ((IDeliverable)request.getRequest()).matches(recipeStorage.getPrimaryOutput()));
                    this.markDirty();
                    continue;
                }
                if (!forceReplace && !newRecipe.getMustExist() || duplicateFound.equals(recipeToken)) continue;
                this.replaceRecipe(duplicateFound, recipeToken);
                this.building.getColony().getRequestManager().onColonyUpdate(request -> request.getRequest() instanceof IDeliverable && ((IDeliverable)request.getRequest()).matches(recipeStorage.getPrimaryOutput()));
                List<ItemStack> alternates = recipeStorage.getAlternateOutputs();
                for (IToken<?> token : this.recipes) {
                    IRecipeStorage storage = (IRecipeStorage)recipeManager.getRecipes().get(token);
                    if (!(storage.getRecipeType() instanceof ClassicRecipe) || !ItemStackUtils.compareItemStackListIgnoreStackSize(alternates, storage.getPrimaryOutput(), false, true)) continue;
                    this.removeRecipe(token);
                }
                this.building.getColony().getRequestManager().onColonyUpdate(request -> request.getRequest() instanceof IDeliverable && recipeStorage.getAlternateOutputs().stream().anyMatch(i -> ((IDeliverable)request.getRequest()).matches((ItemStack)i)));
                this.markDirty();
                continue;
            }
            if (!this.recipes.contains(recipeToken)) continue;
            this.removeRecipe(recipeToken);
            this.markDirty();
        }
    }

    @Override
    public void clearRecipes() {
        this.recipes.clear();
    }

    @Override
    public void improveRecipe(IRecipeStorage recipe, int count, ICitizenData citizen) {
        List inputs = recipe.getCleanedInput().stream().sorted(Comparator.comparingInt(ItemStorage::getAmount).reversed()).collect(Collectors.toList());
        double actualChance = Math.min(5.0, 0.0625 * (double)count + 0.0625 * (double)citizen.getCitizenSkillHandler().getLevel(this.building.getModuleMatching(CraftingWorkerBuildingModule.class, m -> m.getJobEntry() == this.jobEntry).getRecipeImprovementSkill()));
        double roll = citizen.getRandom().nextDouble() * 100.0;
        ItemStorage reducedItem = null;
        if (roll <= actualChance && ModTags.crafterProductExclusions.containsKey(REDUCEABLE) && !ModTags.crafterProductExclusions.get(REDUCEABLE).func_230235_a_((Object)recipe.getPrimaryOutput().func_77973_b())) {
            ArrayList<ImmutableItemStorage> newRecipe = new ArrayList<ImmutableItemStorage>();
            boolean didReduction = false;
            for (ItemStorage input : inputs) {
                if (input.getAmount() > 1 && ModTags.crafterIngredient.containsKey(REDUCEABLE) && ModTags.crafterIngredient.get(REDUCEABLE).func_230235_a_((Object)input.getItem())) {
                    reducedItem = input.copy();
                    reducedItem.setAmount(input.getAmount() - 1);
                    newRecipe.add(reducedItem.toImmutable());
                    didReduction = true;
                    continue;
                }
                newRecipe.add(input.copy().toImmutable());
            }
            if (didReduction) {
                IRecipeStorage storage = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{newRecipe, 1, recipe.getPrimaryOutput(), Blocks.field_150350_a});
                this.replaceRecipe(recipe.getToken(), IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(storage));
                TranslationTextComponent message = new TranslationTextComponent("com.minecolonies.coremod.crafters.recipeimproved." + citizen.getRandom().nextInt(3), new Object[]{new TranslationTextComponent(citizen.getJob().getJobRegistryEntry().getTranslationKey().toLowerCase()), recipe.getPrimaryOutput().func_200301_q(), reducedItem.getItemStack().func_200301_q(), citizen.getName()});
                for (PlayerEntity player : this.building.getColony().getMessagePlayerEntities()) {
                    player.func_145747_a((ITextComponent)message, player.func_110124_au());
                }
            }
        }
    }

    @Override
    @Nullable
    public IRecipeStorage getFirstRecipe(ItemStack stack) {
        return this.getFirstRecipe((ItemStack itemStack) -> !itemStack.func_190926_b() && ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack, true, true));
    }

    @Override
    @Nullable
    public IRecipeStorage getFirstRecipe(Predicate<ItemStack> stackPredicate) {
        IRecipeStorage foundRecipe = null;
        HashMap<IRecipeStorage, Integer> candidates = new HashMap<IRecipeStorage, Integer>();
        for (IToken<?> iToken : this.recipes) {
            IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(iToken);
            if (storage == null) continue;
            if (!stackPredicate.test(storage.getPrimaryOutput())) {
                if (!storage.getAlternateOutputs().stream().anyMatch(stackPredicate::test)) continue;
            }
            if (foundRecipe == null) {
                foundRecipe = storage;
            }
            candidates.put(storage, 0);
        }
        if (candidates.size() > 1 && this.building.hasModule(ISettingsModule.class) && this.building.getSetting(RECIPE_MODE).getValue().equals("com.minecolonies.core.crafting.setting.maxstock")) {
            for (Map.Entry entry : candidates.entrySet()) {
                ItemStorage checkItem = ((IRecipeStorage)entry.getKey()).getCleanedInput().stream().max(Comparator.comparingInt(ItemStorage::getAmount)).get();
                candidates.put((IRecipeStorage)entry.getKey(), this.getWarehouseCount(checkItem));
            }
            foundRecipe = (IRecipeStorage)candidates.entrySet().stream().min(Map.Entry.comparingByValue(Comparator.reverseOrder())).get().getKey();
        }
        if (foundRecipe != null && foundRecipe.getRecipeType() instanceof MultiOutputRecipe) {
            IToken<?> token = IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(foundRecipe.getClassicForMultiOutput(stackPredicate));
            foundRecipe = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
        }
        return foundRecipe;
    }

    @Override
    public boolean holdsRecipe(IToken<?> token) {
        if (this.recipes.contains(token)) {
            return true;
        }
        IRecipeStorage storageIn = IColonyManager.getInstance().getRecipeManager().getRecipe(token);
        if (storageIn == null) {
            return false;
        }
        for (IToken<?> localToken : this.recipes) {
            IRecipeStorage storage = IColonyManager.getInstance().getRecipeManager().getRecipe(localToken);
            if (storage == null || !(storage.getRecipeType() instanceof MultiOutputRecipe) || !storageIn.equals(storage.getClassicForMultiOutput(storageIn.getPrimaryOutput()))) continue;
            return true;
        }
        return false;
    }

    protected int getWarehouseCount(ItemStorage item) {
        int count = 0;
        List<IWareHouse> wareHouses = this.building.getColony().getBuildingManager().getWareHouses();
        for (IWareHouse wareHouse : wareHouses) {
            count += InventoryUtils.getCountFromBuilding((IBuilding)wareHouse, item);
        }
        return count;
    }

    @Override
    public IRecipeStorage getFirstFulfillableRecipe(Predicate<ItemStack> stackPredicate, int count, boolean considerReservation) {
        for (IToken<?> token : this.recipes) {
            IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
            if (storage == null || !stackPredicate.test(storage.getPrimaryOutput()) && !storage.getAlternateOutputs().stream().anyMatch(i -> stackPredicate.test((ItemStack)i))) continue;
            HashSet<InventoryCitizen> handlers = new HashSet<InventoryCitizen>();
            for (ICitizenData workerEntity : this.building.getAllAssignedCitizen()) {
                handlers.add(workerEntity.getInventory());
            }
            IRecipeStorage toTest = storage.getRecipeType() instanceof MultiOutputRecipe ? storage.getClassicForMultiOutput(stackPredicate) : storage;
            if (!toTest.canFullFillRecipe(count, considerReservation ? this.reservedStacks() : Collections.emptyMap(), new ArrayList<IItemHandler>(handlers), this.building)) continue;
            return toTest;
        }
        return null;
    }

    @Override
    public boolean fullFillRecipe(IRecipeStorage storage) {
        List<IItemHandler> handlers = this.building.getHandlers();
        ICitizenData data = this.building.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.jobEntry).getFirstCitizen();
        if (data == null || !data.getEntity().isPresent()) {
            return storage.fullfillRecipe(this.building.getColony().getWorld(), handlers);
        }
        AbstractEntityCitizen worker = data.getEntity().get();
        int primarySkill = worker.getCitizenData().getCitizenSkillHandler().getLevel(this.building.getModuleMatching(WorkerBuildingModule.class, m -> m.getJobEntry() == this.jobEntry).getPrimarySkill());
        int luck = (int)((double)((primarySkill + 1) * 2) - Math.pow((double)(primarySkill + 1) / 10.0, 2.0));
        LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.building.getColony().getWorld()).func_216015_a(LootParameters.field_237457_g_, (Object)worker.func_213303_ch()).func_216015_a(LootParameters.field_216281_a, (Object)worker).func_216015_a(LootParameters.field_216289_i, (Object)worker.func_184614_ca()).func_216023_a(worker.func_70681_au()).func_186469_a((float)luck);
        return storage.fullfillRecipe(builder.func_216022_a(RecipeStorage.recipeLootParameters), handlers);
    }

    @Override
    @Nullable
    public IJob<?> getCraftingJob() {
        if (this.jobEntry == null) {
            return null;
        }
        return this.jobEntry.produceJob(null);
    }

    @Override
    public void updateWorkerAvailableForRecipes() {
        for (IToken<?> token : this.recipes) {
            IRecipeStorage recipeStorage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
            if (recipeStorage == null) continue;
            this.building.getColony().getRequestManager().onColonyUpdate(request -> request.getRequest() instanceof IDeliverable && ((IDeliverable)request.getRequest()).matches(recipeStorage.getPrimaryOutput()));
        }
    }

    @Override
    public void replaceRecipe(IToken<?> oldRecipe, IToken<?> newRecipe) {
        if (this.recipes.contains(oldRecipe)) {
            int oldIndex = this.recipes.indexOf(oldRecipe);
            this.recipes.add(oldIndex, newRecipe);
            this.recipes.remove(oldRecipe);
            this.markDirty();
        }
    }

    @Override
    public void removeRecipe(IToken<?> token) {
        if (this.recipes.remove(token)) {
            this.markDirty();
        } else {
            Log.getLogger().warn("Failure to remove recipe, please tell the mod authors about this");
            this.recipes.clear();
        }
    }

    @Override
    public void addRecipeToList(IToken<?> token, boolean atTop) {
        if (!this.recipes.contains(token)) {
            if (atTop) {
                this.recipes.add(0, token);
            } else {
                this.recipes.add(token);
            }
        }
    }

    @Override
    public void switchOrder(int i, int j) {
        if (i < this.recipes.size() && j < this.recipes.size() && i >= 0 && j >= 0) {
            IToken<?> storage = this.recipes.get(i);
            this.recipes.set(i, this.recipes.get(j));
            this.recipes.set(j, storage);
            this.markDirty();
        }
    }

    @Override
    @NotNull
    public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly() {
        return Collections.emptyList();
    }

    @Override
    public List<IRequestResolver<?>> createResolvers() {
        ArrayList resolvers = new ArrayList();
        resolvers.add(new PublicWorkerCraftingRequestResolver(this.building.getRequester().getLocation(), this.building.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN), this.jobEntry));
        resolvers.add(new PublicWorkerCraftingProductionResolver(this.building.getRequester().getLocation(), this.building.getColony().getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN), this.jobEntry));
        return resolvers;
    }

    @Override
    @NotNull
    public abstract String getId();

    @Override
    @NotNull
    public String getCustomRecipeKey() {
        if (this.jobEntry == null) {
            return "";
        }
        return this.jobEntry.getRegistryName().func_110623_a() + "_" + this.getId();
    }

    @Override
    @NotNull
    public OptionalPredicate<ItemStack> getIngredientValidator() {
        return stack -> Optional.empty();
    }

    public static abstract class Custom
    extends AbstractCraftingBuildingModule {
        public Custom(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean canLearnCraftingRecipes() {
            return false;
        }

        @Override
        public boolean canLearnFurnaceRecipes() {
            return false;
        }

        @Override
        public boolean canLearnLargeRecipes() {
            return false;
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            return false;
        }

        @Override
        @NotNull
        public String getId() {
            return "custom";
        }
    }

    public static abstract class Smelting
    extends AbstractCraftingBuildingModule {
        public Smelting(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean canLearnCraftingRecipes() {
            return false;
        }

        @Override
        public boolean canLearnFurnaceRecipes() {
            return true;
        }

        @Override
        public boolean canLearnLargeRecipes() {
            return false;
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            return this.canLearnFurnaceRecipes() && recipe.getIntermediate() == Blocks.field_150460_al;
        }

        @Override
        @NotNull
        public String getId() {
            return "smelting";
        }
    }

    public static abstract class Crafting
    extends AbstractCraftingBuildingModule {
        public Crafting(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean canLearnCraftingRecipes() {
            return true;
        }

        @Override
        public boolean canLearnFurnaceRecipes() {
            return false;
        }

        @Override
        public boolean canLearnLargeRecipes() {
            return true;
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            return this.canLearnCraftingRecipes() && recipe.getIntermediate() == Blocks.field_150350_a;
        }

        @Override
        @NotNull
        public String getId() {
            return "crafting";
        }
    }
}

