/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings.modules;

import com.google.common.collect.Lists;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IAssignsCitizen;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAssignedCitizenModule
extends AbstractBuildingModule
implements IAssignsCitizen,
IPersistentModule {
    protected final List<ICitizenData> assignedCitizen = Lists.newArrayList();
    private HiringMode hiringMode = HiringMode.DEFAULT;

    @Override
    public boolean removeCitizen(@NotNull ICitizenData citizen) {
        if (this.assignedCitizen.contains(citizen)) {
            this.assignedCitizen.remove(citizen);
            this.markDirty();
            this.onRemoval(citizen);
            return true;
        }
        this.onRemoval(citizen);
        return false;
    }

    @Override
    public boolean assignCitizen(ICitizenData citizen) {
        if (this.assignedCitizen.contains(citizen) || this.isFull() || citizen == null) {
            return false;
        }
        this.assignedCitizen.add(citizen);
        this.onAssignment(citizen);
        this.markDirty();
        return true;
    }

    abstract void onAssignment(ICitizenData var1);

    abstract void onRemoval(ICitizenData var1);

    @Override
    public List<ICitizenData> getAssignedCitizen() {
        return new ArrayList<ICitizenData>(this.assignedCitizen);
    }

    @Nullable
    public ICitizenData getFirstCitizen() {
        return this.assignedCitizen.isEmpty() ? null : this.assignedCitizen.get(0);
    }

    @Override
    public boolean isFull() {
        return this.assignedCitizen.size() >= this.getModuleMax();
    }

    @Override
    public boolean hasAssignedCitizen(ICitizenData citizen) {
        return this.assignedCitizen.contains(citizen);
    }

    @Override
    @Nullable
    public List<Optional<AbstractEntityCitizen>> getAssignedEntities() {
        return this.assignedCitizen.stream().filter(Objects::nonNull).map(ICitizenData::getEntity).collect(Collectors.toList());
    }

    @Override
    public final boolean hasAssignedCitizen() {
        return !this.assignedCitizen.isEmpty();
    }

    @Override
    public void serializeNBT(CompoundNBT compound) {
        CompoundNBT assignedCompound = new CompoundNBT();
        assignedCompound.func_74768_a("buildingHiringMode", this.hiringMode.ordinal());
        compound.func_218657_a("assigned", (INBT)assignedCompound);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        if (compound.func_74764_b("assigned")) {
            this.hiringMode = HiringMode.values()[compound.func_74775_l("assigned").func_74762_e("buildingHiringMode")];
        }
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        buf.writeInt(this.assignedCitizen.size());
        for (ICitizenData citizen : this.assignedCitizen) {
            buf.writeInt(citizen.getId());
        }
        buf.writeInt(this.hiringMode.ordinal());
    }

    @Override
    public void setHiringMode(HiringMode hiringMode) {
        this.hiringMode = hiringMode;
        this.markDirty();
    }

    @Override
    public HiringMode getHiringMode() {
        return this.hiringMode;
    }
}

