/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IBuildingContainer;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.coremod.blocks.BlockMinecoloniesRack;
import com.minecolonies.coremod.colony.buildings.AbstractSchematicProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuildingContainer
extends AbstractSchematicProvider
implements IBuildingContainer {
    protected final List<BlockPos> containerList = new ArrayList<BlockPos>();
    protected final Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> keepX = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>();
    protected AbstractTileEntityColonyBuilding tileEntity;
    private int unscaledPickUpPriority = 1;

    public AbstractBuildingContainer(BlockPos pos, IColony colony) {
        super(pos, colony);
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT containerTagList = compound.func_150295_c("Containers", 10);
        for (int i = 0; i < containerTagList.size(); ++i) {
            CompoundNBT containerCompound = containerTagList.func_150305_b(i);
            this.containerList.add(NBTUtil.func_186861_c((CompoundNBT)containerCompound));
        }
        if (compound.func_150296_c().contains("prio")) {
            this.unscaledPickUpPriority = compound.func_74762_e("prio");
        }
        if (compound.func_150296_c().contains("prioState") && compound.func_74762_e("prioState") == 0) {
            this.unscaledPickUpPriority = 0;
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        @NotNull ListNBT containerTagList = new ListNBT();
        for (BlockPos pos : this.containerList) {
            containerTagList.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
        }
        compound.func_218657_a("Containers", (INBT)containerTagList);
        compound.func_74768_a("prio", this.unscaledPickUpPriority);
        return compound;
    }

    @Override
    public int getPickUpPriority() {
        return this.unscaledPickUpPriority;
    }

    @Override
    public void alterPickUpPriority(int value) {
        this.unscaledPickUpPriority = MathHelper.func_76125_a((int)(this.unscaledPickUpPriority + value), (int)0, (int)AbstractDeliverymanRequestable.getMaxBuildingPriority(false));
    }

    @Override
    public void addContainerPosition(@NotNull BlockPos pos) {
        if (!this.containerList.contains(pos)) {
            this.containerList.add(pos);
        }
    }

    @Override
    public void removeContainerPosition(BlockPos pos) {
        this.containerList.remove(pos);
    }

    @Override
    public List<BlockPos> getContainers() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(this.containerList);
        list.add(this.getPosition());
        return list;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        this.registerBlockPosition(blockState.func_177230_c(), pos, world);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull World world) {
        if (block instanceof AbstractBlockHut) {
            TileEntity entity = world.func_175625_s(pos);
            if (entity instanceof TileEntityColonyBuilding) {
                ((TileEntityColonyBuilding)entity).setStyle(this.getStyle());
                ((TileEntityColonyBuilding)entity).setMirror(this.isMirrored());
                IBuilding building = this.colony.getBuildingManager().getBuilding(pos);
                if (building != null) {
                    building.setStyle(this.getStyle());
                    building.setParent(this.getID());
                    this.addChild(pos);
                }
            }
        } else if (block instanceof BlockMinecoloniesRack) {
            TileEntity entity;
            this.addContainerPosition(pos);
            if (block instanceof BlockMinecoloniesRack && (entity = world.func_175625_s(pos)) instanceof TileEntityRack) {
                ((TileEntityRack)entity).setBuildingPos(this.getID());
            }
        }
    }

    @Override
    public void setTileEntity(AbstractTileEntityColonyBuilding te) {
        this.tileEntity = te;
        if (te.isOutdated()) {
            this.safeUpdateTEDataFromSchematic();
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.getTileEntity() != null) {
            return this.tileEntity.getCapability(cap, side);
        }
        return LazyOptional.empty();
    }
}

