/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ISchematicProvider;
import com.minecolonies.api.colony.buildings.modules.IAltersRequiredItems;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICreatesResolversModule;
import com.minecolonies.api.colony.buildings.modules.IHasRequiredItemsModule;
import com.minecolonies.api.colony.buildings.modules.IMinimumStockModule;
import com.minecolonies.api.colony.buildings.modules.IModuleWithExternalBlocks;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ISettingsModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IRequestSystemBuildingDataStore;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Pickup;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.tileentities.TileEntityColonyBuilding;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.LoadOnlyStructureHandler;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingContainer;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.coremod.colony.buildings.modules.AbstractAssignedCitizenModule;
import com.minecolonies.coremod.colony.buildings.modules.LivingBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.coremod.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.coremod.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.coremod.colony.interactionhandling.RequestBasedInteraction;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.colony.requestsystem.management.IStandardRequestManager;
import com.minecolonies.coremod.colony.requestsystem.requesters.BuildingBasedRequester;
import com.minecolonies.coremod.colony.requestsystem.resolvers.BuildingRequestResolver;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuild;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildBuilding;
import com.minecolonies.coremod.colony.workorders.WorkOrderBuildRemoval;
import com.minecolonies.coremod.entity.ai.citizen.builder.ConstructionTapeHelper;
import com.minecolonies.coremod.entity.ai.citizen.deliveryman.EntityAIWorkDeliveryman;
import com.minecolonies.coremod.util.ChunkDataHelper;
import com.minecolonies.coremod.util.ColonyUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuilding
extends AbstractBuildingContainer {
    public static final ISettingKey<BoolSetting> BREEDING = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "breeding"));
    public static final ISettingKey<BoolSetting> FEEDING = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "feeding"));
    public static final int MAX_BUILD_HEIGHT = 256;
    public static final int MIN_BUILD_HEIGHT = 1;
    private IToken<?> rsDataStoreToken;
    private IRequester requester;
    private boolean isBuilt = false;
    private String customName = "";
    private boolean guardBuildingNear = false;
    private boolean recheckGuardBuildingNear = true;
    private boolean dirty = false;
    protected List<IBuildingModule> modules = new ArrayList<IBuildingModule>();

    protected AbstractBuilding(@NotNull IColony colony, BlockPos pos) {
        super(pos, colony);
        this.requester = (IRequester)StandardFactoryController.getInstance().getNewInstance(TypeToken.of(BuildingBasedRequester.class), this, new Object[0]);
        this.setupRsDataStore();
    }

    @Override
    public boolean hasModule(Class<? extends IBuildingModule> clazz) {
        for (IBuildingModule module : this.modules) {
            if (!clazz.isInstance(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public <T extends IBuildingModule> T getFirstModuleOccurance(Class<T> clazz) {
        for (IBuildingModule module : this.modules) {
            if (!clazz.isInstance(module)) continue;
            return (T)module;
        }
        throw new IllegalStateException("The module of class: " + clazz.toString() + "should never be null!");
    }

    @Override
    @NotNull
    public <T extends IBuildingModule> Optional<T> getFirstOptionalModuleOccurance(Class<T> clazz) {
        for (IBuildingModule module : this.modules) {
            if (!clazz.isInstance(module)) continue;
            return Optional.of(module);
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public <T extends IBuildingModule> T getModuleMatching(Class<T> clazz, Predicate<? super T> modulePredicate) {
        for (IBuildingModule module : this.modules) {
            if (!clazz.isInstance(module) || !modulePredicate.test(module)) continue;
            return (T)module;
        }
        return null;
    }

    @Override
    @NotNull
    public <T extends IBuildingModule> List<T> getModules(Class<T> clazz) {
        return this.modules.stream().filter(clazz::isInstance).map(c -> c).collect(Collectors.toList());
    }

    @Override
    public void registerModule(@NotNull IBuildingModule module) {
        this.modules.add(module);
    }

    @Override
    @NotNull
    public String getCustomBuildingName() {
        if (this.customName.isEmpty()) {
            return this.getSchematicName();
        }
        return this.customName;
    }

    @Override
    public void onWakeUp() {
        this.getModules(IBuildingEventsModule.class).forEach(IBuildingEventsModule::onWakeUp);
    }

    @Override
    public void onCleanUp(ICitizenData citizen) {
    }

    @Override
    public void onRestart(ICitizenData citizen) {
        citizen.setPaused(false);
    }

    @Override
    public void onPlayerEnterBuilding(PlayerEntity player) {
        this.getModules(IBuildingEventsModule.class).forEach(module -> module.onPlayerEnterBuilding(player));
    }

    @Override
    public void onPlayerEnterNearby(PlayerEntity player) {
        if (this.getBuildingLevel() == 0 || this.getSchematicName() == null || this.getSchematicName().isEmpty()) {
            return;
        }
        if (this.isInBuilding(player.func_233580_cy_())) {
            this.onPlayerEnterBuilding(player);
        }
    }

    @Override
    public void onPlacement() {
        ChunkDataHelper.claimColonyChunks(this.colony, true, this.getPosition(), this.getClaimRadius(this.getBuildingLevel()));
    }

    @Override
    public boolean isMatchingBlock(@NotNull Block block) {
        return this.getBuildingType().getBuildingBlock() == block;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        this.loadRequestSystemFromNBT(compound);
        if (compound.func_150296_c().contains("isBuilt")) {
            this.isBuilt = compound.func_74767_n("isBuilt");
        } else if (this.getBuildingLevel() > 0) {
            this.isBuilt = true;
        }
        if (compound.func_150296_c().contains("customName")) {
            this.customName = compound.func_74779_i("customName");
        }
        this.getModules(IPersistentModule.class).forEach(module -> module.deserializeNBT(compound));
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        ListNBT list = new ListNBT();
        for (IRequestResolver requestResolver : this.getResolvers()) {
            list.add((Object)StandardFactoryController.getInstance().serialize(requestResolver.getId()));
        }
        compound.func_218657_a("Resolver", (INBT)list);
        compound.func_74778_a("type", this.getBuildingType().getRegistryName().toString());
        this.writeRequestSystemToNBT(compound);
        compound.func_74757_a("isBuilt", this.isBuilt);
        compound.func_74778_a("customName", this.customName);
        this.getModules(IPersistentModule.class).forEach(module -> module.serializeNBT(compound));
        return compound;
    }

    @Override
    public final void destroy() {
        this.onDestroyed();
        this.colony.getBuildingManager().removeBuilding(this, this.colony.getPackageManager().getCloseSubscribers());
        this.colony.getRequestManager().getDataStoreManager().remove(this.rsDataStoreToken);
        for (BlockPos childpos : this.getChildren()) {
            IBuilding building = this.colony.getBuildingManager().getBuilding(childpos);
            if (building == null) continue;
            building.destroy();
        }
    }

    @Override
    public void onDestroyed() {
        AbstractTileEntityColonyBuilding tileEntityNew = this.getTileEntity();
        World world = this.colony.getWorld();
        Block block = world.func_180495_p(this.getPosition()).func_177230_c();
        if (tileEntityNew != null) {
            InventoryUtils.dropItemHandler((IItemHandler)tileEntityNew.getInventory(), world, tileEntityNew.getPosition().func_177958_n(), tileEntityNew.getPosition().func_177956_o(), tileEntityNew.getPosition().func_177952_p());
            world.func_175666_e(this.getPosition(), block);
        }
        ChunkDataHelper.claimColonyChunks(this.colony, false, this.getID(), this.getClaimRadius(this.getBuildingLevel()));
        ConstructionTapeHelper.removeConstructionTape(this.getCorners(), world);
        this.getModules(IBuildingEventsModule.class).forEach(IBuildingEventsModule::onDestroyed);
    }

    protected void requestWorkOrder(int level, BlockPos builder, boolean removal) {
        WorkOrderBuild workOrder;
        for (WorkOrderBuildBuilding o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildBuilding.class)) {
            if (!o.getSchematicLocation().equals((Object)this.getID())) continue;
            return;
        }
        if (removal) {
            if (!this.canDeconstruct()) {
                LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.builder.cantdeconstruct", (Object[])new Object[0]);
                return;
            }
            workOrder = new WorkOrderBuildRemoval(this, level);
        } else {
            workOrder = new WorkOrderBuildBuilding(this, level);
        }
        if (!(removal || this.canBeBuiltByBuilder(level) || workOrder.canBeResolved(this.colony, level))) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.builder.messagebuildernecessary", (Object[])new Object[]{Integer.toString(level)});
            return;
        }
        if (workOrder.tooFarFromAnyBuilder(this.colony, level) && builder.equals((Object)BlockPos.field_177992_a)) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.builder.messagebuilderstoofar", (Object[])new Object[0]);
            return;
        }
        if (((BlockPos)this.getCorners().func_76341_a()).func_177956_o() >= 256 || ((BlockPos)this.getCorners().func_76340_b()).func_177956_o() >= 256) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.builder.messagebuildtoohigh", (Object[])new Object[0]);
            return;
        }
        if (this.getPosition().func_177956_o() <= 1) {
            LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.builder.messagebuildtoolow", (Object[])new Object[0]);
            return;
        }
        if (!builder.equals((Object)BlockPos.field_177992_a)) {
            IBuilding building = this.colony.getBuildingManager().getBuilding(builder);
            if (building instanceof AbstractBuildingStructureBuilder && (building.getBuildingLevel() >= level || this.canBeBuiltByBuilder(level))) {
                workOrder.setClaimedBy(builder);
            } else {
                LanguageHandler.sendPlayersMessage(this.colony.getMessagePlayerEntities(), (String)"entity.builder.messagebuildernecessary", (Object[])new Object[]{Integer.toString(level)});
                return;
            }
        }
        this.colony.getWorkManager().addWorkOrder(workOrder, false);
        this.colony.getProgressManager().progressWorkOrderPlacement(workOrder);
        if (workOrder.getID() != 0) {
            LanguageHandler.sendPlayersMessage(this.colony.getImportantMessageEntityPlayers(), (String)"com.minecolonies.coremod.workorderadded", (Object[])new Object[]{workOrder.getDisplayName(), this.colony.getName(), workOrder.getSchematicLocation().func_177958_n(), workOrder.getSchematicLocation().func_177956_o(), workOrder.getSchematicLocation().func_177952_p()});
        }
        this.markDirty();
    }

    public boolean canDeconstruct() {
        return true;
    }

    @Override
    public boolean canBeBuiltByBuilder(int newLevel) {
        return false;
    }

    @Override
    public final void markDirty() {
        this.dirty = true;
        if (this.colony != null) {
            this.colony.getBuildingManager().markBuildingsDirty();
        }
    }

    @Override
    public final boolean isDirty() {
        for (IBuildingModule module : this.modules) {
            if (!module.checkDirty()) continue;
            return true;
        }
        return this.dirty;
    }

    @Override
    public final void clearDirty() {
        this.dirty = false;
        for (IBuildingModule module : this.modules) {
            module.clearDirty();
        }
    }

    @Override
    public void processOfflineTime(long time) {
    }

    @Override
    public boolean hasWorkOrder() {
        return this.getCurrentWorkOrderLevel() != -1;
    }

    private int getCurrentWorkOrderLevel() {
        for (WorkOrderBuildBuilding workOrderBuildBuilding : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildBuilding.class)) {
            if (!workOrderBuildBuilding.getSchematicLocation().equals((Object)this.getID())) continue;
            return workOrderBuildBuilding.getUpgradeLevel();
        }
        for (WorkOrderBuildRemoval workOrderBuildRemoval : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuildRemoval.class)) {
            if (!workOrderBuildRemoval.getSchematicLocation().equals((Object)this.getID())) continue;
            return 0;
        }
        return -1;
    }

    @Override
    public void removeWorkOrder() {
        for (WorkOrderBuild o : this.colony.getWorkManager().getWorkOrdersOfType(WorkOrderBuild.class)) {
            if (!o.getSchematicLocation().equals((Object)this.getID()) || !(o instanceof WorkOrderBuildBuilding) && !(o instanceof WorkOrderBuildRemoval)) continue;
            this.colony.getWorkManager().removeWorkOrder(o.getID());
            this.markDirty();
            BlockPos buildingPos = o.getClaimedBy();
            IBuilding building = this.colony.getBuildingManager().getBuilding(buildingPos);
            if (building != null) {
                for (AbstractAssignedCitizenModule module : building.getModules(AbstractAssignedCitizenModule.class)) {
                    for (ICitizenData citizen : module.getAssignedCitizen()) {
                        building.cancelAllRequestsOfCitizen(citizen);
                    }
                }
            }
            return;
        }
    }

    @Override
    public Set<ICitizenData> getAllAssignedCitizen() {
        HashSet<ICitizenData> citizens = new HashSet<ICitizenData>();
        for (AbstractAssignedCitizenModule module : this.getModules(AbstractAssignedCitizenModule.class)) {
            citizens.addAll(module.getAssignedCitizen());
        }
        return citizens;
    }

    @Override
    public int getClaimRadius(int newLevel) {
        switch (newLevel) {
            case 1: 
            case 2: 
            case 3: {
                return 1;
            }
            case 4: 
            case 5: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        buf.func_180714_a(this.getBuildingType().getRegistryName().toString());
        buf.writeInt(this.getBuildingLevel());
        buf.writeInt(this.getMaxBuildingLevel());
        buf.writeInt(this.getPickUpPriority());
        buf.writeInt(this.getCurrentWorkOrderLevel());
        buf.func_180714_a(this.getStyle());
        buf.func_180714_a(this.getSchematicName());
        buf.func_179255_a(this.getParent());
        buf.func_180714_a(this.customName);
        buf.writeInt(this.getRotation());
        buf.writeBoolean(this.isMirrored());
        buf.writeInt(this.getClaimRadius(this.getBuildingLevel()));
        CompoundNBT requestSystemCompound = new CompoundNBT();
        this.writeRequestSystemToNBT(requestSystemCompound);
        ImmutableCollection<IRequestResolver<?>> resolvers = this.getResolvers();
        buf.writeInt(resolvers.size());
        for (IRequestResolver resolver : resolvers) {
            buf.func_150786_a(StandardFactoryController.getInstance().serialize(resolver.getId()));
        }
        buf.func_150786_a(StandardFactoryController.getInstance().serialize(this.getId()));
        buf.writeInt(this.containerList.size());
        for (BlockPos blockPos : this.containerList) {
            buf.func_179255_a(blockPos);
        }
        buf.func_150786_a(requestSystemCompound);
        buf.writeBoolean(this.isDeconstructed());
        this.getModules(IPersistentModule.class).forEach(module -> module.serializeToView(buf));
    }

    @Override
    public void onColonyTick(IColony colony) {
        this.getModules(ITickingModule.class).forEach(module -> module.onColonyTick(colony));
    }

    public boolean isMinimumStockRequest(IRequest<? extends IDeliverable> request) {
        for (IMinimumStockModule module : this.getModules(IMinimumStockModule.class)) {
            if (!module.isMinimumStockRequest(request)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setCustomBuildingName(String name) {
        this.customName = name;
        this.markDirty();
    }

    @Override
    public boolean canBeGathered() {
        return true;
    }

    @Override
    public void requestUpgrade(PlayerEntity player, BlockPos builder) {
        ResourceLocation hutResearch = this.colony.getResearchManager().getResearchEffectIdFrom(this.getBuildingType().getBuildingBlock());
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().hasResearchEffect(hutResearch) && this.colony.getResearchManager().getResearchEffects().getEffectStrength(hutResearch) < 1.0) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.havetounlock"), player.func_110124_au());
            return;
        }
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().hasResearchEffect(hutResearch) && this.colony.getResearchManager().getResearchEffects().getEffectStrength(hutResearch) <= (double)this.getBuildingLevel()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.unlocktoupgrade"), player.func_110124_au());
            return;
        }
        IBuilding parentBuilding = this.colony.getBuildingManager().getBuilding(this.getParent());
        if (this.getBuildingLevel() < this.getMaxBuildingLevel() && (parentBuilding == null || this.getBuildingLevel() < parentBuilding.getBuildingLevel())) {
            this.requestWorkOrder(this.getBuildingLevel() + 1, builder, false);
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.worker.noupgrade"), player.func_110124_au());
        }
    }

    @Override
    public void requestRemoval(PlayerEntity player, BlockPos builder) {
        if (this.isDeconstructed()) {
            this.pickUp(player);
        } else {
            this.requestWorkOrder(this.getBuildingLevel(), builder, true);
        }
    }

    @Override
    public void pickUp(PlayerEntity player) {
        if (this.hasParent()) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.gui.workerhuts.pickup.denied", (Object[])new Object[0]);
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)this.colony.getWorld().func_180495_p(this.getPosition()).func_177230_c(), 1);
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("colony", this.colony.getID());
        compoundNBT.func_74768_a("otherLevel", this.getBuildingLevel());
        stack.func_77982_d(compoundNBT);
        if (InventoryUtils.addItemStackToProvider((ICapabilityProvider)player, stack)) {
            this.destroy();
            this.colony.getWorld().func_175655_b(this.getPosition(), false);
        } else {
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.playerinvfull", (Object[])new Object[0]);
        }
    }

    @Override
    public void requestRepair(BlockPos builder) {
        if (this.getBuildingLevel() > 0) {
            this.requestWorkOrder(this.getBuildingLevel(), builder, false);
        }
    }

    @Override
    public boolean isBuilt() {
        return this.isBuilt;
    }

    @Override
    public void deconstruct() {
        Tuple<BlockPos, BlockPos> tuple = this.getCorners();
        for (int x = ((BlockPos)tuple.func_76341_a()).func_177958_n(); x < ((BlockPos)tuple.func_76340_b()).func_177958_n(); ++x) {
            for (int z = ((BlockPos)tuple.func_76341_a()).func_177952_p(); z < ((BlockPos)tuple.func_76340_b()).func_177952_p(); ++z) {
                for (int y = ((BlockPos)tuple.func_76341_a()).func_177956_o(); y < ((BlockPos)tuple.func_76340_b()).func_177956_o(); ++y) {
                    this.colony.getWorld().func_175655_b(new BlockPos(x, y, z), false);
                }
            }
        }
    }

    @Override
    public AbstractTileEntityColonyBuilding getTileEntity() {
        if (this.tileEntity != null && this.tileEntity.func_145837_r()) {
            this.tileEntity = null;
        }
        if (this.tileEntity == null && this.colony != null && this.colony.getWorld() != null && this.getPosition() != null && WorldUtil.isBlockLoaded((IWorld)this.colony.getWorld(), this.getPosition()) && !(this.colony.getWorld().func_180495_p(this.getPosition()).func_177230_c() instanceof AirBlock) && this.colony.getWorld().func_180495_p(this.getPosition()).func_177230_c() instanceof AbstractBlockHut) {
            TileEntity te = this.colony.getWorld().func_175625_s(this.getPosition());
            if (te instanceof TileEntityColonyBuilding) {
                this.tileEntity = (TileEntityColonyBuilding)te;
                if (this.tileEntity.getBuilding() == null) {
                    this.tileEntity.setColony(this.colony);
                    this.tileEntity.setBuilding(this);
                }
            } else {
                Log.getLogger().error("Somehow the wrong TileEntity is at the location where the building should be!", (Throwable)new Exception());
                Log.getLogger().error("Trying to restore order!");
                TileEntityColonyBuilding tileEntityColonyBuilding = new TileEntityColonyBuilding(MinecoloniesTileEntities.BUILDING);
                this.colony.getWorld().func_175690_a(this.getPosition(), (TileEntity)tileEntityColonyBuilding);
                this.tileEntity = tileEntityColonyBuilding;
            }
        }
        return this.tileEntity;
    }

    @Override
    public void onUpgradeComplete(int newLevel) {
        this.cachedRotation = -1;
        ChunkDataHelper.claimColonyChunks(this.colony, true, this.getID(), this.getClaimRadius(newLevel));
        this.recheckGuardBuildingNear = true;
        ConstructionTapeHelper.removeConstructionTape(this.getCorners(), this.colony.getWorld());
        this.colony.getProgressManager().progressBuildBuilding(this, this.colony.getBuildingManager().getBuildings().values().stream().filter(building -> building.hasModule(WorkerBuildingModule.class)).mapToInt(ISchematicProvider::getBuildingLevel).sum(), this.colony.getBuildingManager().getBuildings().values().stream().filter(building -> building.hasModule(LivingBuildingModule.class)).mapToInt(ISchematicProvider::getBuildingLevel).sum());
        this.calculateCorners();
        this.isBuilt = true;
        this.getModules(IBuildingEventsModule.class).forEach(module -> module.onUpgradeComplete(newLevel));
        this.colony.getResearchManager().checkAutoStartResearch();
    }

    @Override
    public void calculateCorners() {
        AbstractTileEntityColonyBuilding te = this.getTileEntity();
        if (te != null && !te.getSchematicName().isEmpty()) {
            this.setCorners((BlockPos)te.getInWorldCorners().func_76341_a(), (BlockPos)te.getInWorldCorners().func_76340_b());
            return;
        }
        WorkOrderBuildBuilding workOrder = new WorkOrderBuildBuilding(this, Math.max(1, this.getBuildingLevel()));
        LoadOnlyStructureHandler wrapper = new LoadOnlyStructureHandler(this.colony.getWorld(), this.getPosition(), workOrder.getStructureName(), new PlacementSettings(), true);
        if (!wrapper.hasBluePrint()) {
            this.setCorners(this.getPosition(), this.getPosition());
            return;
        }
        Tuple<BlockPos, BlockPos> corners = ColonyUtils.calculateCorners(this.getPosition(), this.colony.getWorld(), wrapper.getBluePrint(), workOrder.getRotation(this.colony.getWorld()), workOrder.isMirrored());
        this.setCorners((BlockPos)corners.func_76341_a(), (BlockPos)corners.func_76340_b());
    }

    @Override
    public boolean isGuardBuildingNear() {
        if (this.recheckGuardBuildingNear) {
            this.guardBuildingNear = this.colony.getBuildingManager().hasGuardBuildingNear(this);
            this.recheckGuardBuildingNear = false;
        }
        return this.guardBuildingNear;
    }

    @Override
    public void resetGuardBuildingNear() {
        this.recheckGuardBuildingNear = true;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory) {
        for (Map.Entry<Predicate<ItemStack>, Tuple<Integer, Boolean>> entry : this.getRequiredItemsAndAmount().entrySet()) {
            if (inventory && !((Boolean)entry.getValue().func_76340_b()).booleanValue() || !entry.getKey().test(stack)) continue;
            ItemStorage kept = ItemStorage.getItemStackOfListMatchingPredicate(localAlreadyKept, entry.getKey());
            int toKeep = (Integer)entry.getValue().func_76341_a();
            int rest = stack.func_190916_E() - toKeep;
            if (kept != null) {
                if (kept.getAmount() >= toKeep && !ItemStackUtils.isBetterTool(stack, kept.getItemStack())) {
                    return stack.func_190916_E();
                }
                rest = kept.getAmount() + stack.func_190916_E() - toKeep;
                localAlreadyKept.remove(kept);
                kept.setAmount(kept.getAmount() + ItemStackUtils.getSize(stack) - Math.max(0, rest));
                localAlreadyKept.add(kept);
            } else {
                ItemStorage newStorage = new ItemStorage(stack);
                newStorage.setAmount(ItemStackUtils.getSize(stack) - Math.max(0, rest));
                localAlreadyKept.add(newStorage);
            }
            if (rest <= 0) {
                return 0;
            }
            return Math.min(rest, ItemStackUtils.getSize(stack));
        }
        return stack.func_190916_E();
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(this.keepX);
        HashMap<ItemStorage, Tuple> requiredItems = new HashMap<ItemStorage, Tuple>();
        ImmutableCollection<IRequestResolver<?>> resolvers = this.getResolvers();
        for (IRequestResolver resolver : resolvers) {
            IStandardRequestManager requestManager = (IStandardRequestManager)this.colony.getRequestManager();
            List deliverableRequests = requestManager.getRequestHandler().getRequestsMadeByRequester(resolver).stream().filter(iRequest -> iRequest.getRequest() instanceof IDeliverable).map(iRequest -> iRequest).collect(Collectors.toList());
            for (IRequest request : deliverableRequests) {
                for (ItemStack item : request.getDeliveries()) {
                    ItemStorage output = new ItemStorage(item);
                    int amount = output.getAmount();
                    if (requiredItems.containsKey(output)) {
                        amount += ((Integer)((Tuple)requiredItems.get(output)).func_76341_a()).intValue();
                    }
                    requiredItems.put(output, new Tuple((Object)amount, (Object)false));
                }
            }
        }
        toKeep.putAll(requiredItems.entrySet().stream().collect(Collectors.toMap(key -> stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, ((ItemStorage)key.getKey()).getItemStack()), Map.Entry::getValue)));
        if (this.keepFood()) {
            toKeep.put(stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && this.canEat((ItemStack)stack), new Tuple((Object)(this.getBuildingLevel() * 2), (Object)true));
        }
        for (IHasRequiredItemsModule module2 : this.getModules(IHasRequiredItemsModule.class)) {
            toKeep.putAll(module2.getRequiredItemsAndAmount());
        }
        this.getModules(IAltersRequiredItems.class).forEach(module -> module.alterItemsToBeKept((TriConsumer<Predicate<ItemStack>, Integer, Boolean>)((TriConsumer)(stack, qty, inv) -> toKeep.put((Predicate<ItemStack>)stack, (Tuple<Integer, Boolean>)new Tuple(qty, inv)))));
        return toKeep;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        return stack.func_77973_b().func_219967_s().func_221466_a() >= this.getBuildingLevel();
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public List<IItemHandler> getHandlers() {
        if (this.getAllAssignedCitizen().isEmpty() || this.colony == null || this.colony.getWorld() == null) {
            return Collections.emptyList();
        }
        HashSet<InventoryCitizen> handlers = new HashSet<InventoryCitizen>();
        for (ICitizenData workerEntity : this.getAllAssignedCitizen()) {
            handlers.add(workerEntity.getInventory());
        }
        TileEntity entity = this.colony.getWorld().func_175625_s(this.getID());
        if (entity != null) {
            LazyOptional handler = entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            handler.ifPresent(handlers::add);
        }
        return ImmutableList.copyOf(handlers);
    }

    @Override
    public <T extends ISetting> T getSetting(@NotNull ISettingKey<T> key) {
        return this.getFirstModuleOccurance(ISettingsModule.class).getSetting(key);
    }

    public ICraftingBuildingModule getCraftingModuleForRecipe(IToken<?> token) {
        for (ICraftingBuildingModule module : this.getModules(ICraftingBuildingModule.class)) {
            if (!module.holdsRecipe(token)) continue;
            return module;
        }
        return null;
    }

    protected boolean keepFood() {
        return true;
    }

    @Override
    @Nullable
    public ItemStack forceTransferStack(ItemStack stack, World world) {
        if (this.getTileEntity() == null) {
            for (BlockPos pos : this.containerList) {
                TileEntity tempTileEntity = world.func_175625_s(pos);
                if (!(tempTileEntity instanceof ChestTileEntity) || InventoryUtils.isProviderFull((ICapabilityProvider)tempTileEntity)) continue;
                return this.forceItemStackToProvider((ICapabilityProvider)tempTileEntity, stack);
            }
        } else {
            return this.forceItemStackToProvider((ICapabilityProvider)this.getTileEntity(), stack);
        }
        return stack;
    }

    @Nullable
    private ItemStack forceItemStackToProvider(@NotNull ICapabilityProvider provider, @NotNull ItemStack itemStack) {
        ArrayList localAlreadyKept = new ArrayList();
        return InventoryUtils.forceItemStackToProvider(provider, itemStack, stack -> EntityAIWorkDeliveryman.workerRequiresItem(this, stack, localAlreadyKept) != stack.func_190916_E());
    }

    @Override
    public boolean isItemStackInRequest(@Nullable ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        for (AbstractAssignedCitizenModule module : this.getModules(AbstractAssignedCitizenModule.class)) {
            for (ICitizenData citizen : module.getAssignedCitizen()) {
                for (IRequest<?> request : this.getOpenRequests(citizen.getId())) {
                    for (ItemStack deliveryStack : request.getDeliveries()) {
                        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(deliveryStack, stack, false, true)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected void writeRequestSystemToNBT(CompoundNBT compound) {
        compound.func_218657_a("Requestor", (INBT)StandardFactoryController.getInstance().serialize(this.requester));
        compound.func_218657_a("DataStoreToken", (INBT)StandardFactoryController.getInstance().serialize(this.rsDataStoreToken));
    }

    protected void setupRsDataStore() {
        this.rsDataStoreToken = this.colony.getRequestManager().getDataStoreManager().get(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE).getId();
    }

    private void loadRequestSystemFromNBT(CompoundNBT compound) {
        this.requester = compound.func_150296_c().contains("Requestor") ? (IRequester)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("Requestor")) : (IRequester)StandardFactoryController.getInstance().getNewInstance(TypeToken.of(BuildingBasedRequester.class), this, new Object[0]);
        if (compound.func_150296_c().contains("DataStoreToken")) {
            this.rsDataStoreToken = (IToken)StandardFactoryController.getInstance().deserialize(compound.func_74775_l("DataStoreToken"));
        } else {
            this.setupRsDataStore();
        }
    }

    private IRequestSystemBuildingDataStore getDataStore() {
        return this.colony.getRequestManager().getDataStoreManager().get(this.rsDataStoreToken, TypeConstants.REQUEST_SYSTEM_BUILDING_DATA_STORE);
    }

    @Override
    public Map<TypeToken<?>, Collection<IToken<?>>> getOpenRequestsByRequestableType() {
        return this.getDataStore().getOpenRequestsByRequestableType();
    }

    protected Map<Integer, Collection<IToken<?>>> getOpenRequestsByCitizen() {
        return this.getDataStore().getOpenRequestsByCitizen();
    }

    private Map<Integer, Collection<IToken<?>>> getCompletedRequestsByCitizen() {
        return this.getDataStore().getCompletedRequestsByCitizen();
    }

    private Map<IToken<?>, Integer> getCitizensByRequest() {
        return this.getDataStore().getCitizensByRequest();
    }

    @Override
    public <R extends IRequestable> IToken<?> createRequest(@NotNull ICitizenData citizenData, @NotNull R requested, boolean async) {
        IToken<?> requestToken = this.colony.getRequestManager().createRequest(this.requester, requested);
        IRequest<?> request = this.colony.getRequestManager().getRequestForToken(requestToken);
        if (async) {
            citizenData.getJob().getAsyncRequests().add(requestToken);
            citizenData.triggerInteraction(new RequestBasedInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.requestsystem.playerresolver.async", new Object[]{request.getShortDisplayString()}), ChatPriority.PENDING, (ITextComponent)new TranslationTextComponent("com.minecolonies.requestsystem.playerresolver.normal"), (IToken<?>)request.getId()));
        } else {
            citizenData.triggerInteraction(new RequestBasedInteraction((ITextComponent)new TranslationTextComponent("com.minecolonies.requestsystem.playerresolver.normal", new Object[]{request.getShortDisplayString()}), ChatPriority.BLOCKING, (ITextComponent)new TranslationTextComponent("com.minecolonies.requestsystem.playerresolver.normal"), (IToken<?>)request.getId()));
        }
        this.addRequestToMaps(citizenData.getId(), requestToken, TypeToken.of(requested.getClass()));
        this.colony.getRequestManager().assignRequest(requestToken);
        this.markDirty();
        return requestToken;
    }

    @Override
    public <R extends IRequestable> IToken<?> createRequest(@NotNull R requested, boolean async) {
        IToken<?> requestToken = this.colony.getRequestManager().createRequest(this.requester, requested);
        this.addRequestToMaps(-1, requestToken, TypeToken.of(requested.getClass()));
        this.colony.getRequestManager().assignRequest(requestToken);
        this.markDirty();
        return requestToken;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull World world) {
        super.registerBlockPosition(blockState, pos, world);
        this.getModules(IModuleWithExternalBlocks.class).forEach(module -> module.onBlockPlacedInBuilding(blockState, pos, world));
    }

    private void addRequestToMaps(int citizenId, @NotNull IToken<?> requestToken, @NotNull TypeToken<?> requested) {
        if (!this.getOpenRequestsByRequestableType().containsKey(requested)) {
            this.getOpenRequestsByRequestableType().put(requested, new ArrayList());
        }
        this.getOpenRequestsByRequestableType().get(requested).add(requestToken);
        this.getCitizensByRequest().put(requestToken, citizenId);
        if (!this.getOpenRequestsByCitizen().containsKey(citizenId)) {
            this.getOpenRequestsByCitizen().put(citizenId, new ArrayList());
        }
        this.getOpenRequestsByCitizen().get(citizenId).add(requestToken);
    }

    @Override
    public boolean hasWorkerOpenRequests(int citizenId) {
        return this.getOpenRequestsByCitizen().containsKey(citizenId) && !this.getOpenRequestsByCitizen().get(citizenId).isEmpty();
    }

    @Override
    public Collection<IRequest<?>> getOpenRequests(int citizenId) {
        if (!this.getOpenRequestsByCitizen().containsKey(citizenId)) {
            return ImmutableList.of();
        }
        Collection<IToken<?>> tokens = this.getOpenRequestsByCitizen().get(citizenId);
        ArrayList requests = new ArrayList(tokens.size());
        for (IToken<?> token : tokens) {
            IRequest<?> request = this.colony.getRequestManager().getRequestForToken(token);
            if (request == null) continue;
            requests.add(request);
        }
        return Collections.unmodifiableList(requests);
    }

    @Override
    public boolean hasWorkerOpenRequestsFiltered(int citizenId, @NotNull Predicate<IRequest<?>> selectionPredicate) {
        return this.getOpenRequests(citizenId).stream().anyMatch(selectionPredicate);
    }

    @Override
    public boolean hasOpenSyncRequest(@NotNull ICitizenData citizen) {
        if (!this.hasWorkerOpenRequests(citizen.getId())) {
            return false;
        }
        for (IToken<?> token : this.getOpenRequestsByCitizen().get(citizen.getId())) {
            if (citizen.isRequestAsync(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <R> boolean hasWorkerOpenRequestsOfType(int citizenId, TypeToken<R> requestType) {
        return !this.getOpenRequestsOfType(citizenId, requestType).isEmpty();
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfType(int citizenId, TypeToken<R> requestType) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenId).stream().filter(request -> request.getType().isSubtypeOf(requestType)).map(request -> request).iterator());
    }

    @Override
    public boolean createPickupRequest(int scaledPriority) {
        if (scaledPriority < 0 || scaledPriority > AbstractDeliverymanRequestable.getPlayerActionPriority(true)) {
            return false;
        }
        ArrayList reqs = new ArrayList(this.getOpenRequestsByRequestableType().getOrDefault(TypeConstants.PICKUP, Collections.emptyList()));
        if (!reqs.isEmpty()) {
            for (IToken req : reqs) {
                IRequestResolver<?> resolver;
                IRequest<?> request = this.colony.getRequestManager().getRequestForToken(req);
                if (request == null || request.getState() != RequestState.IN_PROGRESS || !((resolver = this.colony.getRequestManager().getResolverForRequest(req)) instanceof IPlayerRequestResolver) && !(resolver instanceof IRetryingRequestResolver)) continue;
                this.colony.getRequestManager().reassignRequest(req, Collections.emptyList());
            }
            return false;
        }
        this.createRequest(new Pickup(scaledPriority), true);
        return true;
    }

    @Override
    public boolean hasCitizenCompletedRequests(@NotNull ICitizenData data) {
        return this.getCompletedRequestsByCitizen().containsKey(data.getId()) && !this.getCompletedRequestsByCitizen().get(data.getId()).isEmpty();
    }

    @Override
    public boolean hasCitizenCompletedRequestsToPickup(@NotNull ICitizenData data) {
        if (!this.getCompletedRequestsByCitizen().containsKey(data.getId())) {
            return false;
        }
        for (IToken<?> token : this.getCompletedRequestsByCitizen().get(data.getId())) {
            if (data.isRequestAsync(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<IRequest<?>> getCompletedRequests(@NotNull ICitizenData data) {
        Collection<IToken<?>> tokens = this.getCompletedRequestsByCitizen().get(data.getId());
        if (tokens == null || tokens.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList requests = new ArrayList(tokens.size());
        for (IToken<?> token : tokens) {
            IRequest<?> request = this.colony.getRequestManager().getRequestForToken(token);
            if (request != null) {
                requests.add(request);
                continue;
            }
            this.getCompletedRequestsByCitizen().get(data.getId()).remove(token);
            if (!this.getCompletedRequestsByCitizen().get(data.getId()).isEmpty()) continue;
            this.getCompletedRequestsByCitizen().remove(data.getId());
        }
        return Collections.unmodifiableList(requests);
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfType(@NotNull ICitizenData citizenData, TypeToken<R> requestType) {
        return ImmutableList.copyOf(this.getCompletedRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf(requestType)).map(request -> request).iterator());
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getCompletedRequestsOfTypeFiltered(@NotNull ICitizenData citizenData, TypeToken<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getCompletedRequests(citizenData).stream().filter(request -> request.getType().isSubtypeOf(requestType)).map(request -> request).filter(filter).iterator());
    }

    @Override
    public void markRequestAsAccepted(@NotNull ICitizenData data, @NotNull IToken<?> token) {
        if (!this.getCompletedRequestsByCitizen().containsKey(data.getId()) || !this.getCompletedRequestsByCitizen().get(data.getId()).contains(token)) {
            throw new IllegalArgumentException("The given token " + token + " is not known as a completed request waiting for acceptance by the citizen.");
        }
        this.getCompletedRequestsByCitizen().get(data.getId()).remove(token);
        if (this.getCompletedRequestsByCitizen().get(data.getId()).isEmpty()) {
            this.getCompletedRequestsByCitizen().remove(data.getId());
        }
        this.colony.getRequestManager().updateRequestState(token, RequestState.RECEIVED);
        this.markDirty();
    }

    @Override
    public void cancelAllRequestsOfCitizen(@NotNull ICitizenData data) {
        this.getOpenRequests(data.getId()).forEach(request -> {
            this.colony.getRequestManager().updateRequestState((IToken<?>)request.getId(), RequestState.CANCELLED);
            if (this.getOpenRequestsByRequestableType().containsKey(TypeToken.of(request.getRequest().getClass()))) {
                this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).remove(request.getId());
                if (this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).isEmpty()) {
                    this.getOpenRequestsByRequestableType().remove(TypeToken.of(request.getRequest().getClass()));
                }
            }
            this.getCitizensByRequest().remove(request.getId());
        });
        this.getCompletedRequests(data).forEach(request -> this.colony.getRequestManager().updateRequestState((IToken<?>)request.getId(), RequestState.RECEIVED));
        this.getOpenRequestsByCitizen().remove(data.getId());
        this.getCompletedRequestsByCitizen().remove(data.getId());
        this.markDirty();
    }

    @Override
    public void overruleNextOpenRequestWithStack(@NotNull ItemStack stack) {
        IRequest<? extends IDeliverable> target;
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return;
        }
        ImmutableCollection<IRequestResolver<?>> resolvers = this.getResolvers();
        ImmutableList<IToken<?>> playerRequests = this.colony.getRequestManager().getPlayerResolver().getAllAssignedRequests();
        ImmutableList<IToken<?>> retryingRequests = this.colony.getRequestManager().getRetryingRequestResolver().getAllAssignedRequests();
        for (IRequestResolver resolver : resolvers) {
            IStandardRequestManager requestManager = (IStandardRequestManager)this.colony.getRequestManager();
            List<IRequest<? extends IDeliverable>> deliverableRequests = requestManager.getRequestHandler().getRequestsMadeByRequester(resolver).stream().filter(iRequest -> iRequest.getRequest() instanceof IDeliverable).map(iRequest -> iRequest).collect(Collectors.toList());
            target = this.getFirstOverullingRequestFromInputList(deliverableRequests, stack);
            if (target == null || !this.isRequestStuck(target, (List<IToken<?>>)playerRequests, (List<IToken<?>>)retryingRequests)) continue;
            this.colony.getRequestManager().overruleRequest((IToken<?>)target.getId(), stack.func_77946_l());
            return;
        }
        Set<Integer> citizenIdsWithRequests = this.getOpenRequestsByCitizen().keySet();
        for (int citizenId : citizenIdsWithRequests) {
            ICitizenData data = this.colony.getCitizenManager().getCivilian(citizenId);
            if (data == null || (target = this.getFirstOverullingRequestFromInputList((Collection<IRequest<? extends IDeliverable>>)this.getOpenRequestsOfType(data.getId(), TypeConstants.DELIVERABLE), stack)) == null || !this.isRequestStuck(target, (List<IToken<?>>)playerRequests, (List<IToken<?>>)retryingRequests)) continue;
            this.colony.getRequestManager().overruleRequest((IToken<?>)target.getId(), stack.func_77946_l());
            return;
        }
    }

    private boolean isRequestStuck(IRequest<?> target, List<IToken<?>> playerResolverRequests, List<IToken<?>> retryingRequests) {
        if (playerResolverRequests.contains(target.getId()) || retryingRequests.contains(target.getId())) {
            return true;
        }
        for (IToken child : target.getChildren()) {
            if (!this.isRequestStuck(this.colony.getRequestManager().getRequestForToken(child), playerResolverRequests, retryingRequests)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <R> ImmutableList<IRequest<? extends R>> getOpenRequestsOfTypeFiltered(@NotNull ICitizenData citizenData, TypeToken<R> requestType, Predicate<IRequest<? extends R>> filter) {
        return ImmutableList.copyOf(this.getOpenRequests(citizenData.getId()).stream().filter(request -> request.getType().isSubtypeOf(requestType)).map(request -> request).filter(filter).iterator());
    }

    @Override
    public boolean overruleNextOpenRequestOfCitizenWithStack(@NotNull ICitizenData citizenData, @NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return false;
        }
        IRequest<? extends IDeliverable> target = this.getFirstOverullingRequestFromInputList((Collection<IRequest<? extends IDeliverable>>)this.getOpenRequestsOfType(citizenData.getId(), TypeConstants.DELIVERABLE), stack);
        if (target == null) {
            AbstractJobCrafter crafterJob;
            if (citizenData.getJob() instanceof AbstractJobCrafter && !(crafterJob = citizenData.getJob(AbstractJobCrafter.class)).getAssignedTasks().isEmpty()) {
                List<IToken<?>> assignedTasks = crafterJob.getAssignedTasks();
                IRequest deliverableChildRequest = assignedTasks.stream().map(this.colony.getRequestManager()::getRequestForToken).map(IRequest::getChildren).flatMap(Collection::stream).map(this.colony.getRequestManager()::getRequestForToken).filter(iRequest -> iRequest.getRequest() instanceof IDeliverable).filter(iRequest -> ((IDeliverable)iRequest.getRequest()).matches(stack)).findFirst().map(iRequest -> iRequest).orElse(null);
                if (deliverableChildRequest != null) {
                    deliverableChildRequest.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.of((Object)stack));
                    this.colony.getRequestManager().overruleRequest((IToken<?>)deliverableChildRequest.getId(), stack.func_77946_l());
                    return true;
                }
            }
            return false;
        }
        try {
            target.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.of((Object)stack));
            this.colony.getRequestManager().overruleRequest((IToken<?>)target.getId(), stack.func_77946_l());
        }
        catch (Exception ex) {
            Log.getLogger().error("Error during overruling", (Throwable)ex);
            Log.getLogger().error(target.getId().toString() + " " + target.getState().name() + " " + target.getShortDisplayString().toString());
            return false;
        }
        return true;
    }

    private IRequest<? extends IDeliverable> getFirstOverullingRequestFromInputList(@NotNull Collection<IRequest<? extends IDeliverable>> queue, @NotNull ItemStack stack) {
        if (queue.isEmpty()) {
            return null;
        }
        ArrayList validRequesterTokens = Lists.newArrayList();
        validRequesterTokens.add(this.getId());
        this.getResolvers().forEach(iRequestResolver -> validRequesterTokens.add(iRequestResolver.getId()));
        return queue.stream().filter(request -> request.getState() == RequestState.IN_PROGRESS && validRequesterTokens.contains(request.getRequester().getId()) && ((IDeliverable)request.getRequest()).matches(stack)).findFirst().orElse(null);
    }

    @Override
    public IToken<?> getId() {
        return this.requester.getId();
    }

    @Override
    public final ImmutableCollection<IRequestResolver<?>> getResolvers() {
        IStandardRequestManager requestManager = (IStandardRequestManager)this.colony.getRequestManager();
        if (!requestManager.getProviderHandler().getRegisteredResolvers(this).isEmpty()) {
            return ImmutableList.copyOf((Collection)requestManager.getProviderHandler().getRegisteredResolvers(this).stream().map(token -> requestManager.getResolverHandler().getResolver((IToken<?>)token)).collect(Collectors.toList()));
        }
        return this.createResolvers();
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ICreatesResolversModule module : this.getModules(ICreatesResolversModule.class)) {
            builder.addAll(module.createResolvers());
        }
        builder.add((Object)new BuildingRequestResolver(this.getRequester().getLocation(), this.colony.getRequestManager().getFactoryController().getNewInstance(TypeConstants.ITOKEN)));
        return builder.build();
    }

    @Override
    public IRequester getRequester() {
        return this.requester;
    }

    @Override
    @NotNull
    public ILocation getLocation() {
        return this.getRequester().getLocation();
    }

    @Override
    public void onRequestedRequestComplete(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        if (!this.getCitizensByRequest().containsKey(request.getId())) {
            return;
        }
        int citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        if (this.getOpenRequestsByCitizen().containsKey(citizenThatRequested)) {
            this.getOpenRequestsByCitizen().get(citizenThatRequested).remove(request.getId());
            if (this.getOpenRequestsByCitizen().get(citizenThatRequested).isEmpty()) {
                this.getOpenRequestsByCitizen().remove(citizenThatRequested);
            }
        }
        this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).remove(request.getId());
        if (this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).isEmpty()) {
            this.getOpenRequestsByRequestableType().remove(TypeToken.of(request.getRequest().getClass()));
        }
        if (citizenThatRequested >= 0) {
            this.getCompletedRequestsByCitizen().computeIfAbsent(citizenThatRequested, ArrayList::new).add(request.getId());
        } else {
            this.colony.getRequestManager().updateRequestState((IToken<?>)request.getId(), RequestState.RECEIVED);
        }
        this.markDirty();
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        int citizenThatRequested = this.getCitizensByRequest().remove(request.getId());
        Map<Integer, Collection<IToken<?>>> openRequestsByCitizen = this.getOpenRequestsByCitizen();
        Collection<IToken<?>> byCitizenList = openRequestsByCitizen.get(citizenThatRequested);
        if (byCitizenList != null) {
            byCitizenList.remove(request.getId());
            if (byCitizenList.isEmpty()) {
                openRequestsByCitizen.remove(citizenThatRequested);
            }
        }
        if (this.getOpenRequestsByRequestableType().containsKey(TypeToken.of(request.getRequest().getClass()))) {
            this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).remove(request.getId());
            if (this.getOpenRequestsByRequestableType().get(TypeToken.of(request.getRequest().getClass())).isEmpty()) {
                this.getOpenRequestsByRequestableType().remove(TypeToken.of(request.getRequest().getClass()));
            }
        }
        if (this.colony.getCitizenManager().getCivilian(citizenThatRequested) != null) {
            this.colony.getCitizenManager().getCivilian(citizenThatRequested).onRequestCancelled((IToken<?>)request.getId());
        }
        this.markDirty();
    }

    @Override
    @NotNull
    public IFormattableTextComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        int citizenId = this.getCitizensByRequest().get(request.getId());
        if (!this.getCitizensByRequest().containsKey(citizenId)) {
            return new StringTextComponent("<UNKNOWN>");
        }
        ICitizenData citizenData = this.colony.getCitizenManager().getCivilian(citizenId);
        if (citizenData.getJob() == null) {
            return new StringTextComponent(citizenData.getName());
        }
        TranslationTextComponent jobName = new TranslationTextComponent(citizenData.getJob().getJobRegistryEntry().getTranslationKey().toLowerCase());
        return jobName.func_230529_a_((ITextComponent)new StringTextComponent(" " + citizenData.getName()));
    }

    @Override
    public Optional<ICitizenData> getCitizenForRequest(@NotNull IToken<?> token) {
        if (!this.getCitizensByRequest().containsKey(token) || this.colony == null) {
            return Optional.empty();
        }
        int citizenID = this.getCitizensByRequest().get(token);
        if (citizenID == -1 || this.colony.getCitizenManager().getCivilian(citizenID) == null) {
            return Optional.empty();
        }
        return Optional.of(this.colony.getCitizenManager().getCivilian(citizenID));
    }

    @Override
    public Map<ItemStorage, Integer> reservedStacks() {
        HashMap<ItemStorage, Integer> map = new HashMap<ItemStorage, Integer>();
        for (IHasRequiredItemsModule module : this.getModules(IHasRequiredItemsModule.class)) {
            for (Map.Entry<ItemStorage, Integer> content : module.reservedStacks().entrySet()) {
                int current = map.getOrDefault(content.getKey(), 0);
                map.put(content.getKey(), current + content.getValue());
            }
        }
        return map;
    }
}

