/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui.containers;

import com.minecolonies.api.inventory.container.ContainerRack;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WindowRack
extends ContainerScreen<ContainerRack> {
    private static final ResourceLocation CHEST_GUI_TEXTURE = new ResourceLocation("minecolonies", "textures/gui/generic_108.png");
    private static final String LOCATION = "textures/gui/gui%s.png";
    private static final int TEXTURE_SIZE = 350;
    private static final int GOOD_SIZE = 8;
    private static final int Y_OFFSET = 114;
    private static final int TEXTURE_HEIGHT = 96;
    private static final int TEXTURE_OFFSET = 235;
    private final IItemHandler jointChestInventory;
    private final int inventoryRows;

    public WindowRack(ContainerRack container, PlayerInventory playerInventory, ITextComponent iTextComponent) {
        super((Container)container, playerInventory, iTextComponent);
        this.jointChestInventory = container.neighborRack != null ? (container.rack.isMain() ? new CombinedInvWrapper(new IItemHandlerModifiable[]{container.rack.getInventory(), container.neighborRack.getInventory()}) : new CombinedInvWrapper(new IItemHandlerModifiable[]{container.neighborRack.getInventory(), container.rack.getInventory()})) : container.rack.getInventory();
        int size = this.jointChestInventory.getSlots();
        this.inventoryRows = size / 9;
        int rows = Math.min(this.inventoryRows, 8);
        int columns = this.inventoryRows <= 8 ? 9 : size / 8 + 1;
        this.field_147000_g = 114 + rows * 18;
        if (columns > 9) {
            this.field_146999_f += (columns - 9) * 18;
        }
    }

    protected void func_230451_b_(@NotNull MatrixStack stack, int mouseX, int mouseY) {
        this.field_230712_o_.func_238421_b_(stack, this.field_230704_d_.getString(), 8.0f, 6.0f, 0x404040);
        this.field_230712_o_.func_238421_b_(stack, this.field_213127_e.func_145748_c_().getString(), 8.0f, (float)(this.field_147000_g - 94), 0x404040);
    }

    protected void func_230450_a_(@NotNull MatrixStack stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(WindowRack.getCorrectTextureForSlots(this.inventoryRows));
        if (this.inventoryRows <= 8) {
            int rowsHeight = this.inventoryRows * 18 + 18 - 1;
            WindowRack.func_238463_a_((MatrixStack)stack, (int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)rowsHeight, (int)350, (int)350);
            WindowRack.func_238463_a_((MatrixStack)stack, (int)this.field_147003_i, (int)(this.field_147009_r + rowsHeight), (float)0.0f, (float)235.0f, (int)this.field_146999_f, (int)96, (int)350, (int)350);
        } else {
            WindowRack.func_238463_a_((MatrixStack)stack, (int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (int)350, (int)350);
        }
    }

    private static ResourceLocation getCorrectTextureForSlots(int inventoryRows) {
        if (inventoryRows <= 8) {
            return CHEST_GUI_TEXTURE;
        }
        return new ResourceLocation("minecolonies", String.format(LOCATION, inventoryRows * 9));
    }

    public void func_230430_a_(@NotNull MatrixStack stack, int x, int y, float z) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, x, y, z);
        this.func_230459_a_(stack, x, y);
    }
}

