/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneBuilders;
import com.ldtteam.blockout.controls.AbstractTextBuilder;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Gradient;
import com.ldtteam.blockout.controls.Image;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ZoomDragView;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ResearchBranchType;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.modules.UniversityModuleWindow;
import com.minecolonies.coremod.network.messages.server.colony.building.university.TryResearchMessage;
import com.minecolonies.coremod.research.AlternateBuildingResearchRequirement;
import com.minecolonies.coremod.research.BuildingResearchRequirement;
import com.minecolonies.coremod.research.GlobalResearchEffect;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class WindowResearchTree
extends AbstractWindowSkeleton {
    private final ResourceLocation branch;
    private final IBuildingView building;
    private final UniversityModuleWindow last;
    private final ResearchBranchType branchType;
    private boolean hasMax;
    private final ButtonImage undoButton = new ButtonImage();
    private final Text undoText = new Text();
    private ItemIcon[] undoCostIcons = new ItemIcon[0];

    public WindowResearchTree(ResourceLocation branch, IBuildingView building, UniversityModuleWindow last) {
        super("minecolonies:gui/windowresearch.xml", last);
        this.branch = branch;
        this.building = building;
        this.last = last;
        this.hasMax = false;
        this.branchType = IGlobalResearchTree.getInstance().getBranchData(branch).getType();
        List<ResourceLocation> researchList = IGlobalResearchTree.getInstance().getPrimaryResearch(branch);
        this.hasMax = building.getColony().getResearchManager().getResearchTree().branchFinishedHighestLevel(branch);
        ZoomDragView view = (ZoomDragView)this.findPaneOfTypeByID("dragView", ZoomDragView.class);
        int maxHeight = this.drawTree(0, 0, view, researchList, false);
        this.drawTreeBackground(view, maxHeight);
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        if (button.getParent().getChildren().contains(this.undoButton)) {
            button.getParent().removeChild((Pane)this.undoButton);
        }
        for (ItemIcon icon : this.undoCostIcons) {
            if (!button.getParent().getChildren().contains(icon)) continue;
            button.getParent().removeChild((Pane)icon);
        }
        if (button.getParent().getChildren().contains(this.undoText)) {
            button.getParent().removeChild((Pane)this.undoText);
        }
        if (!button.getID().isEmpty()) {
            if (button.getID().contains("undo:")) {
                String undoName = button.getID().substring(button.getID().indexOf(58) + 1);
                if (!ResourceLocation.func_217855_b((String)undoName)) {
                    return;
                }
                ResourceLocation undoID = new ResourceLocation(undoName);
                ILocalResearch cancelResearch = this.building.getColony().getResearchManager().getResearchTree().getResearch(this.branch, undoID);
                if (cancelResearch != null) {
                    if (cancelResearch.getState() == ResearchState.IN_PROGRESS) {
                        this.last.updateResearchCount(-1);
                    }
                    cancelResearch.setState(ResearchState.NOT_STARTED);
                    Network.getNetwork().sendToServer(new TryResearchMessage(this.building, cancelResearch.getId(), cancelResearch.getBranch(), true));
                    this.close();
                }
            } else if (ResourceLocation.func_217855_b((String)button.getID()) && IGlobalResearchTree.getInstance().getResearch(this.branch, new ResourceLocation(button.getID())) != null && (this.building.getBuildingLevel() >= IGlobalResearchTree.getInstance().getResearch(this.branch, new ResourceLocation(button.getID())).getDepth() || this.building.getBuildingLevel() == this.building.getBuildingMaxLevel())) {
                IGlobalResearch research = IGlobalResearchTree.getInstance().getResearch(this.branch, new ResourceLocation(button.getID()));
                ILocalResearch localResearch = this.building.getColony().getResearchManager().getResearchTree().getResearch(this.branch, research.getId());
                if (localResearch == null && this.building.getBuildingLevel() > this.building.getColony().getResearchManager().getResearchTree().getResearchInProgress().size() && (research.hasEnoughResources((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by)) || this.mc.field_71439_g.func_184812_l_())) {
                    research.startResearch(this.building.getColony().getResearchManager().getResearchTree());
                    this.last.updateResearchCount(0);
                    if (research.getDepth() > this.building.getBuildingMaxLevel()) {
                        this.hasMax = true;
                    }
                    Network.getNetwork().sendToServer(new TryResearchMessage(this.building, research.getId(), research.getBranch(), false));
                    this.close();
                } else if (localResearch != null) {
                    if (localResearch.getState() == ResearchState.IN_PROGRESS) {
                        this.drawUndoProgressButton(button);
                    }
                    if (localResearch.getState() == ResearchState.FINISHED) {
                        if (research.isImmutable() || research.isAutostart()) {
                            return;
                        }
                        for (ResourceLocation childId : research.getChildren()) {
                            if (this.building.getColony().getResearchManager().getResearchTree().getResearch(this.branch, childId) == null || this.building.getColony().getResearchManager().getResearchTree().getResearch(this.branch, childId).getState() == ResearchState.NOT_STARTED) continue;
                            return;
                        }
                        if (this.branchType == ResearchBranchType.UNLOCKABLES) {
                            this.drawUndoCompleteButton(button);
                        }
                        if (this.hasMax && research.getDepth() > this.building.getBuildingMaxLevel() && this.building.getBuildingLevel() == this.building.getBuildingMaxLevel()) {
                            this.drawUndoCompleteButton(button);
                            return;
                        }
                        ResourceLocation parentId = IGlobalResearchTree.getInstance().getResearch(this.branch, research.getId()).getParent();
                        while (!parentId.func_110623_a().isEmpty()) {
                            if (IGlobalResearchTree.getInstance().getResearch(this.branch, parentId) != null && IGlobalResearchTree.getInstance().getResearch(this.branch, parentId).hasOnlyChild()) {
                                this.drawUndoCompleteButton(button);
                                break;
                            }
                            parentId = IGlobalResearchTree.getInstance().getResearch(this.branch, parentId).getParent();
                        }
                    }
                }
            } else if (button.getID().equals("cancel")) {
                this.close();
                this.last.open();
            }
        }
    }

    private int drawTree(int height, int depth, ZoomDragView view, List<ResourceLocation> researchList, boolean abandoned) {
        researchList.sort(Comparator.comparing(unsortedResearch -> IGlobalResearchTree.getInstance().getResearch(this.branch, (ResourceLocation)unsortedResearch).getSortOrder()));
        int nextHeight = height;
        for (int i = 0; i < researchList.size(); ++i) {
            IGlobalResearch research;
            if (i > 0) {
                ++nextHeight;
            }
            if ((research = IGlobalResearchTree.getInstance().getResearch(this.branch, researchList.get(i))).isHidden() && !IGlobalResearchTree.getInstance().isResearchRequirementsFulfilled(research.getResearchRequirement(), this.building.getColony()) || ((Boolean)IMinecoloniesAPI.getInstance().getConfig().getServer().workersAlwaysWorkInRain.get()).booleanValue() && research.getEffects().size() == 1 && research.getEffects().get(0).getId().equals((Object)ResearchConstants.WORKING_IN_RAIN) && this.building.getColony().getResearchManager().getResearchTree().getResearch(this.branch, researchList.get(i)) == null) continue;
            int offsetX = depth * 215 + 10 + 3;
            int offsetY = nextHeight * 70 + 20 + 10;
            boolean trueAbandoned = this.drawResearchItem(view, offsetX, offsetY, research, abandoned);
            if (!research.getParent().func_110623_a().isEmpty()) {
                this.drawArrows(view, offsetX - 40, offsetY - 18, researchList.size(), research.getParent(), i, nextHeight, height);
            }
            if (research.getChildren().isEmpty()) continue;
            nextHeight = this.drawTree(nextHeight, depth + 1, view, research.getChildren(), trueAbandoned);
        }
        return nextHeight;
    }

    private void drawTreeBackground(ZoomDragView view, int maxHeight) {
        if (this.branchType == ResearchBranchType.UNLOCKABLES && IGlobalResearchTree.getInstance().getBranchData(this.branch).getBaseTime(1) < 1) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            Text timeLabel = new Text();
            timeLabel.setSize(95, 12);
            timeLabel.setPosition((i - 1) * 215 + 87 - 23, 10);
            if (this.branchType == ResearchBranchType.UNLOCKABLES) {
                timeLabel.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.research.tier.header.unrestricted", new Object[]{i > this.building.getBuildingMaxLevel() ? this.building.getBuildingMaxLevel() : i, IGlobalResearchTree.getInstance().getBranchData(this.branch).getHoursTime(i)}));
                timeLabel.setColors(ResearchConstants.COLOR_TEXT_LABEL);
                view.addChild((Pane)timeLabel);
                continue;
            }
            timeLabel.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.research.tier.header", new Object[]{i > this.building.getBuildingMaxLevel() ? this.building.getBuildingMaxLevel() : i, IGlobalResearchTree.getInstance().getBranchData(this.branch).getHoursTime(i)}));
            if (this.building.getBuildingLevel() < i && (this.building.getBuildingLevel() != this.building.getBuildingMaxLevel() || this.hasMax)) {
                Gradient gradient = new Gradient();
                gradient.setGradientStart(80, 80, 80, 100);
                gradient.setGradientEnd(60, 60, 60, 110);
                gradient.setSize(i == 6 ? 400 : 215, (maxHeight + 4) * 70 + 20 + 10);
                gradient.setPosition((i - 1) * 215, 0);
                view.getChildren().add(0, gradient);
                timeLabel.setColors(ResearchConstants.COLOR_TEXT_NEGATIVE);
            } else {
                timeLabel.setColors(ResearchConstants.COLOR_TEXT_LABEL);
            }
            view.addChild((Pane)timeLabel);
        }
    }

    private ResearchButtonState getResearchButtonState(boolean abandoned, boolean parentResearched, IGlobalResearch research, ResearchState state) {
        if (abandoned) {
            return ResearchButtonState.ABANDONED;
        }
        if (!parentResearched) {
            return ResearchButtonState.MISSING_PARENT;
        }
        if (state == ResearchState.FINISHED) {
            return ResearchButtonState.FINISHED;
        }
        if (state == ResearchState.IN_PROGRESS) {
            return ResearchButtonState.IN_PROGRESS;
        }
        if (research.getDepth() > this.building.getBuildingLevel() && (research.getDepth() <= this.building.getBuildingMaxLevel() || this.hasMax || this.building.getBuildingLevel() != this.building.getBuildingMaxLevel()) && this.branchType != ResearchBranchType.UNLOCKABLES) {
            return ResearchButtonState.TOO_LOW_UNIVERSITY;
        }
        if (this.mc.field_71439_g.func_184812_l_()) {
            return ResearchButtonState.AVAILABLE;
        }
        if (!IGlobalResearchTree.getInstance().isResearchRequirementsFulfilled(research.getResearchRequirement(), this.building.getColony())) {
            return ResearchButtonState.MISSING_REQUIREMENT;
        }
        if (!research.hasEnoughResources((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by))) {
            return ResearchButtonState.MISSING_COST;
        }
        return ResearchButtonState.AVAILABLE;
    }

    private boolean drawResearchItem(ZoomDragView view, int offsetX, int offsetY, IGlobalResearch research, boolean abandoned) {
        int progress;
        ILocalResearchTree tree = this.building.getColony().getResearchManager().getResearchTree();
        boolean parentResearched = tree.hasCompletedResearch(research.getParent());
        IGlobalResearch parentResearch = IGlobalResearchTree.getInstance().getResearch(this.branch, research.getParent());
        ResearchState state = tree.getResearch(this.branch, research.getId()) == null ? ResearchState.NOT_STARTED : tree.getResearch(this.branch, research.getId()).getState();
        int n = progress = tree.getResearch(this.branch, research.getId()) == null ? 0 : tree.getResearch(this.branch, research.getId()).getProgress();
        if (this.mc.field_71439_g.func_184812_l_() && state == ResearchState.IN_PROGRESS && ((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchCreativeCompletion.get()).booleanValue() && progress < IGlobalResearchTree.getInstance().getBranchData(this.branch).getBaseTime(research.getDepth())) {
            Network.getNetwork().sendToServer(new TryResearchMessage(this.building, research.getId(), research.getBranch(), false));
        }
        if (research.getDepth() != 1 && state != ResearchState.FINISHED && state != ResearchState.IN_PROGRESS && parentResearch.hasOnlyChild() && parentResearch.hasResearchedChild(tree)) {
            abandoned = true;
        }
        ResearchButtonState researchState = this.getResearchButtonState(abandoned, parentResearched, research, state);
        this.drawResearchBoxes(view, offsetX, offsetY, research, researchState, progress);
        this.drawResearchReqsAndCosts(view, offsetX, offsetY, research, researchState);
        this.drawResearchIcons(view, offsetX, offsetY, research, researchState);
        this.drawResearchTexts(view, offsetX, offsetY, research, researchState, progress);
        return abandoned;
    }

    private void drawResearchBoxes(ZoomDragView view, int offsetX, int offsetY, IGlobalResearch research, ResearchButtonState state, int progress) {
        ButtonImage nameBar = new ButtonImage();
        nameBar.setSize(175, 21);
        nameBar.setPosition(offsetX, offsetY);
        ButtonImage iconBox = new ButtonImage();
        iconBox.setSize(21, 25);
        iconBox.setPosition(offsetX - 3, offsetY - 4);
        Image subBar = new Image();
        subBar.setPosition(offsetX + 7, offsetY + 18);
        subBar.setSize(164, 32);
        if (state != ResearchButtonState.FINISHED) {
            view.addChild((Pane)subBar);
        }
        view.addChild((Pane)nameBar);
        view.addChild((Pane)iconBox);
        switch (state) {
            case AVAILABLE: {
                nameBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_medium_blue.png"));
                subBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_sub_medium.png"));
                iconBox.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_mini_blue.png"));
                nameBar.setID(research.getId().toString());
                iconBox.setID(research.getId().toString());
                break;
            }
            case IN_PROGRESS: {
                nameBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_medium_light_green.png"));
                subBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_sub_thin.png"));
                iconBox.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_mini_light_green.png"));
                nameBar.setID(research.getId().toString());
                iconBox.setID(research.getId().toString());
                this.drawProgressBar(view, offsetX, offsetY, research, progress, subBar);
                break;
            }
            case FINISHED: {
                nameBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_medium_light_green.png"));
                iconBox.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_mini_light_green.png"));
                nameBar.setID(research.getId().toString());
                iconBox.setID(research.getId().toString());
                break;
            }
            case LOCKED: 
            case ABANDONED: 
            case MISSING_PARENT: 
            case TOO_LOW_UNIVERSITY: {
                nameBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_medium_light_gray.png"));
                subBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_sub_medium.png"));
                iconBox.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_mini_light_gray.png"));
                break;
            }
            case TOO_MANY_PROGRESS: {
                ButtonImage tooMany1 = new ButtonImage();
                tooMany1.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large_disabled.png"));
                tooMany1.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.research.toomanyinprogress.1"));
                tooMany1.setSize(129, 17);
                tooMany1.setPosition(offsetX + 30, offsetY + 17);
                view.addChild((Pane)tooMany1);
                ButtonImage tooMany2 = new ButtonImage();
                tooMany2.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large_disabled.png"));
                tooMany2.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.research.toomanyinprogress.2"));
                tooMany2.setSize(129, 17);
                tooMany2.setPosition(offsetX + 30, offsetY + 34);
                view.addChild((Pane)tooMany2);
            }
            case MISSING_REQUIREMENT: 
            case MISSING_COST: {
                nameBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_medium_plain.png"));
                subBar.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_sub_medium.png"));
                iconBox.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_mini.png"));
                break;
            }
            default: {
                Log.getLogger().error("Error in DrawResearchBoxes for " + research.getId() + " state: " + (Object)((Object)state));
            }
        }
        this.generateResearchTooltips((Button)nameBar, research, state);
    }

    private void drawProgressBar(ZoomDragView view, int offsetX, int offsetY, IGlobalResearch research, int progress, Image subBar) {
        Gradient nameGradient = new Gradient();
        nameGradient.setSize(175, 15);
        nameGradient.setPosition(offsetX, offsetY);
        view.addChild((Pane)nameGradient);
        nameGradient.setGradientStart(102, 225, 80, 60);
        nameGradient.setGradientEnd(102, 225, 80, 60);
        double progressRatio = (double)(progress + 1) / (double)IGlobalResearchTree.getInstance().getBranchData(this.branch).getBaseTime(research.getDepth());
        subBar.setSize(164, 12);
        nameGradient.setSize((int)(progressRatio * 175.0), 18);
        Gradient subGradient = new Gradient();
        subGradient.setPosition(offsetX + 7, offsetY + 18);
        subGradient.setSize(subBar.getWidth(), subBar.getHeight());
        subGradient.setSize((int)(progressRatio * (double)subBar.getWidth()), 11);
        subGradient.setGradientStart(230, 200, 20, 60);
        subGradient.setGradientEnd(230, 200, 20, 60);
        view.addChild((Pane)subGradient);
    }

    private void generateResearchTooltips(Button tipItem, IGlobalResearch research, ResearchButtonState state) {
        int txt;
        AbstractTextBuilder.TooltipBuilder hoverPaneBuilder = (AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)tipItem).append(research.getName().func_230532_e_())).bold()).color(ResearchConstants.COLOR_TEXT_NAME);
        if (!research.getSubtitle().func_150268_i().isEmpty()) {
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).italic()).colorName("GRAY")).append((IFormattableTextComponent)research.getSubtitle());
        }
        for (txt = 0; txt < research.getEffects().size(); ++txt) {
            if (research.getEffects().get(txt).getId().equals((Object)ResearchConstants.CITIZEN_CAP) && ((GlobalResearchEffect)research.getEffects().get(txt)).getEffect() + 25.0 > (double)((Integer)IMinecoloniesAPI.getInstance().getConfig().getServer().maxCitizenPerColony.get()).intValue()) {
                ((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.research.effects.citizencapaddition.description", new Object[]{new TranslationTextComponent("com.minecolonies.coremod.research.limit.maxeffect")}));
            } else {
                ((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append((IFormattableTextComponent)research.getEffects().get(txt).getDesc());
            }
            if (research.getEffects().get(txt).getSubtitle().func_150268_i().isEmpty()) continue;
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append((IFormattableTextComponent)new StringTextComponent("-"))).append((IFormattableTextComponent)research.getEffects().get(txt).getSubtitle())).italic()).colorName("GRAY");
        }
        if (state != ResearchButtonState.FINISHED && state != ResearchButtonState.IN_PROGRESS) {
            for (txt = 0; txt < research.getResearchRequirement().size(); ++txt) {
                if (research.getResearchRequirement().get(txt).isFulfilled(this.building.getColony())) {
                    ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append((IFormattableTextComponent)new StringTextComponent(" - "))).color(ResearchConstants.COLOR_TEXT_FULFILLED)).append((IFormattableTextComponent)research.getResearchRequirement().get(txt).getDesc());
                    continue;
                }
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append((IFormattableTextComponent)new StringTextComponent(" - "))).color(ResearchConstants.COLOR_TEXT_UNFULFILLED)).append((IFormattableTextComponent)research.getResearchRequirement().get(txt).getDesc());
            }
            for (ItemStorage is : research.getCostList()) {
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append((IFormattableTextComponent)new StringTextComponent(" - "))).append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.limit.requirement", new Object[]{is.getAmount(), is.getItem().func_200296_o()}));
                if (InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by), stack -> ItemStackUtils.isEmpty(stack) == false && stack.func_77969_a(is.getItemStack())) < is.getAmount()) {
                    hoverPaneBuilder.color(ResearchConstants.COLOR_TEXT_UNFULFILLED);
                    continue;
                }
                hoverPaneBuilder.color(ResearchConstants.COLOR_TEXT_FULFILLED);
            }
            if (research.getDepth() > this.building.getBuildingLevel() && this.building.getBuildingLevel() != this.building.getBuildingMaxLevel() && this.branchType != ResearchBranchType.UNLOCKABLES) {
                ((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.requirement.university.level", new Object[]{Math.min(research.getDepth(), this.building.getBuildingMaxLevel())}));
            }
            if (research.getDepth() == 6 && this.branchType != ResearchBranchType.UNLOCKABLES) {
                if (this.hasMax) {
                    ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.limit.onemaxperbranch"))).color(ResearchConstants.COLOR_TEXT_UNFULFILLED);
                } else {
                    ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.limit.onemaxperbranch"))).color(ResearchConstants.COLOR_TEXT_FULFILLED);
                }
            }
        }
        if (research.isImmutable()) {
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)hoverPaneBuilder.paragraphBreak()).append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.limit.immutable"))).color(ResearchConstants.COLOR_TEXT_UNFULFILLED);
        }
        hoverPaneBuilder.build();
    }

    private void drawResearchTexts(ZoomDragView view, int offsetX, int offsetY, IGlobalResearch research, ResearchButtonState state, int progress) {
        Text nameText = new Text();
        nameText.setSize(175, 18);
        nameText.setText((IFormattableTextComponent)research.getName());
        nameText.setPosition(offsetX + 15 + 5, offsetY);
        nameText.setColors(ResearchConstants.COLOR_TEXT_DARK);
        nameText.setTextScale((double)1.4f);
        nameText.setEnabled(false);
        view.addChild((Pane)nameText);
        if (state == ResearchButtonState.IN_PROGRESS) {
            double progressToGo = research.isInstant() || this.mc.field_71439_g.func_184812_l_() && (Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchCreativeCompletion.get() != false ? 0.0 : (double)(IGlobalResearchTree.getInstance().getBranchData(this.branch).getBaseTime(research.getDepth()) - progress);
            int hours = (int)(progressToGo / 288.0);
            int increments = (int)Math.ceil(progressToGo % 288.0 / 72.0);
            String timeRemaining = increments == 4 ? String.format("%d:%02d", hours + 1, 0) : String.format("%d:%02d", hours, increments * 15);
            Text progressLabel = new Text();
            progressLabel.setSize(175, 10);
            progressLabel.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.research.time", new Object[]{timeRemaining}));
            progressLabel.setPosition(offsetX + 15 + 5, offsetY + 18);
            progressLabel.setColors(ResearchConstants.COLOR_TEXT_DARK);
            progressLabel.setTextScale((double)0.7f);
            progressLabel.setID(research.getId().toString());
            view.addChild((Pane)progressLabel);
        }
    }

    private void drawUndoProgressButton(Button parent) {
        this.undoButton.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large.png"));
        this.undoButton.setSize(129, 17);
        this.undoButton.setPosition(parent.getX() + 23, parent.getY() + 6 + 16);
        this.undoButton.setID("undo:" + parent.getID());
        parent.getParent().addChild((Pane)this.undoButton);
        this.undoText.setSize(129, 17);
        this.undoText.setPosition(parent.getX() + 5 + 23, parent.getY() + 6 + 16);
        this.undoText.setColors(ResearchConstants.COLOR_TEXT_DARK);
        this.undoText.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.undo.progress"));
        this.undoText.disable();
        parent.getParent().addChild((Pane)this.undoText);
        ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)this.undoButton).append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.undo.progress.tooltip"))).color(ResearchConstants.COLOR_TEXT_UNFULFILLED)).bold()).build();
    }

    private void drawUndoCompleteButton(Button parent) {
        List<ItemStorage> costList = IGlobalResearchTree.getInstance().getResearchResetCosts();
        this.undoCostIcons = new ItemIcon[costList.size()];
        ArrayList<ItemStorage> missingItems = new ArrayList<ItemStorage>();
        for (int i = 0; i < costList.size(); ++i) {
            ItemStorage is = costList.get(i);
            this.undoCostIcons[i] = new ItemIcon();
            if (InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by), stack -> ItemStackUtils.isEmpty(stack) == false && stack.func_77969_a(is.getItemStack())) < is.getAmount()) {
                missingItems.add(is);
            }
            this.undoCostIcons[i].setItem(is.getItemStack());
            this.undoCostIcons[i].setPosition(parent.getX() + 175 + 16 * i, parent.getY() + 6 + 16);
            this.undoCostIcons[i].setSize(16, 16);
            parent.getParent().addChild((Pane)this.undoCostIcons[0]);
        }
        this.undoButton.setSize(129, 17);
        this.undoButton.setPosition(parent.getX(), parent.getY() + 6 + 16);
        AbstractTextBuilder.TooltipBuilder undoTipBuilder = (AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)this.undoButton).append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.undo.remove.tooltip"))).bold()).color(ResearchConstants.COLOR_TEXT_UNFULFILLED);
        this.undoText.setSize(129, 17);
        this.undoText.setPosition(parent.getX() + 5, parent.getY() + 6 + 16);
        this.undoText.setColors(ResearchConstants.COLOR_TEXT_DARK);
        if (!missingItems.isEmpty()) {
            this.undoButton.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large_disabled.png"));
            this.undoText.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.research.notenoughresources"));
            for (ItemStorage cost : missingItems) {
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)undoTipBuilder.paragraphBreak()).append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.requirement.research", new Object[]{cost.getItem().func_200296_o()}))).color(ResearchConstants.COLOR_TEXT_UNFULFILLED);
            }
        } else {
            this.undoButton.setImage(new ResourceLocation("minecolonies", "textures/gui/builderhut/builder_button_medium_large.png"));
            this.undoButton.setID("undo:" + parent.getID());
            this.undoText.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.undo.remove"));
        }
        this.undoText.disable();
        parent.getParent().addChild((Pane)this.undoButton);
        parent.getParent().addChild((Pane)this.undoText);
        undoTipBuilder.build();
    }

    private void drawResearchReqsAndCosts(ZoomDragView view, int offsetX, int offsetY, IGlobalResearch research, ResearchButtonState state) {
        Object divider;
        if (state == ResearchButtonState.ABANDONED || state == ResearchButtonState.IN_PROGRESS || state == ResearchButtonState.FINISHED) {
            return;
        }
        int storageXOffset = 15;
        for (IResearchRequirement requirement : research.getResearchRequirement()) {
            if (!(requirement instanceof AlternateBuildingResearchRequirement)) continue;
            for (Map.Entry<String, Integer> building : ((AlternateBuildingResearchRequirement)requirement).getBuildings().entrySet()) {
                Item item = building.equals("citizen") ? ModBuildings.home.getBuildingBlock().func_199767_j() : (IMinecoloniesAPI.getInstance().getBuildingRegistry().containsKey(new ResourceLocation("minecolonies", building.getKey())) ? ((BuildingEntry)IMinecoloniesAPI.getInstance().getBuildingRegistry().getValue(new ResourceLocation("minecolonies", building.getKey()))).getBuildingBlock().func_199767_j() : Items.field_190931_a.func_199767_j());
                ItemStack stack2 = new ItemStack((IItemProvider)item);
                stack2.func_190920_e(building.getValue().intValue());
                ItemIcon icon = new ItemIcon();
                icon.setItem(stack2);
                icon.setPosition(offsetX + storageXOffset, offsetY + 18);
                icon.setSize(16, 16);
                view.addChild((Pane)icon);
                if (requirement.isFulfilled(this.building.getColony())) {
                    ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append((IFormattableTextComponent)requirement.getDesc())).color(ResearchConstants.COLOR_TEXT_FULFILLED)).build();
                } else {
                    ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append((IFormattableTextComponent)requirement.getDesc())).color(ResearchConstants.COLOR_TEXT_UNFULFILLED)).build();
                }
                storageXOffset += 20;
            }
        }
        if (storageXOffset > 35) {
            divider = new Image();
            divider.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_large_stitches.png"));
            divider.setSize(3, 20);
            divider.setPosition(offsetX + storageXOffset, offsetY + 18 + 4);
            view.addChild((Pane)divider);
            storageXOffset += 3;
        }
        for (IResearchRequirement requirement : research.getResearchRequirement()) {
            if (!(requirement instanceof BuildingResearchRequirement)) continue;
            Item item = ((BuildingResearchRequirement)requirement).getBuilding().equals("citizen") ? ModBuildings.home.getBuildingBlock().func_199767_j() : (IMinecoloniesAPI.getInstance().getBuildingRegistry().containsKey(new ResourceLocation("minecolonies", ((BuildingResearchRequirement)requirement).getBuilding())) ? ((BuildingEntry)IMinecoloniesAPI.getInstance().getBuildingRegistry().getValue(new ResourceLocation("minecolonies", ((BuildingResearchRequirement)requirement).getBuilding()))).getBuildingBlock().func_199767_j() : Items.field_190931_a.func_199767_j());
            ItemStack stack3 = new ItemStack((IItemProvider)item);
            stack3.func_190920_e(((BuildingResearchRequirement)requirement).getBuildingLevel());
            ItemIcon icon = new ItemIcon();
            icon.setItem(stack3);
            icon.setPosition(offsetX + storageXOffset, offsetY + 18 + 6);
            icon.setSize(16, 16);
            view.addChild((Pane)icon);
            if (requirement.isFulfilled(this.building.getColony())) {
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append((IFormattableTextComponent)requirement.getDesc())).color(ResearchConstants.COLOR_TEXT_FULFILLED)).build();
            } else {
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append((IFormattableTextComponent)requirement.getDesc())).color(ResearchConstants.COLOR_TEXT_UNFULFILLED)).build();
            }
            storageXOffset += 20;
        }
        if (research.getResearchRequirement().size() >= 2) {
            divider = new Image();
            divider.setImage(new ResourceLocation("minecolonies", "textures/gui/research/research_button_large_stitches.png"));
            divider.setSize(3, 20);
            divider.setPosition(offsetX + storageXOffset, offsetY + 18 + 4);
            view.addChild((Pane)divider);
        }
        storageXOffset = 20;
        for (ItemStorage storage : research.getCostList()) {
            ItemStack is = storage.getItemStack().func_77946_l();
            is.func_190920_e(storage.getAmount());
            ItemIcon icon = new ItemIcon();
            icon.setItem(is);
            icon.setPosition(offsetX + 175 - storageXOffset - 10, offsetY + 18 + 6);
            icon.setSize(16, 16);
            view.addChild((Pane)icon);
            if (InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by), stack -> ItemStackUtils.isEmpty(stack) == false && stack.func_77969_a(storage.getItemStack())) < storage.getAmount()) {
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.limit.requirement", new Object[]{storage.getAmount(), is.func_77973_b().func_200296_o()}))).color(ResearchConstants.COLOR_TEXT_UNFULFILLED)).build();
            } else {
                ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)icon).paragraphBreak()).append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.limit.requirement", new Object[]{storage.getAmount(), is.func_77973_b().func_200296_o()}))).color(ResearchConstants.COLOR_TEXT_FULFILLED)).build();
            }
            storageXOffset += 20;
        }
    }

    private void drawResearchIcons(ZoomDragView view, int offsetX, int offsetY, IGlobalResearch research, ResearchButtonState state) {
        if (research.isImmutable() && state != ResearchButtonState.FINISHED) {
            Image immutIcon = new Image();
            immutIcon.setImage(new ResourceLocation("minecraft", "textures/block/redstone_torch.png"));
            immutIcon.setSize(16, 16);
            immutIcon.setPosition(offsetX + 175 - 16, offsetY);
            view.addChild((Pane)immutIcon);
            ((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().hoverPane((Pane)immutIcon).paragraphBreak()).append((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.limit.immutable"))).color(ResearchConstants.COLOR_TEXT_FULFILLED)).build();
        }
        switch (state) {
            case LOCKED: 
            case ABANDONED: 
            case MISSING_PARENT: 
            case TOO_LOW_UNIVERSITY: 
            case TOO_MANY_PROGRESS: 
            case MISSING_REQUIREMENT: {
                Image lockIcon = new Image();
                lockIcon.setImage(new ResourceLocation("minecolonies", "textures/gui/research/locked_icon_light_gray.png"));
                lockIcon.setSize(16, 16);
                lockIcon.setPosition(offsetX, offsetY);
                view.addChild((Pane)lockIcon);
                break;
            }
            case MISSING_COST: {
                Image unlockIcon = new Image();
                unlockIcon.setImage(new ResourceLocation("minecolonies", "textures/gui/research/locked_icon_unlocked_blue.png"));
                unlockIcon.setSize(16, 16);
                unlockIcon.setPosition(offsetX, offsetY);
                view.addChild((Pane)unlockIcon);
                break;
            }
            case AVAILABLE: {
                ButtonImage icon = new ButtonImage();
                icon.setImage(new ResourceLocation("minecolonies", "textures/gui/research/icon_start.png"));
                icon.setSize(16, 16);
                icon.setPosition(offsetX, offsetY);
                icon.setID(research.getId().toString());
                view.addChild((Pane)icon);
                break;
            }
            case IN_PROGRESS: {
                ButtonImage playIcon = new ButtonImage();
                playIcon.setImage(new ResourceLocation("minecolonies", "textures/gui/research/icon_cancel.png"));
                playIcon.setSize(16, 16);
                playIcon.setPosition(offsetX, offsetY);
                playIcon.setID(research.getId().toString());
                view.addChild((Pane)playIcon);
                break;
            }
            case FINISHED: {
                ButtonImage checkIcon = new ButtonImage();
                checkIcon.setImage(new ResourceLocation("minecolonies", "textures/gui/research/icon_check.png"));
                checkIcon.setSize(16, 16);
                checkIcon.setPosition(offsetX, offsetY);
                checkIcon.setID(research.getId().toString());
                view.addChild((Pane)checkIcon);
                break;
            }
            default: {
                Log.getLogger().error("Error with DrawIcons :" + research.getId());
            }
        }
    }

    private void drawArrows(ZoomDragView view, int offsetX, int offsetY, int researchListSize, ResourceLocation parentResearch, int currentCounter, int nextHeight, int parentHeight) {
        boolean lastSibling;
        boolean firstSibling = currentCounter == 0;
        boolean secondSibling = currentCounter >= 1;
        boolean bl = lastSibling = currentCounter + 1 >= researchListSize;
        if (firstSibling && lastSibling) {
            Image corner = new Image();
            corner.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_right.png"));
            corner.setSize(37, 50);
            corner.setPosition(offsetX, offsetY);
            view.addChild((Pane)corner);
        } else {
            Image corner;
            if (secondSibling) {
                for (int dif = 1; dif < nextHeight - parentHeight; ++dif) {
                    corner = new Image();
                    corner.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_down.png"));
                    corner.setSize(37, 70);
                    corner.setPosition(offsetX - 3, offsetY - dif * corner.getHeight());
                    view.addChild((Pane)corner);
                }
            }
            if (firstSibling) {
                Image corner2 = new Image();
                corner2.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_right_down.png"));
                corner2.setSize(37, 70);
                corner2.setPosition(offsetX - 3, offsetY);
                view.addChild((Pane)corner2);
            } else if (IGlobalResearchTree.getInstance().getResearch(this.branch, parentResearch).hasOnlyChild()) {
                Text orLabel = new Text();
                orLabel.setSize(16, 16);
                orLabel.setColors(ResearchConstants.COLOR_TEXT_DARK);
                orLabel.setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.research.research.or"));
                orLabel.setPosition(offsetX + 10, offsetY + 6);
                view.addChild((Pane)orLabel);
                if (lastSibling) {
                    Image circle = new Image();
                    circle.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_or.png"));
                    circle.setSize(37, 50);
                    circle.setPosition(offsetX - 3, offsetY);
                    view.addChild((Pane)circle);
                } else {
                    corner = new Image();
                    corner.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_or_down.png"));
                    corner.setSize(37, 70);
                    corner.setPosition(offsetX - 3, offsetY + 4);
                    view.addChild((Pane)corner);
                }
            } else {
                Image corner3 = new Image();
                if (lastSibling) {
                    corner3.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_right_and.png"));
                    corner3.setSize(37, 50);
                } else {
                    corner3.setImage(new ResourceLocation("minecolonies", "textures/gui/research/arrow_right_and_more.png"));
                    corner3.setSize(37, 70);
                }
                corner3.setPosition(offsetX - 3, offsetY);
                view.addChild((Pane)corner3);
            }
        }
    }

    static enum ResearchButtonState {
        AVAILABLE,
        IN_PROGRESS,
        FINISHED,
        ABANDONED,
        MISSING_PARENT,
        MISSING_REQUIREMENT,
        MISSING_COST,
        TOO_MANY_PROGRESS,
        TOO_LOW_UNIVERSITY,
        LOCKED;

    }
}

