/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.placement.handlers.placement.PlacementError;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.registry.IBuildingRegistry;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.WindowBuildDecoration;
import com.minecolonies.coremod.event.HighlightManager;
import com.minecolonies.coremod.items.ItemSupplyCampDeployer;
import com.minecolonies.coremod.items.ItemSupplyChestDeployer;
import com.minecolonies.coremod.network.messages.server.BuildToolPasteMessage;
import com.minecolonies.coremod.network.messages.server.BuildToolPlaceMessage;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowMinecoloniesBuildTool
extends WindowBuildTool {
    private static final String RENDER_BOX_CATEGORY = "placement";

    public WindowMinecoloniesBuildTool(@Nullable BlockPos pos, String structureName, int rotation, int groundstyle) {
        super(pos, structureName, rotation, groundstyle);
    }

    public WindowMinecoloniesBuildTool(@Nullable BlockPos pos, int groundstyle) {
        super(pos, groundstyle);
    }

    public void place(StructureName structureName) {
        BlockPos offset = Settings.instance.getActiveStructure().getPrimaryBlockOffset();
        BlockState state = Settings.instance.getActiveStructure().getBlockState(offset).getBlockState();
        BuildToolPlaceMessage msg = new BuildToolPlaceMessage(structureName.toString(), structureName.getLocalizedName(), Settings.instance.getPosition(), Settings.instance.getRotation(), structureName.isHut(), Settings.instance.getMirror(), state);
        if (structureName.isHut()) {
            Network.getNetwork().sendToServer(msg);
        } else {
            Minecraft.func_71410_x().func_212871_a_(() -> ((WindowBuildDecoration)new WindowBuildDecoration(msg, Settings.instance.getPosition(), structureName)).open());
        }
    }

    public boolean hasPermission() {
        return true;
    }

    public boolean pasteDirectly() {
        return false;
    }

    public void paste(StructureName name, boolean complete) {
        BlockPos offset = Settings.instance.getActiveStructure().getPrimaryBlockOffset();
        BlockState state = Settings.instance.getActiveStructure().getBlockState(offset).getBlockState();
        Network.getNetwork().sendToServer(new BuildToolPasteMessage(name.toString(), name.toString(), Settings.instance.getPosition(), Settings.instance.getRotation(), name.isHut(), Settings.instance.getMirror(), complete, state));
    }

    public void checkAndPlace() {
        ArrayList<PlacementError> placementErrorList = new ArrayList<PlacementError>();
        String schemName = Settings.instance.getStaticSchematicName();
        if (schemName.contains("supplyship") || schemName.contains("nethership")) {
            if (ItemSupplyChestDeployer.canShipBePlaced((World)Minecraft.func_71410_x().field_71441_e, Settings.instance.getPosition(), Settings.instance.getActiveStructure(), placementErrorList, (PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
                super.pasteNice();
            } else {
                LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)"item.supplyChestDeployer.invalid", (Object[])new Object[0]);
            }
        } else if (schemName.contains("supplycamp") && ItemSupplyCampDeployer.canCampBePlaced((World)Minecraft.func_71410_x().field_71441_e, Settings.instance.getPosition(), placementErrorList, (PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            super.pasteNice();
        }
        HighlightManager.clearCategory(RENDER_BOX_CATEGORY);
        if (!placementErrorList.isEmpty()) {
            LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (String)"item.supply.badblocks", (Object[])new Object[0]);
            for (PlacementError error : placementErrorList) {
                HighlightManager.addRenderBox(RENDER_BOX_CATEGORY, new HighlightManager.TimedBoxRenderData().setPos(error.getPos()).setRemovalTimePoint(Minecraft.func_71410_x().field_71441_e.func_82737_E() + 144000L).addText(LanguageHandler.translateKey((String)("item.supply.error." + error.getType().toString().toLowerCase()))).setColor(0xFF0000));
            }
        }
        if (!Screen.func_231173_s_()) {
            super.cancelClicked();
        }
    }

    public void cancelClicked() {
        super.cancelClicked();
        HighlightManager.clearCategory(RENDER_BOX_CATEGORY);
    }

    public boolean hasMatchingBlock(@NotNull PlayerInventory inventory, String hut) {
        String name = hut.equals("citizen") ? "home" : hut;
        return InventoryUtils.hasItemInProvider((ICapabilityProvider)inventory.field_70458_d, item -> item.func_77973_b() instanceof BlockItem && StructureName.HUTS.contains(hut) && ((BlockItem)item.func_77973_b()).func_179223_d() == ((BuildingEntry)IBuildingRegistry.getInstance().getValue(new ResourceLocation("minecolonies", name))).getBuildingBlock());
    }
}

