/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonHandler;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.coremod.colony.buildings.views.LivingBuildingView;
import com.minecolonies.coremod.network.messages.server.colony.building.home.AssignUnassignMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

public class WindowAssignCitizen
extends Window
implements ButtonHandler {
    private static final double FAR_DISTANCE_THRESHOLD = 250.0;
    private final IBuildingView building;
    private final ScrollingList citizenList;
    private final IColonyView colony;
    private List<ICitizenDataView> citizens = new ArrayList<ICitizenDataView>();

    public WindowAssignCitizen(IColonyView c, BlockPos buildingId) {
        super("minecolonies:gui/windowassigncitizen.xml");
        this.colony = c;
        this.building = this.colony.getBuilding(buildingId);
        this.citizenList = (ScrollingList)this.findPaneOfTypeByID("unassigned", ScrollingList.class);
        this.updateCitizens();
    }

    private void updateCitizens() {
        this.citizens.clear();
        this.citizens.addAll(this.colony.getCitizens().values());
        this.citizens = this.colony.getCitizens().values().stream().filter(cit -> cit.getHomeBuilding() == null || !(this.colony.getBuilding(cit.getHomeBuilding()) instanceof AbstractBuildingGuards.View) && !cit.getHomeBuilding().equals((Object)this.building.getID())).sorted(Comparator.comparing(cit -> ((ICitizenDataView)cit).getHomeBuilding() == null ? 0 : 1).thenComparingLong(cit -> {
            if (((ICitizenDataView)cit).getWorkBuilding() == null) {
                return 0L;
            }
            return BlockPosUtil.getDistance2D(((ICitizenDataView)cit).getWorkBuilding(), this.building.getPosition());
        })).collect(Collectors.toList());
    }

    public void onOpened() {
        this.updateCitizens();
        this.citizenList.enable();
        this.citizenList.show();
        this.citizenList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowAssignCitizen.this.citizens.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                @NotNull ICitizenDataView citizen = (ICitizenDataView)WindowAssignCitizen.this.citizens.get(index);
                if (WindowAssignCitizen.this.building instanceof LivingBuildingView) {
                    ((Text)rowPane.findPaneOfTypeByID("citizen", Text.class)).setText(citizen.getName());
                    BlockPos work = citizen.getWorkBuilding();
                    String workString = "";
                    double newDistance = 0.0;
                    if (work != null) {
                        newDistance = BlockPosUtil.getDistance2D(work, WindowAssignCitizen.this.building.getPosition());
                        workString = " " + newDistance + " blocks";
                    }
                    BlockPos home = citizen.getHomeBuilding();
                    String homeString = "";
                    boolean better = false;
                    boolean badCurrentLiving = false;
                    if (home != null) {
                        if (work != null) {
                            double oldDistance = BlockPosUtil.getDistance2D(work, home);
                            homeString = LanguageHandler.format((String)"com.minecolonies.coremod.gui.home.currently", (Object[])new Object[]{oldDistance});
                            boolean bl = better = newDistance < oldDistance;
                            if (oldDistance >= 250.0) {
                                badCurrentLiving = true;
                            }
                        } else {
                            homeString = LanguageHandler.format((String)"com.minecolonies.coremod.gui.home.current", (Object[])new Object[]{home.func_177958_n(), home.func_177956_o(), home.func_177952_p()});
                        }
                    }
                    Text newLivingLabel = (Text)rowPane.findPaneOfTypeByID("job", Text.class);
                    newLivingLabel.setText(LanguageHandler.format((String)citizen.getJob(), (Object[])new Object[0]) + workString);
                    if (better) {
                        newLivingLabel.setColors(AbstractWindowTownHall.DARKGREEN);
                    }
                    Text currentLivingLabel = (Text)rowPane.findPaneOfTypeByID("living", Text.class);
                    currentLivingLabel.setText(homeString);
                    if (badCurrentLiving) {
                        currentLivingLabel.setColors(AbstractWindowTownHall.RED);
                    }
                    Button done = (Button)rowPane.findPaneOfTypeByID("done", Button.class);
                    if (WindowAssignCitizen.this.colony.isManualHousing()) {
                        done.enable();
                    } else {
                        done.disable();
                    }
                }
            }
        });
    }

    public void onUpdate() {
        this.updateCitizens();
        ((ScrollingList)this.window.findPaneOfTypeByID("unassigned", ScrollingList.class)).refreshElementPanes();
    }

    public void onButtonClicked(@NotNull Button button) {
        if (button.getID().equals("done")) {
            int row = this.citizenList.getListElementIndexByPane((Pane)button);
            ICitizenDataView data = this.citizens.get(row);
            if (this.building instanceof LivingBuildingView) {
                ((LivingBuildingView)this.building).addResident(data.getId());
            }
            Network.getNetwork().sendToServer(new AssignUnassignMessage(this.building, true, data.getId(), null));
        } else if (!button.getID().equals("cancel")) {
            return;
        }
        if (this.colony.getTownHall() != null) {
            this.building.openGui(false);
        }
    }
}

