/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks.huts;

import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.coremod.MineColonies;
import com.minecolonies.coremod.client.gui.townhall.WindowTownHallColonyManage;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockHutTownHall
extends AbstractBlockHut<BlockHutTownHall> {
    private int breakProgressOnTownHall = 0;
    private long lastTownHallBreakingTick = 0L;
    private boolean validTownHallBreak = false;

    public BlockHutTownHall() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(10.0f, Float.POSITIVE_INFINITY));
    }

    @Override
    public float func_180647_a(BlockState state, @NotNull PlayerEntity player, @NotNull IBlockReader blockReader, @NotNull BlockPos pos) {
        if (((Boolean)MineColonies.getConfig().getServer().pvp_mode.get()).booleanValue() && player.field_70170_p instanceof ServerWorld) {
            IBuilding building = IColonyManager.getInstance().getBuilding(player.field_70170_p, pos);
            if (building != null && building.getColony().isCoordInColony(player.field_70170_p, pos) && building.getColony().getPermissions().getRank(player).isHostile()) {
                double localProgress = this.breakProgressOnTownHall;
                double hardness = (double)state.func_185887_b((IBlockReader)player.field_70170_p, pos) * 20.0 * 1.5;
                if (localProgress >= hardness / 10.0 * 9.0 && localProgress <= hardness / 10.0 * 9.0 + 1.0) {
                    this.sendPlayersMessage(building.getColony().getMessagePlayerEntities(), "com.minecolonies.coremod.pvp.townhall.broke", player.func_200200_C_(), 90);
                }
                if (localProgress >= hardness / 4.0 * 3.0 && localProgress <= hardness / 4.0 * 3.0 + 1.0) {
                    this.sendPlayersMessage(building.getColony().getMessagePlayerEntities(), "com.minecolonies.coremod.pvp.townhall.broke", player.func_200200_C_(), 75);
                } else if (localProgress >= hardness / 2.0 && localProgress <= hardness / 2.0 + 1.0) {
                    this.sendPlayersMessage(building.getColony().getMessagePlayerEntities(), "com.minecolonies.coremod.pvp.townhall.broke", player.func_200200_C_(), 50);
                } else if (localProgress >= hardness / 4.0 && localProgress <= hardness / 4.0 + 1.0) {
                    this.sendPlayersMessage(building.getColony().getMessagePlayerEntities(), "com.minecolonies.coremod.pvp.townhall.broke", player.func_200200_C_(), 25);
                }
                if (localProgress >= hardness - 1.0) {
                    this.validTownHallBreak = true;
                }
                if (player.field_70170_p.func_82737_E() - this.lastTownHallBreakingTick < 10L) {
                    ++this.breakProgressOnTownHall;
                } else {
                    this.sendPlayersMessage(building.getColony().getImportantMessageEntityPlayers(), "com.minecolonies.coremod.pvp.townhall.break.start", player.func_200200_C_(), 100);
                    this.breakProgressOnTownHall = 0;
                    this.validTownHallBreak = false;
                }
                this.lastTownHallBreakingTick = player.field_70170_p.func_82737_E();
            } else {
                this.validTownHallBreak = true;
            }
        } else if (!((Boolean)MineColonies.getConfig().getServer().pvp_mode.get()).booleanValue()) {
            this.validTownHallBreak = true;
        }
        float def = super.func_180647_a(state, player, (IBlockReader)player.field_70170_p, pos);
        return (Boolean)MineColonies.getConfig().getServer().pvp_mode.get() != false ? def / 12.0f : def / 10.0f;
    }

    private void sendPlayersMessage(List<PlayerEntity> players, String key, ITextComponent attacker, int value) {
        for (PlayerEntity player : players) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(key, new Object[]{attacker, value}), player.func_110124_au());
        }
    }

    public boolean getValidBreak() {
        return this.validTownHallBreak;
    }

    @Override
    @NotNull
    public String getHutName() {
        return "blockhuttownhall";
    }

    @Override
    public BuildingEntry getBuildingEntry() {
        return ModBuildings.townHall;
    }

    @Override
    @NotNull
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult ray) {
        if (worldIn.field_72995_K) {
            @Nullable IBuildingView building = IColonyManager.getInstance().getBuildingView((RegistryKey<World>)worldIn.func_234923_W_(), pos);
            if (building != null && building.getColony() != null && building.getColony().getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
                building.openGui(player.func_225608_bj_());
            } else {
                new WindowTownHallColonyManage(player, pos, worldIn).open();
            }
        }
        return ActionResultType.SUCCESS;
    }
}

