/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.blocks.decorative;

import com.minecolonies.api.blocks.decorative.AbstractBlockMinecoloniesConstructionTape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockConstructionTape
extends AbstractBlockMinecoloniesConstructionTape<BlockConstructionTape> {
    private static final String BLOCK_NAME = "blockconstructiontape";

    public BlockConstructionTape() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151582_l).func_200943_b(0.0f).func_200942_a().func_222380_e());
        this.setRegistryName(BLOCK_NAME);
        this.shapes = this.makeShapes(2.0f, 2.0f, 16.0f, 0.0f, 16.0f);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)CORNER, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @NotNull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return super.func_220053_a(state, worldIn, pos, context);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction[] faces = context.func_196009_e();
        return BlockConstructionTape.getPlacementState(super.func_196258_a(context), (IBlockReader)context.func_195991_k(), context.func_195995_a(), faces[0].func_176736_b() >= 0 ? faces[0] : faces[1]);
    }

    @NotNull
    public BlockState func_196271_a(@NotNull BlockState stateIn, Direction dir, BlockState state, IWorld worldIn, @NotNull BlockPos currentPos, BlockPos pos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return BlockConstructionTape.getPlacementState(super.func_196271_a(stateIn, dir, state, worldIn, currentPos, pos), (IBlockReader)worldIn, currentPos, (Direction)stateIn.func_177229_b((Property)FACING));
    }

    public static BlockState getPlacementState(@Nullable BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        Fluid fluid = world.func_204610_c(pos).func_206886_c();
        List<Direction> connections = BlockConstructionTape.getConnections(world, pos, face, (Boolean)state.func_177229_b((Property)CORNER));
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(connections.contains(Direction.NORTH)))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(connections.contains(Direction.EAST)))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(connections.contains(Direction.SOUTH)))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(connections.contains(Direction.WEST)))).func_206870_a((Property)FACING, (Comparable)face)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.field_204546_a));
    }

    public static List<Direction> getConnections(IBlockReader world, BlockPos pos, Direction face, boolean corner) {
        ArrayList<Direction> connections = new ArrayList<Direction>();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!BlockConstructionTape.canConnect(world, pos, direction)) continue;
            connections.add(direction);
        }
        if (connections.size() == 0 || connections.size() == 1 && corner) {
            if (corner) {
                connections.clear();
                connections.add(face);
                connections.add(face.func_176746_e());
            } else {
                connections.add(face.func_176740_k() == Direction.Axis.X ? Direction.SOUTH : Direction.EAST);
                connections.add(face.func_176740_k() == Direction.Axis.X ? Direction.NORTH : Direction.WEST);
            }
        } else if (connections.size() == 1) {
            connections.add(((Direction)connections.get(0)).func_176734_d());
        } else if (connections.size() == 3) {
            Direction stem = Direction.NORTH;
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (connections.contains(direction)) continue;
                stem = direction.func_176734_d();
            }
            if (BlockConstructionTape.canRemoveTStem(world, pos, stem)) {
                connections.remove(connections.indexOf(stem));
            }
        }
        return connections;
    }

    protected static boolean canConnect(IBlockReader world, BlockPos pos, Direction face) {
        BlockPos adjacent;
        switch (face) {
            default: {
                adjacent = pos.func_177978_c();
                break;
            }
            case EAST: {
                adjacent = pos.func_177974_f();
                break;
            }
            case SOUTH: {
                adjacent = pos.func_177968_d();
                break;
            }
            case WEST: {
                adjacent = pos.func_177976_e();
            }
        }
        return world.func_180495_p(adjacent).func_177230_c() instanceof BlockConstructionTape;
    }

    protected static boolean canRemoveTStem(IBlockReader world, BlockPos pos, Direction face) {
        BlockState neighbor = world.func_180495_p(pos.func_177972_a(face));
        switch (face) {
            case NORTH: {
                return (Boolean)neighbor.func_177229_b((Property)NORTH) == false && (Boolean)neighbor.func_177229_b((Property)EAST) != false && (Boolean)neighbor.func_177229_b((Property)WEST) != false;
            }
            case EAST: {
                return (Boolean)neighbor.func_177229_b((Property)EAST) == false && (Boolean)neighbor.func_177229_b((Property)NORTH) != false && (Boolean)neighbor.func_177229_b((Property)SOUTH) != false;
            }
            case SOUTH: {
                return (Boolean)neighbor.func_177229_b((Property)SOUTH) == false && (Boolean)neighbor.func_177229_b((Property)EAST) != false && (Boolean)neighbor.func_177229_b((Property)WEST) != false;
            }
            case WEST: {
                return (Boolean)neighbor.func_177229_b((Property)WEST) == false && (Boolean)neighbor.func_177229_b((Property)NORTH) != false && (Boolean)neighbor.func_177229_b((Property)SOUTH) != false;
            }
        }
        return false;
    }

    public boolean func_200123_i(BlockState state, @NotNull IBlockReader reader, @NotNull BlockPos pos) {
        return true;
    }

    public void func_176502_a_(World worldIn, BlockPos pos, BlockState fallingState, BlockState hitState, FallingBlockEntity blockEntity) {
        worldIn.func_175656_a(pos, BlockConstructionTape.getPlacementState(fallingState, (IBlockReader)worldIn, pos, (Direction)fallingState.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, FACING, CORNER, WATERLOGGED});
    }
}

