/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.apiimp.initializer;

import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.TagConstants;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.ResourceLocation;

public class ModTagsInitializer {
    private static final String REDUCEABLE = "reduceable";
    private static final String PRODUCT = "_product";
    private static final String PRODUCT_EXCLUDED = "_product_excluded";
    private static final String INGREDIENT = "_ingredient";
    private static final String INGREDIENT_EXCLUDED = "_ingredient_excluded";
    private static ITagCollectionSupplier supplier;

    public static void init(ITagCollectionSupplier tagSupplier) {
        supplier = tagSupplier;
        ModTags.decorationItems = ModTagsInitializer.getBlockTags(TagConstants.DECORATION_ITEMS, supplier);
        ModTags.concretePowder = ModTagsInitializer.getItemTags(TagConstants.CONCRETE_POWDER, supplier);
        ModTags.concreteBlock = ModTagsInitializer.getBlockTags(TagConstants.CONCRETE_BLOCK, supplier);
        ModTags.pathingBlocks = ModTagsInitializer.getBlockTags(TagConstants.PATHING_BLOCKS, supplier);
        ModTags.floristFlowers = ModTagsInitializer.getItemTags(TagConstants.FLORIST_FLOWERS, supplier);
        ModTags.excludedFood = ModTagsInitializer.getItemTags(TagConstants.EXCLUDED_FOOD, supplier);
        ModTags.fungi = ModTagsInitializer.getItemTags(TagConstants.FUNGI, supplier);
        ModTags.meshes = ModTagsInitializer.getItemTags(TagConstants.MESHES, supplier);
        ModTags.oreChanceBlocks = ModTagsInitializer.getBlockTags(TagConstants.ORECHANCEBLOCKS, supplier);
        ModTags.colonyProtectionException = ModTagsInitializer.getBlockTags(TagConstants.COLONYPROTECTIONEXCEPTION, supplier);
        ModTags.indestructible = ModTagsInitializer.getBlockTags(TagConstants.INDESTRUCTIBLE, supplier);
        ModTags.hostile = ModTagsInitializer.getEntityTags(TagConstants.HOSTILE, supplier);
        ModTagsInitializer.initCrafterRules("baker");
        ModTagsInitializer.initCrafterRules("blacksmith");
        ModTagsInitializer.initCrafterRules("chickenherder");
        ModTagsInitializer.initCrafterRules("concretemixer");
        ModTagsInitializer.initCrafterRules("cook");
        ModTagsInitializer.initCrafterRules("cowboy");
        ModTagsInitializer.initCrafterRules("crusher");
        ModTagsInitializer.initCrafterRules("dyer");
        ModTagsInitializer.initCrafterRules("farmer");
        ModTagsInitializer.initCrafterRules("fisherman");
        ModTagsInitializer.initCrafterRules("fletcher");
        ModTagsInitializer.initCrafterRules("glassblower");
        ModTagsInitializer.initCrafterRules("glassblower_smelting");
        ModTagsInitializer.initCrafterRules("dyer_smelting");
        ModTagsInitializer.initCrafterRules("lumberjack");
        ModTagsInitializer.initCrafterRules("mechanic");
        ModTagsInitializer.initCrafterRules("plantation");
        ModTagsInitializer.initCrafterRules("rabbithutch");
        ModTagsInitializer.initCrafterRules("sawmill");
        ModTagsInitializer.initCrafterRules("shepherd");
        ModTagsInitializer.initCrafterRules("smelter");
        ModTagsInitializer.initCrafterRules("stonemason");
        ModTagsInitializer.initCrafterRules("stonesmeltery");
        ModTagsInitializer.initCrafterRules("swineherder");
        ModTagsInitializer.initCrafterRules(REDUCEABLE);
        Log.getLogger().info("Tags Loaded");
    }

    private static void initCrafterRules(String crafterName) {
        String lowerName = crafterName.toLowerCase();
        ResourceLocation products = new ResourceLocation("minecolonies", lowerName.concat(PRODUCT));
        ResourceLocation ingredients = new ResourceLocation("minecolonies", lowerName.concat(INGREDIENT));
        ResourceLocation productsExcluded = new ResourceLocation("minecolonies", lowerName.concat(PRODUCT_EXCLUDED));
        ResourceLocation ingredientsExcluded = new ResourceLocation("minecolonies", lowerName.concat(INGREDIENT_EXCLUDED));
        ModTags.crafterProduct.put(lowerName, ModTagsInitializer.getItemTags(products, supplier));
        ModTags.crafterProductExclusions.put(lowerName, ModTagsInitializer.getItemTags(productsExcluded, supplier));
        ModTags.crafterIngredient.put(lowerName, ModTagsInitializer.getItemTags(ingredients, supplier));
        ModTags.crafterIngredientExclusions.put(lowerName, ModTagsInitializer.getItemTags(ingredientsExcluded, supplier));
    }

    private static ITag<Item> getItemTags(ResourceLocation resourceLocation, ITagCollectionSupplier supplier) {
        return supplier.func_241836_b().func_241834_b(resourceLocation);
    }

    private static ITag<Block> getBlockTags(ResourceLocation resourceLocation, ITagCollectionSupplier supplier) {
        return supplier.func_241835_a().func_241834_b(resourceLocation);
    }

    private static ITag<EntityType<?>> getEntityTags(ResourceLocation resourceLocation, ITagCollectionSupplier supplier) {
        return supplier.func_241838_d().func_241834_b(resourceLocation);
    }
}

