/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.apiimp.initializer;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.InteractionValidatorRegistry;
import com.minecolonies.api.colony.requestsystem.request.RequestUtils;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.AbstractBuilding;
import com.minecolonies.coremod.colony.buildings.modules.EnchanterStationsModule;
import com.minecolonies.coremod.colony.buildings.modules.FarmerFieldModule;
import com.minecolonies.coremod.colony.buildings.modules.FurnaceUserModule;
import com.minecolonies.coremod.colony.buildings.modules.ItemListModule;
import com.minecolonies.coremod.colony.buildings.modules.MinerLevelManagementModule;
import com.minecolonies.coremod.colony.buildings.modules.QuarryModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBaker;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBeekeeper;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingCook;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingEnchanter;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFarmer;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingFlorist;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingHospital;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSchool;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSifter;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingSmeltery;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.colony.jobs.JobBeekeeper;
import com.minecolonies.coremod.colony.jobs.JobDeliveryman;
import com.minecolonies.coremod.colony.jobs.JobFarmer;
import com.minecolonies.coremod.colony.jobs.JobFisherman;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.jobs.JobQuarrier;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIBasic;
import com.minecolonies.coremod.tileentities.ScarecrowTileEntity;
import com.minecolonies.coremod.util.WorkerUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class InteractionValidatorInitializer {
    public static void init() {
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceuser.nofuel"), citizen -> citizen.getWorkBuilding() != null && citizen.getWorkBuilding().hasModule(FurnaceUserModule.class) && citizen.getWorkBuilding().getModuleMatching(ItemListModule.class, m -> m.getId().equals("fuel")).getList().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.nofurnace"), citizen -> citizen.getWorkBuilding() != null && citizen.getWorkBuilding().hasModule(FurnaceUserModule.class) && citizen.getWorkBuilding().getFirstModuleOccurance(FurnaceUserModule.class).getFurnaces().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.wrongfood"), citizen -> InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)citizen.getInventory(), ItemStackUtils.ISCOOKABLE) != -1 && InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)citizen.getInventory(), stack -> ItemStackUtils.CAN_EAT.test((ItemStack)stack) && (citizen.getWorkBuilding() == null || citizen.getWorkBuilding().canEat((ItemStack)stack))) == -1);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.betterfood"), citizen -> citizen.getSaturation() == 0.0 && !citizen.isChild() && citizen.needsBetterFood());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.betterfood.children"), citizen -> citizen.getSaturation() == 0.0 && citizen.isChild() && citizen.needsBetterFood());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.norestaurant"), citizen -> citizen.getColony() != null && citizen.getSaturation() <= 6.0 && citizen.getEntity().isPresent() && citizen.getColony().getBuildingManager().getBestBuilding(citizen.getEntity().get(), BuildingCook.class) == null && InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)citizen.getInventory(), ItemStackUtils.ISFOOD) == -1);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.nohospital"), citizen -> citizen.getColony() != null && citizen.getEntity().isPresent() && citizen.getEntity().get().getCitizenDiseaseHandler().isSick() && citizen.getColony().getBuildingManager().getBestBuilding(citizen.getEntity().get(), BuildingHospital.class) == null);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.ai.waitingforcure"), citizen -> citizen.getColony() != null && citizen.getEntity().isPresent() && !citizen.getEntity().get().getCitizenDiseaseHandler().getDisease().isEmpty());
        InteractionValidatorRegistry.registerPosBasedPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.job.deliveryman.workerchestfull"), (citizen, pos) -> {
            IItemHandler inv;
            IBuilding building;
            IColony colony;
            if (citizen.getJob() instanceof JobDeliveryman && (colony = citizen.getColony()) != null && (building = colony.getBuildingManager().getBuilding((BlockPos)pos)) != null && (inv = (IItemHandler)building.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).resolve().orElse(null)) != null) {
                return InventoryUtils.openSlotCount(inv) > 0L;
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.job.deliveryman.nowarehouse"), cit -> {
            if (cit.getJob() instanceof JobDeliveryman && cit.getWorkBuilding() != null) {
                return ((JobDeliveryman)cit.getJob()).findWareHouse() == null;
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.farmer.nofreefields"), citizen -> citizen.getWorkBuilding() instanceof BuildingFarmer && ((BuildingFarmer)citizen.getWorkBuilding()).getFirstModuleOccurance(FarmerFieldModule.class).hasNoFields());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.miner.invalidmineshaft"), citizen -> citizen.getWorkBuilding() instanceof BuildingMiner && citizen.getJob() instanceof JobMiner && (((BuildingMiner)citizen.getWorkBuilding()).getCobbleLocation() == null || ((BuildingMiner)citizen.getWorkBuilding()).getLadderLocation() == null));
        InteractionValidatorRegistry.registerPosBasedPredicate((ITextComponent)new TranslationTextComponent("entity.farmer.noseedset"), (citizen, pos) -> {
            TileEntity tileEntity;
            World world;
            IColony colony;
            if (citizen.getJob() instanceof JobFarmer && (colony = citizen.getColony()) != null && (world = colony.getWorld()) != null && (tileEntity = world.func_175625_s(pos)) instanceof ScarecrowTileEntity) {
                return ((ScarecrowTileEntity)tileEntity).getSeed() == null;
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.worker.inventoryfullchestfull"), citizen -> citizen.getWorkBuilding() != null && InventoryUtils.isProviderFull(citizen.getWorkBuilding()));
        InteractionValidatorRegistry.registerPosBasedPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.request.toolow"), (citizen, pos) -> {
            World world;
            IColony colony;
            IBuilding workBuilding = citizen.getWorkBuilding();
            if (workBuilding != null && (colony = citizen.getColony()) != null && (world = colony.getWorld()) != null) {
                return workBuilding.getMaxToolLevel() < WorkerUtil.getCorrectHarvestLevelForBlock(world.func_180495_p(pos));
            }
            return false;
        });
        InteractionValidatorRegistry.registerTokenBasedPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.requestsystem.playerresolver.normal"), (citizen, token) -> {
            IColony colony = citizen.getColony();
            if (colony != null) {
                return RequestUtils.requestChainNeedsPlayer(token, citizen.getColony().getRequestManager());
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceuser.noore"), citizen -> {
            if (citizen.getWorkBuilding() instanceof BuildingSmeltery) {
                ImmutableList<ItemStorage> oreList = ((BuildingSmeltery)citizen.getWorkBuilding()).getModuleMatching(ItemListModule.class, m -> m.getId().equals("ores")).getList();
                for (ItemStorage storage : IColonyManager.getInstance().getCompatibilityManager().getSmeltableOres()) {
                    if (oreList.contains(storage)) continue;
                    return true;
                }
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.healer.fullinv"), citizen -> citizen.getEntity().isPresent() && citizen.getEntity().get().getCitizenDiseaseHandler().isSick() && InventoryUtils.isItemHandlerFull((IItemHandler)citizen.getEntity().get().getInventoryCitizen()));
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.school.nocarpet"), citizen -> citizen.getEntity().isPresent() && citizen.isChild() && citizen.getWorkBuilding() instanceof BuildingSchool && ((BuildingSchool)citizen.getWorkBuilding()).getRandomPlaceToSit() == null);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.fisherman.messagewatertoofar"), citizen -> citizen.getJob() instanceof JobFisherman && ((JobFisherman)citizen.getJob()).getPonds().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceuser.nofuel"), citizen -> citizen.getWorkBuilding() != null && citizen.getWorkBuilding().hasModule(FurnaceUserModule.class) && citizen.getWorkBuilding().getModuleMatching(ItemListModule.class, m -> m.getId().equals("fuel")).getList().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.furnaceuser.nofood"), citizen -> {
            if (!(citizen.getWorkBuilding() instanceof BuildingCook)) {
                return false;
            }
            ImmutableList<ItemStorage> exclusionList = ((BuildingCook)citizen.getWorkBuilding()).getModuleMatching(ItemListModule.class, m -> m.getId().equals("food")).getList();
            for (ItemStorage storage : IColonyManager.getInstance().getCompatibilityManager().getEdibles()) {
                if (exclusionList.contains((Object)storage)) continue;
                return false;
            }
            return true;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.sifter.nomesh"), citizen -> {
            if (!(citizen.getWorkBuilding() instanceof BuildingSifter)) {
                return false;
            }
            return InventoryUtils.getItemCountInProvider((ICapabilityProvider)citizen.getWorkBuilding(), item -> ModTags.meshes.func_230235_a_((Object)item.func_77973_b())) <= 0 && InventoryUtils.getItemCountInItemHandler((IItemHandler)citizen.getInventory(), item -> ModTags.meshes.func_230235_a_((Object)item.func_77973_b())) <= 0;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.bakery.nofurnace"), citizen -> citizen.getWorkBuilding() instanceof BuildingBaker && citizen.getWorkBuilding().getFirstModuleOccurance(FurnaceUserModule.class).getFurnaces().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.beekeeper.messagenohives"), citizen -> citizen.getWorkBuilding() instanceof BuildingBeekeeper && ((BuildingBeekeeper)citizen.getWorkBuilding()).getHives().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.beekeeper.messagenobees"), citizen -> citizen.getWorkBuilding() instanceof BuildingBeekeeper && citizen.getJob(JobBeekeeper.class).checkForBeeInteraction());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.enchanter.nodrainingsset"), citizen -> citizen.getWorkBuilding() instanceof BuildingEnchanter && ((BuildingEnchanter)citizen.getWorkBuilding()).getFirstModuleOccurance(EnchanterStationsModule.class).getBuildingsToGatherFrom().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.florist.noplantground"), citizen -> citizen.getWorkBuilding() instanceof BuildingFlorist && ((BuildingFlorist)citizen.getWorkBuilding()).getPlantGround().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.florist.noflowers"), citizen -> citizen.getWorkBuilding() instanceof BuildingFlorist && ItemStackUtils.isEmpty(((BuildingFlorist)citizen.getWorkBuilding()).getFlowerToGrow()) != false);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.florist.nocompost"), citizen -> {
            IBuilding buildingFlorist = citizen.getWorkBuilding();
            if (buildingFlorist instanceof BuildingFlorist && buildingFlorist.getColony().getWorld() != null) {
                return InventoryUtils.getItemCountInItemHandler((IItemHandler)citizen.getInventory(), ItemStackUtils.IS_COMPOST) == 0 && !WorkerUtil.isThereCompostedLand((BuildingFlorist)buildingFlorist, buildingFlorist.getColony().getWorld());
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("entity.miner.messagerequiresbetterhut"), citizen -> {
            AbstractBuilding buildingMiner = (AbstractBuilding)citizen.getWorkBuilding();
            if (buildingMiner instanceof BuildingMiner && citizen.getColony() != null && citizen.getColony().getWorld() != null && citizen.getJob() instanceof JobMiner) {
                return WorkerUtil.getLastLadder(((BuildingMiner)buildingMiner).getLadderLocation(), citizen.getColony().getWorld()) < ((BuildingMiner)buildingMiner).getDepthLimit() && ((BuildingMiner)buildingMiner).getFirstModuleOccurance(MinerLevelManagementModule.class).getNumberOfLevels() == 0;
            }
            return false;
        });
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.worker.ai.exception"), citizen -> citizen.getJob() != null && ((AbstractEntityAIBasic)((Object)((Object)citizen.getJob().getWorkerAI()))).getExceptionTimer() > 1);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.demands.homelessness"), citizen -> citizen.getCitizenHappinessHandler().getModifier("homelessness").getDays() > 14 && citizen.getHomeBuilding() == null);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.no.homelessness"), citizen -> citizen.getCitizenHappinessHandler().getModifier("homelessness").getDays() > 7 && citizen.getCitizenHappinessHandler().getModifier("homelessness").getDays() <= 14 && citizen.getHomeBuilding() == null);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.demands.unemployment"), citizen -> citizen.getCitizenHappinessHandler().getModifier("unemployment").getDays() > 14 && citizen.getJob() == null);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.no.unemployment"), citizen -> citizen.getCitizenHappinessHandler().getModifier("unemployment").getDays() > 7 && citizen.getCitizenHappinessHandler().getModifier("unemployment").getDays() <= 14 && citizen.getJob() == null);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.demands.idleatjob"), citizen -> citizen.getCitizenHappinessHandler().getModifier("idleatjob").getDays() > 14);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.no.idleatjob"), citizen -> citizen.getCitizenHappinessHandler().getModifier("idleatjob").getDays() > 7 && citizen.getCitizenHappinessHandler().getModifier("idleatjob").getDays() <= 14);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.no.slepttonight"), citizen -> !(citizen.getJob() instanceof AbstractJobGuard) && citizen.getCitizenHappinessHandler().getModifier("slepttonight").getDays() <= 0);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.beekeeper.noflowers"), citizen -> citizen.getWorkBuilding() instanceof BuildingBeekeeper && ((BuildingBeekeeper)citizen.getWorkBuilding()).getModuleMatching(ItemListModule.class, m -> m.getId().equals("flowers")).getList().isEmpty());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.raining"), citizen -> citizen.getEntity().isPresent() && citizen.getEntity().get().func_130014_f_().func_72896_J() && !citizen.getColony().getRaiderManager().isRaided() && !citizen.getCitizenMournHandler().isMourning());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.raid"), citizen -> citizen.getEntity().isPresent() && citizen.getColony().getRaiderManager().isRaided());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.sleeping"), citizen -> citizen.getEntity().isPresent() && citizen.isAsleep());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.entity.citizen.mourning"), citizen -> citizen.getEntity().isPresent() && citizen.getCitizenMournHandler().isMourning() && !citizen.getColony().getRaiderManager().isRaided());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.chat.noguardnearwork"), citizen -> citizen.getWorkBuilding() != null && !citizen.getWorkBuilding().isGuardBuildingNear());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.chat.noguardnearhome"), citizen -> citizen.getHomeBuilding() != null && !citizen.getHomeBuilding().isGuardBuildingNear());
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.quarrier.noquarry"), citizen -> citizen.getJob() instanceof JobQuarrier && ((JobQuarrier)citizen.getJob()).findQuarry() == null);
        InteractionValidatorRegistry.registerStandardPredicate((ITextComponent)new TranslationTextComponent("com.minecolonies.coremod.quarrier.finishedquarry"), citizen -> citizen.getJob() instanceof JobQuarrier && ((JobQuarrier)citizen.getJob()).findQuarry() != null && ((JobQuarrier)citizen.getJob()).findQuarry().getFirstModuleOccurance(QuarryModule.class).isFinished());
    }
}

