/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface OptionalPredicate<T> {
    @NotNull
    public Optional<Boolean> test(T var1);

    @NotNull
    public static <T> OptionalPredicate<T> empty() {
        return t -> Optional.empty();
    }

    @NotNull
    default public Predicate<T> orElse(boolean fallback) {
        return t -> this.test(t).orElse(fallback);
    }

    @NotNull
    default public OptionalPredicate<T> combine(@NotNull OptionalPredicate<T> other) {
        return t -> OptionalPredicate.combine(this.test(t), () -> other.test(t));
    }

    public static <X> Optional<X> combine(@NotNull Optional<X> a, @NotNull Supplier<Optional<X>> b) {
        return a.isPresent() ? a : b.get();
    }
}

