/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.OptionalPredicate;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.ITag;
import org.jetbrains.annotations.NotNull;

public final class CraftingUtils {
    private CraftingUtils() {
        throw new IllegalStateException("Tried to initialize: CraftingUtils but this is a Utility class.");
    }

    public static int calculateMaxCraftingCount(@NotNull ItemStack outputStack, @NotNull IRecipeStorage storage) {
        int craftingCount = (int)Math.ceil((double)Math.max(ItemStackUtils.getSize(outputStack), ItemStackUtils.getSize(storage.getPrimaryOutput())) / (double)ItemStackUtils.getSize(storage.getPrimaryOutput()));
        for (ItemStorage ingredientStorage : storage.getCleanedInput()) {
            ItemStack ingredient = ingredientStorage.getItemStack();
            int ingredientInputCount = ItemStackUtils.getSize(ingredient) * craftingCount;
            if (ingredientInputCount <= ingredient.func_77976_d()) continue;
            craftingCount = Math.max(ingredient.func_77976_d(), ItemStackUtils.getSize(storage.getPrimaryOutput())) / ItemStackUtils.getSize(storage.getPrimaryOutput());
        }
        return craftingCount;
    }

    public static int calculateMaxCraftingCount(@NotNull int count, @NotNull IRecipeStorage storage) {
        return (int)Math.ceil((double)Math.max(count, ItemStackUtils.getSize(storage.getPrimaryOutput())) / (double)ItemStackUtils.getSize(storage.getPrimaryOutput()));
    }

    public static OptionalPredicate<ItemStack> getProductValidatorBasedOnTags(@NotNull String crafterJobName) {
        return stack -> {
            ITag<Item> excludedProducts = ModTags.crafterProductExclusions.get(crafterJobName);
            if (excludedProducts != null && excludedProducts.func_230235_a_((Object)stack.func_77973_b())) {
                return Optional.of(false);
            }
            ITag<Item> allowedProducts = ModTags.crafterProduct.get(crafterJobName);
            if (allowedProducts != null && allowedProducts.func_230235_a_((Object)stack.func_77973_b())) {
                return Optional.of(true);
            }
            return Optional.empty();
        };
    }

    public static OptionalPredicate<ItemStack> getIngredientValidatorBasedOnTags(@NotNull String crafterJobName) {
        return stack -> {
            ITag<Item> excludedIngredients = ModTags.crafterIngredientExclusions.get(crafterJobName);
            if (excludedIngredients != null && excludedIngredients.func_230235_a_((Object)stack.func_77973_b())) {
                return Optional.of(false);
            }
            ITag<Item> allowedIngredients = ModTags.crafterIngredient.get(crafterJobName);
            if (allowedIngredients != null && allowedIngredients.func_230235_a_((Object)stack.func_77973_b())) {
                return Optional.of(true);
            }
            return Optional.empty();
        };
    }

    public static Optional<Boolean> isRecipeCompatibleBasedOnTags(@NotNull IGenericRecipe recipe, @NotNull String crafterJobName) {
        return OptionalPredicate.combine(recipe.matchesOutput(CraftingUtils.getProductValidatorBasedOnTags(crafterJobName)), () -> recipe.matchesInput(CraftingUtils.getIngredientValidatorBasedOnTags(crafterJobName)));
    }
}

