/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen;

import com.google.common.collect.Lists;
import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.client.render.modeltype.registry.IModelTypeRegistry;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.ai.DesiredActivity;
import com.minecolonies.api.entity.ai.pathfinding.IWalkToProxy;
import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenChatHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenDiseaseHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenItemHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenStatusHandler;
import com.minecolonies.api.entity.pathfinding.AbstractAdvancedPathNavigate;
import com.minecolonies.api.entity.pathfinding.PathingStuckHandler;
import com.minecolonies.api.entity.pathfinding.registry.IPathNavigateRegistry;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.sounds.EventType;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SEntityEquipmentPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityCitizen
extends AbstractCivilianEntity
implements INamedContainerProvider {
    private static final double CITIZEN_SWIM_BONUS = 2.0;
    public static final DataParameter<Integer> DATA_LEVEL = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_TEXTURE = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_IS_FEMALE = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_COLONY_ID = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> DATA_CITIZEN_ID = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<String> DATA_MODEL = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> DATA_RENDER_METADATA = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Boolean> DATA_IS_ASLEEP = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> DATA_IS_CHILD = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<BlockPos> DATA_BED_POS = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187200_j);
    public static final DataParameter<String> DATA_STYLE = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> DATA_TEXTURE_SUFFIX = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<String> DATA_JOB = EntityDataManager.func_187226_a(AbstractEntityCitizen.class, (IDataSerializer)DataSerializers.field_187194_d);
    private ResourceLocation modelId = ModModelTypes.SETTLER_ID;
    private int textureId;
    private String renderMetadata = "";
    private boolean female;
    private ResourceLocation texture;
    private boolean textureDirty = true;
    private AbstractAdvancedPathNavigate pathNavigate;
    private int collisionCounter = 0;
    private static final int COLL_THRESHOLD = 50;
    private boolean isEquipmentDirty = true;

    public AbstractEntityCitizen(EntityType<? extends AgeableEntity> type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute getDefaultAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233819_b_, 100.0);
    }

    public GoalSelector getTasks() {
        return this.field_70714_bg;
    }

    public int getTicksExisted() {
        return this.field_70173_aa;
    }

    @NotNull
    public BlockPos func_233580_cy_() {
        return new BlockPos(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
    }

    public boolean func_98052_bS() {
        return false;
    }

    public boolean func_184186_bw() {
        return false;
    }

    @NotNull
    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        if (!player.field_70170_p.func_201670_d()) {
            SoundUtils.playSoundAtCitizenWith(CompatibilityUtils.getWorldFromCitizen(this), this.func_233580_cy_(), EventType.INTERACTION, this.getCitizenData());
        }
        return super.func_184199_a(player, vec, hand);
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void setTexture() {
        if (!CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).field_72995_K) {
            return;
        }
        this.texture = IModelTypeRegistry.getInstance().getModelType(this.getModelType()).getTexture(this);
        this.textureDirty = false;
    }

    public abstract ICitizenDataView getCitizenDataView();

    @NotNull
    public ResourceLocation getTexture() {
        String renderMeta = this.getRenderMetadata();
        if (this.texture == null || this.textureDirty || !this.texture.func_110623_a().contains(renderMeta) || !this.texture.func_110623_a().contains((CharSequence)this.func_184212_Q().func_187225_a(DATA_STYLE)) || !this.texture.func_110623_a().contains((CharSequence)this.func_184212_Q().func_187225_a(DATA_TEXTURE_SUFFIX))) {
            this.setTexture();
        }
        return this.texture;
    }

    public void setTextureDirty() {
        this.textureDirty = true;
    }

    public ResourceLocation getModelType() {
        return this.modelId;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity parent) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_TEXTURE_SUFFIX, (Object)"_b");
        this.field_70180_af.func_187214_a(DATA_TEXTURE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_LEVEL, (Object)0);
        this.field_70180_af.func_187214_a(DATA_STYLE, (Object)"default");
        this.field_70180_af.func_187214_a(DATA_IS_FEMALE, (Object)0);
        this.field_70180_af.func_187214_a(DATA_MODEL, (Object)ModModelTypes.SETTLER_ID.toString());
        this.field_70180_af.func_187214_a(DATA_RENDER_METADATA, (Object)"");
        this.field_70180_af.func_187214_a(DATA_IS_ASLEEP, (Object)false);
        this.field_70180_af.func_187214_a(DATA_IS_CHILD, (Object)false);
        this.field_70180_af.func_187214_a(DATA_BED_POS, (Object)new BlockPos(0, 0, 0));
        this.field_70180_af.func_187214_a(DATA_JOB, (Object)"");
    }

    public boolean isFemale() {
        return this.female;
    }

    public void setFemale(boolean female) {
        this.female = female;
    }

    @NotNull
    public AbstractAdvancedPathNavigate getNavigation() {
        if (this.pathNavigate == null) {
            this.pathNavigate = IPathNavigateRegistry.getInstance().getNavigateFor((MobEntity)this);
            this.field_70699_by = this.pathNavigate;
            this.pathNavigate.func_212239_d(true);
            this.pathNavigate.setSwimSpeedFactor(2.0);
            this.pathNavigate.getPathingOptions().setEnterDoors(true);
            this.pathNavigate.getPathingOptions().setCanOpenDoors(true);
            this.pathNavigate.setStuckHandler(PathingStuckHandler.createStuckHandler().withTeleportOnFullStuck().withTeleportSteps(5));
        }
        return this.pathNavigate;
    }

    public void func_70108_f(@NotNull Entity entityIn) {
        if ((this.collisionCounter += 2) > 50) {
            if (this.collisionCounter > 100) {
                this.collisionCounter = 0;
            }
            return;
        }
        super.func_70108_f(entityIn);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
        if (this.collisionCounter > 0) {
            --this.collisionCounter;
        }
    }

    protected void func_233642_cO_() {
    }

    protected void func_233641_cN_() {
    }

    public boolean func_230490_cK_() {
        return false;
    }

    public void setOwnRotation(float yaw, float pitch) {
        this.func_70101_b(yaw, pitch);
    }

    public void setModelId(ResourceLocation model) {
        this.modelId = model;
    }

    public void setRenderMetadata(String renderMetadata) {
        if (renderMetadata.equals(this.getRenderMetadata())) {
            return;
        }
        this.renderMetadata = renderMetadata;
        this.field_70180_af.func_187227_b(DATA_RENDER_METADATA, (Object)this.getRenderMetadata());
    }

    public int getTextureId() {
        return this.textureId;
    }

    public void setTextureId(int textureId) {
        this.textureId = textureId;
        this.field_70180_af.func_187227_b(DATA_TEXTURE, (Object)textureId);
    }

    public String getRenderMetadata() {
        return this.renderMetadata;
    }

    public Random func_70681_au() {
        return this.field_70146_Z;
    }

    public int getOffsetTicks() {
        return this.field_70173_aa + 7 * this.func_145782_y();
    }

    public boolean func_184585_cz() {
        return this.func_184607_cu().func_77973_b() instanceof ShieldItem;
    }

    public int getRecentlyHit() {
        return this.field_70718_bc;
    }

    public boolean checkCanDropLoot() {
        return this.func_146066_aG();
    }

    public abstract ILocation getLocation();

    public abstract boolean isWorkerAtSiteWithMove(@NotNull BlockPos var1, int var2);

    public abstract ICitizenData getCitizenData();

    @NotNull
    public abstract InventoryCitizen getInventoryCitizen();

    @NotNull
    public abstract IItemHandler getItemHandlerCitizen();

    @NotNull
    public abstract DesiredActivity getDesiredActivity();

    public abstract void setCitizensize(@NotNull float var1, @NotNull float var2);

    public abstract void setIsChild(boolean var1);

    public abstract void playMoveAwaySound();

    public abstract IWalkToProxy getProxy();

    public abstract void decreaseSaturationForAction();

    public abstract void decreaseSaturationForContinuousAction();

    public abstract ICitizenExperienceHandler getCitizenExperienceHandler();

    public abstract ICitizenChatHandler getCitizenChatHandler();

    public abstract ICitizenStatusHandler getCitizenStatusHandler();

    public abstract ICitizenItemHandler getCitizenItemHandler();

    public abstract ICitizenInventoryHandler getCitizenInventoryHandler();

    public abstract void setCitizenInventoryHandler(ICitizenInventoryHandler var1);

    public abstract ICitizenColonyHandler getCitizenColonyHandler();

    public abstract void setCitizenColonyHandler(ICitizenColonyHandler var1);

    public abstract ICitizenJobHandler getCitizenJobHandler();

    public abstract ICitizenSleepHandler getCitizenSleepHandler();

    public abstract ICitizenDiseaseHandler getCitizenDiseaseHandler();

    public abstract void setCitizenDiseaseHandler(ICitizenDiseaseHandler var1);

    public abstract boolean isOkayToEat();

    public abstract boolean shouldBeFed();

    public abstract boolean isIdlingAtJob();

    public abstract float getRotationYaw();

    public abstract float getRotationPitch();

    public abstract boolean isDead();

    public abstract void setCitizenSleepHandler(ICitizenSleepHandler var1);

    public abstract void setCitizenJobHandler(ICitizenJobHandler var1);

    public abstract void setCitizenItemHandler(ICitizenItemHandler var1);

    public abstract void setCitizenChatHandler(ICitizenChatHandler var1);

    public abstract void setCitizenExperienceHandler(ICitizenExperienceHandler var1);

    public abstract boolean isCurrentlyFleeing();

    public abstract void callForHelp(Entity var1, int var2);

    public abstract void setFleeingState(boolean var1);

    public void updatePose(Pose pose) {
        this.func_213301_b(pose);
    }

    public void func_241353_q_() {
        if (this.isEquipmentDirty) {
            this.isEquipmentDirty = false;
            ArrayList list = Lists.newArrayListWithCapacity((int)6);
            list.add(new Pair((Object)EquipmentSlotType.CHEST, (Object)this.func_184582_a(EquipmentSlotType.CHEST)));
            list.add(new Pair((Object)EquipmentSlotType.FEET, (Object)this.func_184582_a(EquipmentSlotType.FEET)));
            list.add(new Pair((Object)EquipmentSlotType.HEAD, (Object)this.func_184582_a(EquipmentSlotType.HEAD)));
            list.add(new Pair((Object)EquipmentSlotType.LEGS, (Object)this.func_184582_a(EquipmentSlotType.LEGS)));
            list.add(new Pair((Object)EquipmentSlotType.OFFHAND, (Object)this.func_184582_a(EquipmentSlotType.OFFHAND)));
            list.add(new Pair((Object)EquipmentSlotType.MAINHAND, (Object)this.func_184582_a(EquipmentSlotType.MAINHAND)));
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217218_b((Entity)this, (IPacket)new SEntityEquipmentPacket(this.func_145782_y(), (List)list));
        }
    }

    public void func_184201_a(EquipmentSlotType slot, @NotNull ItemStack newItem) {
        ItemStack previous;
        if (!this.field_70170_p.field_72995_K && !ItemStackUtils.compareItemStacksIgnoreStackSize(previous = this.func_184582_a(slot), newItem, false, true)) {
            if (!previous.func_190926_b()) {
                this.func_233645_dx_().func_233785_a_(previous.func_111283_C(slot));
            }
            if (!newItem.func_190926_b()) {
                this.func_233645_dx_().func_233793_b_(newItem.func_111283_C(slot));
            }
            this.markEquipmentDirty();
        }
        super.func_184201_a(slot, newItem);
    }

    public void markEquipmentDirty() {
        this.isEquipmentDirty = true;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_203004_j(boolean down) {
    }
}

