/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.ai.citizen.guards;

import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.IToolType;
import java.util.function.Predicate;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShieldItem;
import net.minecraft.util.Tuple;

public class GuardGear
implements Predicate<ItemStack> {
    private final int minLevelRequired;
    private final int maxLevelRequired;
    private final int minArmorLevel;
    private final int maxArmorLevel;
    private final int minBuildingLevelRequired;
    private final int maxBuildingLevelRequired;
    private final EquipmentSlotType type;
    private final IToolType itemNeeded;

    public GuardGear(IToolType item, EquipmentSlotType type, int minArmorLevel, int maxArmorLevel, Tuple<Integer, Integer> citizenLevelRange, Tuple<Integer, Integer> buildingLevelRange) {
        this.type = type;
        this.itemNeeded = item;
        this.minLevelRequired = (Integer)citizenLevelRange.func_76341_a();
        this.maxLevelRequired = (Integer)citizenLevelRange.func_76340_b();
        this.minArmorLevel = minArmorLevel;
        this.maxArmorLevel = maxArmorLevel;
        this.minBuildingLevelRequired = (Integer)buildingLevelRange.func_76341_a();
        this.maxBuildingLevelRequired = (Integer)buildingLevelRange.func_76340_b();
    }

    public int getMinLevelRequired() {
        return this.minLevelRequired;
    }

    public int getMaxLevelRequired() {
        return this.maxLevelRequired;
    }

    public EquipmentSlotType getType() {
        return this.type;
    }

    public int getMinArmorLevel() {
        return this.minArmorLevel;
    }

    public int getMaxArmorLevel() {
        return this.maxArmorLevel;
    }

    public IToolType getItemNeeded() {
        return this.itemNeeded;
    }

    public int getMinBuildingLevelRequired() {
        return this.minBuildingLevelRequired;
    }

    public int getMaxBuildingLevelRequired() {
        return this.maxBuildingLevelRequired;
    }

    @Override
    public boolean test(ItemStack stack) {
        return ItemStackUtils.hasToolLevel(stack, this.itemNeeded, this.minArmorLevel, this.maxArmorLevel) && stack.func_77973_b() instanceof ArmorItem && ((ArmorItem)stack.func_77973_b()).func_185083_B_() == this.getType() || stack.func_77973_b() instanceof ShieldItem && this.getType() == EquipmentSlotType.OFFHAND;
    }
}

