/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import org.jetbrains.annotations.NotNull;

public class CountedIngredient
extends Ingredient {
    public static final ResourceLocation ID = new ResourceLocation("minecolonies", "counted");
    @NotNull
    private final Ingredient child;
    private final int count;
    private ItemStack[] array = null;

    public CountedIngredient(@NotNull Ingredient child, int count) {
        super(Arrays.stream(child.func_193365_a()).map(Ingredient.SingleItemList::new));
        this.child = child;
        this.count = count;
    }

    @NotNull
    public Ingredient getChild() {
        return this.child;
    }

    public int getCount() {
        return this.count;
    }

    @NotNull
    public ItemStack[] func_193365_a() {
        if (this.array == null) {
            List<ItemStack> matchingStacks = Arrays.stream(this.child.func_193365_a()).map(ItemStack::func_77946_l).collect(Collectors.toList());
            matchingStacks.forEach(s -> s.func_190920_e(this.count));
            this.array = matchingStacks.toArray(new ItemStack[matchingStacks.size()]);
        }
        return this.array;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.getInstance();
    }

    public static class Serializer
    implements IIngredientSerializer<CountedIngredient> {
        private static final Serializer INSTANCE = new Serializer();

        public static Serializer getInstance() {
            return INSTANCE;
        }

        private Serializer() {
        }

        @NotNull
        public CountedIngredient parse(@NotNull JsonObject json) {
            Ingredient child = Ingredient.func_199802_a((JsonElement)json.get("item"));
            int count = JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1);
            return new CountedIngredient(child, count);
        }

        @NotNull
        public CountedIngredient parse(@NotNull PacketBuffer buffer) {
            int count = buffer.func_150792_a();
            Ingredient child = Ingredient.func_199566_b((PacketBuffer)buffer);
            return new CountedIngredient(child, count);
        }

        public void write(@NotNull PacketBuffer buffer, @NotNull CountedIngredient ingredient) {
            buffer.func_150787_b(ingredient.getCount());
            CraftingHelper.write((PacketBuffer)buffer, (Ingredient)ingredient.getChild());
        }
    }
}

