/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.configuration;

import com.minecolonies.api.colony.permissions.Explosions;
import com.minecolonies.api.configuration.AbstractConfiguration;
import com.minecolonies.api.util.constant.NameConstants;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfiguration
extends AbstractConfiguration {
    public final ForgeConfigSpec.BooleanValue useMiddleInitial;
    public final ForgeConfigSpec.BooleanValue useEasternNameOrder;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> maleFirstNames;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> femaleFirstNames;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> lastNames;
    public final ForgeConfigSpec.IntValue initialCitizenAmount;
    public final ForgeConfigSpec.BooleanValue builderPlaceConstructionTape;
    public final ForgeConfigSpec.BooleanValue allowInfiniteSupplyChests;
    public final ForgeConfigSpec.BooleanValue allowInfiniteColonies;
    public final ForgeConfigSpec.BooleanValue allowOtherDimColonies;
    public final ForgeConfigSpec.IntValue citizenRespawnInterval;
    public final ForgeConfigSpec.IntValue maxCitizenPerColony;
    public final ForgeConfigSpec.IntValue builderBuildBlockDelay;
    public final ForgeConfigSpec.IntValue blockMiningDelayModifier;
    public final ForgeConfigSpec.BooleanValue enableInDevelopmentFeatures;
    public final ForgeConfigSpec.BooleanValue alwaysRenderNameTag;
    public final ForgeConfigSpec.BooleanValue workersAlwaysWorkInRain;
    public final ForgeConfigSpec.BooleanValue sendEnteringLeavingMessages;
    public final ForgeConfigSpec.IntValue allowGlobalNameChanges;
    public final ForgeConfigSpec.BooleanValue holidayFeatures;
    public final ForgeConfigSpec.IntValue updateRate;
    public final ForgeConfigSpec.IntValue dirtFromCompost;
    public final ForgeConfigSpec.IntValue luckyBlockChance;
    public final ForgeConfigSpec.BooleanValue restrictBuilderUnderground;
    public final ForgeConfigSpec.IntValue minThLevelToTeleport;
    public final ForgeConfigSpec.BooleanValue suggestBuildToolPlacement;
    public final ForgeConfigSpec.DoubleValue foodModifier;
    public final ForgeConfigSpec.IntValue diseaseModifier;
    public final ForgeConfigSpec.BooleanValue forceLoadColony;
    public final ForgeConfigSpec.IntValue colonyLoadStrictness;
    public final ForgeConfigSpec.IntValue badVisitorsChance;
    public final ForgeConfigSpec.IntValue maxTreeSize;
    public final ForgeConfigSpec.BooleanValue noSupplyPlacementRestrictions;
    public final ForgeConfigSpec.BooleanValue skyRaiders;
    public final ForgeConfigSpec.BooleanValue researchCreativeCompletion;
    public final ForgeConfigSpec.BooleanValue researchDebugLog;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> researchResetCost;
    public final ForgeConfigSpec.BooleanValue canPlayerUseRTPCommand;
    public final ForgeConfigSpec.BooleanValue canPlayerUseColonyTPCommand;
    public final ForgeConfigSpec.BooleanValue canPlayerUseAllyTHTeleport;
    public final ForgeConfigSpec.BooleanValue canPlayerUseHomeTPCommand;
    public final ForgeConfigSpec.BooleanValue canPlayerUseShowColonyInfoCommand;
    public final ForgeConfigSpec.BooleanValue canPlayerUseKillCitizensCommand;
    public final ForgeConfigSpec.BooleanValue canPlayerUseAddOfficerCommand;
    public final ForgeConfigSpec.BooleanValue canPlayerUseDeleteColonyCommand;
    public final ForgeConfigSpec.IntValue numberOfAttemptsForSafeTP;
    public final ForgeConfigSpec.IntValue maxColonySize;
    public final ForgeConfigSpec.IntValue minColonyDistance;
    public final ForgeConfigSpec.IntValue initialColonySize;
    public final ForgeConfigSpec.BooleanValue restrictColonyPlacement;
    public final ForgeConfigSpec.IntValue maxDistanceFromWorldSpawn;
    public final ForgeConfigSpec.IntValue minDistanceFromWorldSpawn;
    public final ForgeConfigSpec.BooleanValue officersReceiveAdvancements;
    public final ForgeConfigSpec.BooleanValue doBarbariansSpawn;
    public final ForgeConfigSpec.IntValue barbarianHordeDifficulty;
    public final ForgeConfigSpec.IntValue spawnBarbarianSize;
    public final ForgeConfigSpec.IntValue maxBarbarianSize;
    public final ForgeConfigSpec.BooleanValue doBarbariansBreakThroughWalls;
    public final ForgeConfigSpec.IntValue averageNumberOfNightsBetweenRaids;
    public final ForgeConfigSpec.IntValue minimumNumberOfNightsBetweenRaids;
    public final ForgeConfigSpec.BooleanValue shouldRaidersBreakDoors;
    public final ForgeConfigSpec.BooleanValue mobAttackCitizens;
    public final ForgeConfigSpec.BooleanValue citizenCallForHelp;
    public final ForgeConfigSpec.DoubleValue rangerDamageMult;
    public final ForgeConfigSpec.DoubleValue knightDamageMult;
    public final ForgeConfigSpec.DoubleValue guardHealthMult;
    public final ForgeConfigSpec.BooleanValue pvp_mode;
    public final ForgeConfigSpec.IntValue daysUntilPirateshipsDespawn;
    public final ForgeConfigSpec.IntValue maxYForBarbarians;
    public final ForgeConfigSpec.BooleanValue enableColonyProtection;
    public final ForgeConfigSpec.EnumValue<Explosions> turnOffExplosionsInColonies;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> specialPermGroup;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> freeToInteractBlocks;
    public final ForgeConfigSpec.IntValue secondsBetweenPermissionMessages;
    public final ForgeConfigSpec.IntValue maxkeptbackups;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> enabledModTags;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> configListStudyItems;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> configListRecruitmentItems;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> luckyOres;
    public final ForgeConfigSpec.DoubleValue enchanterExperienceMultiplier;
    public final ForgeConfigSpec.IntValue dynamicTreeHarvestSize;
    public final ForgeConfigSpec.IntValue fishingRodDurabilityAdjustT1;
    public final ForgeConfigSpec.IntValue fishingRodDurabilityAdjustT2;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> diseases;
    public final ForgeConfigSpec.BooleanValue debugInventories;
    public final ForgeConfigSpec.IntValue pathfindingDebugVerbosity;
    public final ForgeConfigSpec.IntValue pathfindingMaxThreadCount;
    public final ForgeConfigSpec.IntValue minimumRailsToPath;
    public final ForgeConfigSpec.BooleanValue enableDebugLogging;
    public final ForgeConfigSpec.IntValue maximalRetries;
    public final ForgeConfigSpec.IntValue delayBetweenRetries;
    public final ForgeConfigSpec.BooleanValue creativeResolve;
    public final ForgeConfigSpec.BooleanValue canPlayerUseResetCommand;

    protected ServerConfiguration(ForgeConfigSpec.Builder builder) {
        this.createCategory(builder, "names");
        this.useMiddleInitial = ServerConfiguration.defineBoolean(builder, "usemiddleinitial", true);
        this.useEasternNameOrder = ServerConfiguration.defineBoolean(builder, "useeasternnameorder", false);
        this.maleFirstNames = ServerConfiguration.defineList(builder, "malefirstnames", Arrays.asList(NameConstants.maleFirstNames), s -> s instanceof String);
        this.femaleFirstNames = ServerConfiguration.defineList(builder, "femalefirstnames", Arrays.asList(NameConstants.femaleFirstNames), s -> s instanceof String);
        this.lastNames = ServerConfiguration.defineList(builder, "lastnames", Arrays.asList(NameConstants.lastNames), s -> s instanceof String);
        this.swapToCategory(builder, "gameplay");
        this.initialCitizenAmount = ServerConfiguration.defineInteger(builder, "initialcitizenamount", 4, 1, 10);
        this.builderPlaceConstructionTape = ServerConfiguration.defineBoolean(builder, "builderplaceconstructiontape", true);
        this.allowInfiniteSupplyChests = ServerConfiguration.defineBoolean(builder, "allowinfinitesupplychests", false);
        this.allowInfiniteColonies = ServerConfiguration.defineBoolean(builder, "allowinfinitecolonies", false);
        this.allowOtherDimColonies = ServerConfiguration.defineBoolean(builder, "allowotherdimcolonies", true);
        this.citizenRespawnInterval = ServerConfiguration.defineInteger(builder, "citizenrespawninterval", 60, 10, 600);
        this.maxCitizenPerColony = ServerConfiguration.defineInteger(builder, "maxcitizenpercolony", 250, 4, 500);
        this.builderBuildBlockDelay = ServerConfiguration.defineInteger(builder, "builderbuildblockdelay", 15, 1, 500);
        this.blockMiningDelayModifier = ServerConfiguration.defineInteger(builder, "blockminingdelaymodifier", 500, 1, 10000);
        this.enableInDevelopmentFeatures = ServerConfiguration.defineBoolean(builder, "enableindevelopmentfeatures", false);
        this.alwaysRenderNameTag = ServerConfiguration.defineBoolean(builder, "alwaysrendernametag", true);
        this.workersAlwaysWorkInRain = ServerConfiguration.defineBoolean(builder, "workersalwaysworkinrain", false);
        this.sendEnteringLeavingMessages = ServerConfiguration.defineBoolean(builder, "sendenteringleavingmessages", true);
        this.allowGlobalNameChanges = ServerConfiguration.defineInteger(builder, "allowglobalnamechanges", 1, -1, 1);
        this.holidayFeatures = ServerConfiguration.defineBoolean(builder, "holidayfeatures", true);
        this.updateRate = ServerConfiguration.defineInteger(builder, "updaterate", 1, 1, 100);
        this.dirtFromCompost = ServerConfiguration.defineInteger(builder, "dirtfromcompost", 1, 0, 100);
        this.luckyBlockChance = ServerConfiguration.defineInteger(builder, "luckyblockchance", 1, 0, 100);
        this.restrictBuilderUnderground = ServerConfiguration.defineBoolean(builder, "restrictbuilderunderground", true);
        this.minThLevelToTeleport = ServerConfiguration.defineInteger(builder, "minthleveltoteleport", 3, 0, 5);
        this.suggestBuildToolPlacement = ServerConfiguration.defineBoolean(builder, "suggestbuildtoolplacement", true);
        this.foodModifier = ServerConfiguration.defineDouble(builder, "foodmodifier", 1.0, 0.1, 100.0);
        this.diseaseModifier = ServerConfiguration.defineInteger(builder, "diseasemodifier", 5, 1, 100);
        this.forceLoadColony = ServerConfiguration.defineBoolean(builder, "forceloadcolony", false);
        this.colonyLoadStrictness = ServerConfiguration.defineInteger(builder, "colonyloadstrictness", 3, 1, 15);
        this.badVisitorsChance = ServerConfiguration.defineInteger(builder, "badvisitorchance", 2, 1, 100);
        this.maxTreeSize = ServerConfiguration.defineInteger(builder, "maxtreesize", 400, 1, 1000);
        this.noSupplyPlacementRestrictions = ServerConfiguration.defineBoolean(builder, "nosupplyplacementrestrictions", false);
        this.skyRaiders = ServerConfiguration.defineBoolean(builder, "skyraiders", false);
        this.swapToCategory(builder, "research");
        this.researchCreativeCompletion = ServerConfiguration.defineBoolean(builder, "researchcreativecompletion", true);
        this.researchDebugLog = ServerConfiguration.defineBoolean(builder, "researchdebuglog", false);
        this.researchResetCost = ServerConfiguration.defineList(builder, "researchresetcost", Arrays.asList("minecolonies:ancienttome:1"), s -> s instanceof String);
        this.swapToCategory(builder, "commands");
        this.canPlayerUseRTPCommand = ServerConfiguration.defineBoolean(builder, "canplayerusertpcommand", false);
        this.canPlayerUseColonyTPCommand = ServerConfiguration.defineBoolean(builder, "canplayerusecolonytpcommand", false);
        this.canPlayerUseAllyTHTeleport = ServerConfiguration.defineBoolean(builder, "canplayeruseallytownhallteleport", true);
        this.canPlayerUseHomeTPCommand = ServerConfiguration.defineBoolean(builder, "canplayerusehometpcommand", false);
        this.canPlayerUseShowColonyInfoCommand = ServerConfiguration.defineBoolean(builder, "canplayeruseshowcolonyinfocommand", true);
        this.canPlayerUseKillCitizensCommand = ServerConfiguration.defineBoolean(builder, "canplayerusekillcitizenscommand", false);
        this.canPlayerUseAddOfficerCommand = ServerConfiguration.defineBoolean(builder, "canplayeruseaddofficercommand", true);
        this.canPlayerUseDeleteColonyCommand = ServerConfiguration.defineBoolean(builder, "canplayerusedeletecolonycommand", true);
        this.numberOfAttemptsForSafeTP = ServerConfiguration.defineInteger(builder, "numberofattemptsforsafetp", 4, 1, 10);
        this.swapToCategory(builder, "claims");
        this.maxColonySize = ServerConfiguration.defineInteger(builder, "maxColonySize", 20, 1, 50);
        this.minColonyDistance = ServerConfiguration.defineInteger(builder, "minColonyDistance", 8, 1, 200);
        this.initialColonySize = ServerConfiguration.defineInteger(builder, "initialColonySize", 4, 1, 15);
        this.restrictColonyPlacement = ServerConfiguration.defineBoolean(builder, "restrictcolonyplacement", false);
        this.maxDistanceFromWorldSpawn = ServerConfiguration.defineInteger(builder, "maxdistancefromworldspawn", 8000, 1000, 100000);
        this.minDistanceFromWorldSpawn = ServerConfiguration.defineInteger(builder, "mindistancefromworldspawn", 512, 1, 1000);
        this.officersReceiveAdvancements = ServerConfiguration.defineBoolean(builder, "officersreceiveadvancements", true);
        this.swapToCategory(builder, "combat");
        this.doBarbariansSpawn = ServerConfiguration.defineBoolean(builder, "dobarbariansspawn", true);
        this.barbarianHordeDifficulty = ServerConfiguration.defineInteger(builder, "barbarianhordedifficulty", 5, 0, 10);
        this.spawnBarbarianSize = ServerConfiguration.defineInteger(builder, "spawnbarbariansize", 5, 1, 10);
        this.maxBarbarianSize = ServerConfiguration.defineInteger(builder, "maxBarbarianSize", 80, 6, 400);
        this.doBarbariansBreakThroughWalls = ServerConfiguration.defineBoolean(builder, "dobarbariansbreakthroughwalls", true);
        this.averageNumberOfNightsBetweenRaids = ServerConfiguration.defineInteger(builder, "averagenumberofnightsbetweenraids", 14, 1, 50);
        this.minimumNumberOfNightsBetweenRaids = ServerConfiguration.defineInteger(builder, "minimumnumberofnightsbetweenraids", 10, 1, 30);
        this.mobAttackCitizens = ServerConfiguration.defineBoolean(builder, "mobattackcitizens", true);
        this.shouldRaidersBreakDoors = ServerConfiguration.defineBoolean(builder, "shouldraiderbreakdoors", true);
        this.citizenCallForHelp = ServerConfiguration.defineBoolean(builder, "citizencallforhelp", true);
        this.rangerDamageMult = ServerConfiguration.defineDouble(builder, "rangerdamagemult", 1.0, 0.1, 5.0);
        this.knightDamageMult = ServerConfiguration.defineDouble(builder, "knightdamagemult", 1.0, 0.1, 5.0);
        this.guardHealthMult = ServerConfiguration.defineDouble(builder, "guardhealthmult", 1.0, 0.1, 5.0);
        this.pvp_mode = ServerConfiguration.defineBoolean(builder, "pvp_mode", false);
        this.daysUntilPirateshipsDespawn = ServerConfiguration.defineInteger(builder, "daysuntilpirateshipsdespawn", 3, 1, 10);
        this.maxYForBarbarians = ServerConfiguration.defineInteger(builder, "maxyforbarbarians", 200, 1, 500);
        this.swapToCategory(builder, "permissions");
        this.enableColonyProtection = ServerConfiguration.defineBoolean(builder, "enablecolonyprotection", true);
        this.maxkeptbackups = ServerConfiguration.defineInteger(builder, "maxkeptbackups", 50, 3, 5000);
        this.turnOffExplosionsInColonies = ServerConfiguration.defineEnum(builder, "turnoffexplosionsincolonies", Explosions.DAMAGE_ENTITIES);
        this.specialPermGroup = ServerConfiguration.defineList(builder, "specialpermgroup", Arrays.asList("_Raycoms_"), s -> s instanceof String);
        this.freeToInteractBlocks = ServerConfiguration.defineList(builder, "freetointeractblocks", Arrays.asList("dirt", "0 0 0"), s -> s instanceof String);
        this.secondsBetweenPermissionMessages = ServerConfiguration.defineInteger(builder, "secondsBetweenPermissionMessages", 30, 1, 1000);
        this.swapToCategory(builder, "compatibility");
        this.enabledModTags = ServerConfiguration.defineList(builder, "enabledmodtags", Arrays.asList("minecraft:wool", "minecraft:planks", "minecraft:stone_bricks", "minecraft:wooden_buttons", "minecraft:buttons", "minecraft:carpets", "minecraft:wooden_doors", "minecraft:wooden_stairs", "minecraft:wooden_slabs", "minecraft:wooden_fences", "minecraft:wooden_pressure_plates", "minecraft:wooden_trapdoors", "minecraft:saplings", "minecraft:logs", "minecraft:dark_oak_logs", "minecraft:oak_logs", "minecraft:birch_logs", "minecraft:acacia_logs", "minecraft:jungle_logs", "minecraft:spruce_logs", "minecraft:banners", "minecraft:sand", "minecraft:walls", "minecraft:anvil", "minecraft:leaves", "minecraft:small_flowers", "minecraft:beds", "minecraft:fishes", "minecraft:signs", "minecraft:music_discs", "minecraft:arrows", "forge:bones", "forge:bookshelves", "forge:chests/ender", "forge:chests/trapped", "forge:chests/wooden", "forge:cobblestone", "forge:crops/beetroot", "forge:crops/carrot", "forge:crops/nether_wart", "forge:crops/potato", "forge:crops/wheat", "forge:dusts/prismarine", "forge:dusts/redstone", "forge:dusts/glowstone", "forge:dyes", "forge:dyes/black", "forge:dyes/red", "forge:dyes/green", "forge:dyes/brown", "forge:dyes/blue", "forge:dyes/purple", "forge:dyes/cyan", "forge:dyes/light_gray", "forge:dyes/gray", "forge:dyes/pink", "forge:dyes/lime", "forge:dyes/yellow", "forge:dyes/light_blue", "forge:dyes/magenta", "forge:dyes/orange", "forge:dyes/white", "forge:eggs", "forge:ender_pearls", "forge:feathers", "forge:fence_gates", "forge:fence_gates/wooden", "forge:fences", "forge:fences/nether_brick", "forge:fences/wooden", "forge:gems/diamond", "forge:gems/emerald", "forge:gems/lapis", "forge:gems/prismarine", "forge:gems/quartz", "forge:glass", "forge:glass/black", "forge:glass/blue", "forge:glass/brown", "forge:glass/colorless", "forge:glass/cyan", "forge:glass/gray", "forge:glass/green", "forge:glass/light_blue", "forge:glass/light_gray", "forge:glass/lime", "forge:glass/magenta", "forge:glass/orange", "forge:glass/pink", "forge:glass/purple", "forge:glass/red", "forge:glass/white", "forge:glass/yellow", "forge:glass_panes", "forge:glass_panes/black", "forge:glass_panes/blue", "forge:glass_panes/brown", "forge:glass_panes/colorless", "forge:glass_panes/cyan", "forge:glass_panes/gray", "forge:glass_panes/green", "forge:glass_panes/light_blue", "forge:glass_panes/light_gray", "forge:glass_panes/lime", "forge:glass_panes/magenta", "forge:glass_panes/orange", "forge:glass_panes/pink", "forge:glass_panes/purple", "forge:glass_panes/red", "forge:glass_panes/white", "forge:glass_panes/yellow", "forge:gravel", "forge:gunpowder", "forge:heads", "forge:ingots/brick", "forge:ingots/gold", "forge:ingots/iron", "forge:ingots/nether_brick", "forge:leather", "forge:mushrooms", "forge:nether_stars", "forge:netherrack", "forge:nuggets/gold", "forge:nuggets/iron", "forge:obsidian", "forge:ores/coal", "forge:ores/diamond", "forge:ores/emerald", "forge:ores/gold", "forge:ores/iron", "forge:ores/lapis", "forge:ores/quartz", "forge:ores/redstone", "forge:rods/blaze", "forge:rods/wooden", "forge:sand", "forge:sand/colorless", "forge:sand/red", "forge:sandstone", "forge:seeds", "forge:seeds/beetroot", "forge:seeds/melon", "forge:seeds/pumpkin", "forge:seeds/wheat", "forge:slimeballs", "forge:stained_glass", "forge:stained_glass_panes", "forge:stone", "forge:storage_blocks/coal", "forge:storage_blocks/diamond", "forge:storage_blocks/emerald", "forge:storage_blocks/gold", "forge:storage_blocks/iron", "forge:storage_blocks/lapis", "forge:storage_blocks/quartz", "forge:storage_blocks/redstone", "forge:string"), s -> s instanceof String);
        this.configListStudyItems = ServerConfiguration.defineList(builder, "configliststudyitems", Arrays.asList("minecraft:paper;400;100", "minecraft:book;600;10"), s -> s instanceof String);
        this.configListRecruitmentItems = ServerConfiguration.defineList(builder, "configlistrecruitmentitems", Arrays.asList("minecraft:hay_block;3", "minecraft:book;2", "minecraft:enchanted_book;9", "minecraft:diamond;9", "minecraft:emerald;8", "minecraft:baked_potato;1", "minecraft:gold_ingot;2", "minecraft:redstone;2", "minecraft:lapis_lazuli;2", "minecraft:cake;11", "minecraft:sunflower;5", "minecraft:honeycomb;6", "minecraft:quartz;3"), s -> s instanceof String);
        this.luckyOres = ServerConfiguration.defineList(builder, "luckyores", Arrays.asList("minecraft:coal_ore!64", "minecraft:iron_ore!32", "minecraft:gold_ore!16", "minecraft:redstone_ore!8", "minecraft:lapis_ore!4", "minecraft:diamond_ore!2", "minecraft:emerald_ore!1"), s -> s instanceof String);
        this.enchanterExperienceMultiplier = ServerConfiguration.defineDouble(builder, "enchanterexperiencemultiplier", 2.0, 1.0, 10.0);
        this.dynamicTreeHarvestSize = ServerConfiguration.defineInteger(builder, "dynamictreeharvestsize", 5, 1, 8);
        this.fishingRodDurabilityAdjustT2 = ServerConfiguration.defineInteger(builder, "fishingroddurabilityadjustt2", 6, -249, 250000);
        this.fishingRodDurabilityAdjustT1 = ServerConfiguration.defineInteger(builder, "fishingroddurabilityadjustt1", 22, -58, 250000);
        this.diseases = ServerConfiguration.defineList(builder, "diseases", Arrays.asList("Influenza,100,minecraft:carrot,minecraft:potato", "Measles,10,minecraft:dandelion,minecraft:kelp,minecraft:poppy", "Smallpox,1,minecraft:honey_bottle,minecraft:golden_apple"), s -> s instanceof String);
        this.debugInventories = ServerConfiguration.defineBoolean(builder, "debuginventories", false);
        this.swapToCategory(builder, "pathfinding");
        this.pathfindingDebugVerbosity = ServerConfiguration.defineInteger(builder, "pathfindingdebugverbosity", 0, 0, 10);
        this.minimumRailsToPath = ServerConfiguration.defineInteger(builder, "minimumrailstopath", 8, 5, 100);
        this.pathfindingMaxThreadCount = ServerConfiguration.defineInteger(builder, "pathfindingmaxthreadcount", 2, 1, 10);
        this.swapToCategory(builder, "requestSystem");
        this.enableDebugLogging = ServerConfiguration.defineBoolean(builder, "enabledebuglogging", false);
        this.maximalRetries = ServerConfiguration.defineInteger(builder, "maximalretries", 3, 1, 10);
        this.delayBetweenRetries = ServerConfiguration.defineInteger(builder, "delaybetweenretries", 1200, 30, 10000);
        this.creativeResolve = ServerConfiguration.defineBoolean(builder, "creativeresolve", false);
        this.canPlayerUseResetCommand = ServerConfiguration.defineBoolean(builder, "canplayeruseresetcommand", false);
        this.finishCategory(builder);
    }
}

