/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable.deliveryman;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.NotNull;

public class Delivery
extends AbstractDeliverymanRequestable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Delivery.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_START = "Start";
    private static final String NBT_TARGET = "Target";
    private static final String NBT_STACK = "Stack";
    @NotNull
    private final ILocation start;
    @NotNull
    private final ILocation target;
    @NotNull
    private final ItemStack stack;

    public Delivery(@NotNull ILocation start, @NotNull ILocation target, @NotNull ItemStack stack, int priority) {
        super(priority);
        this.start = start;
        this.target = target;
        this.stack = stack;
    }

    @NotNull
    public static CompoundNBT serialize(@NotNull IFactoryController controller, Delivery delivery) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_218657_a(NBT_START, (INBT)controller.serialize(delivery.getStart()));
        compound.func_218657_a(NBT_TARGET, (INBT)controller.serialize(delivery.getTarget()));
        compound.func_218657_a(NBT_STACK, (INBT)delivery.getStack().serializeNBT());
        compound.func_218657_a("Priority", (INBT)controller.serialize(delivery.getPriority()));
        return compound;
    }

    @NotNull
    public static Delivery deserialize(@NotNull IFactoryController controller, @NotNull CompoundNBT compound) {
        ILocation start = (ILocation)controller.deserialize(compound.func_74775_l(NBT_START));
        ILocation target = (ILocation)controller.deserialize(compound.func_74775_l(NBT_TARGET));
        ItemStack stack = ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_STACK));
        int priority = (Integer)controller.deserialize(compound.func_74775_l("Priority"));
        return new Delivery(start, target, stack, priority);
    }

    public static void serialize(IFactoryController controller, PacketBuffer buffer, Delivery input) {
        controller.serialize(buffer, input.getStart());
        controller.serialize(buffer, input.getTarget());
        buffer.func_150788_a(input.getStack());
        buffer.writeInt(input.getPriority());
    }

    public static Delivery deserialize(IFactoryController controller, PacketBuffer buffer) {
        ILocation start = (ILocation)controller.deserialize(buffer);
        ILocation target = (ILocation)controller.deserialize(buffer);
        ItemStack stack = buffer.func_150791_c();
        int priority = buffer.readInt();
        return new Delivery(start, target, stack, priority);
    }

    @NotNull
    public ILocation getStart() {
        return this.start;
    }

    @NotNull
    public ILocation getTarget() {
        return this.target;
    }

    @NotNull
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Delivery)) {
            return false;
        }
        Delivery delivery = (Delivery)o;
        if (!this.getStart().equals(delivery.getStart())) {
            return false;
        }
        if (!this.getTarget().equals(delivery.getTarget())) {
            return false;
        }
        return ItemStackUtils.compareItemStacksIgnoreStackSize(this.getStack(), delivery.getStack());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.getStart().hashCode();
        result = 31 * result + this.getTarget().hashCode();
        result = 31 * result + this.getStack().hashCode();
        return result;
    }

    public String toString() {
        return "Delivery{start=" + this.start + ", target=" + this.target + ", stack=" + this.stack + ", priority=" + this.priority + '}';
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

