/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.requestsystem.requestable;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.ReflectionUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class Tag
implements IDeliverable {
    private static final Set<TypeToken<?>> TYPE_TOKENS = ReflectionUtils.getSuperClasses(TypeToken.of(Tag.class)).stream().filter(type -> !type.equals(TypeConstants.OBJECT)).collect(Collectors.toSet());
    private static final String NBT_TAG = "Tag";
    private static final String NBT_RESULT = "Result";
    private static final String NBT_COUNT = "Count";
    private static final String NBT_MINCOUNT = "MinCount";
    @NotNull
    private final ITag<Item> theTag;
    @NotNull
    private ItemStack result;
    private int count;
    private int minCount;

    public Tag(@NotNull ITag<Item> tag, int count) {
        this(tag, count, count);
    }

    public Tag(@NotNull ITag<Item> tag, int count, int minCount) {
        this(tag, ItemStackUtils.EMPTY, count, minCount);
    }

    public Tag(@NotNull ITag<Item> tag, @NotNull ItemStack result, int count, int minCount) {
        this.theTag = tag;
        this.result = result;
        this.count = count;
        this.minCount = minCount;
    }

    @Override
    public boolean matches(@NotNull ItemStack stack) {
        return stack.func_77973_b().func_206844_a(this.theTag);
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public int getMinimumCount() {
        return this.minCount;
    }

    @Override
    @NotNull
    public ItemStack getResult() {
        return this.result;
    }

    @NotNull
    public ITag<Item> getTag() {
        return this.theTag;
    }

    @Override
    public void setResult(@NotNull ItemStack result) {
        this.result = result;
    }

    @Override
    public IDeliverable copyWithCount(int newCount) {
        return new Tag(this.theTag, this.result, newCount, this.minCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tag tag1 = (Tag)o;
        return this.getCount() == tag1.getCount() && this.getMinimumCount() == tag1.getMinimumCount() && this.getTag().equals(tag1.getTag()) && this.getResult().equals(tag1.getResult());
    }

    public int hashCode() {
        int result1 = ItemTags.func_199903_a().func_232975_b_(this.getTag()).toString().hashCode();
        result1 = 31 * result1 + this.getResult().hashCode();
        return result1;
    }

    public static CompoundNBT serialize(IFactoryController controller, Tag input) {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74778_a(NBT_TAG, ItemTags.func_199903_a().func_232975_b_(input.getTag()).toString());
        if (!ItemStackUtils.isEmpty(input.getResult()).booleanValue()) {
            compound.func_218657_a(NBT_RESULT, (INBT)input.getResult().serializeNBT());
        }
        compound.func_74768_a(NBT_COUNT, input.getCount());
        compound.func_74768_a(NBT_MINCOUNT, input.getMinimumCount());
        return compound;
    }

    public static void serialize(IFactoryController controller, PacketBuffer buffer, Tag input) {
        buffer.func_180714_a(ItemTags.func_199903_a().func_232975_b_(input.getTag()).toString());
        buffer.writeBoolean(ItemStackUtils.isEmpty(input.getResult()) == false);
        if (!ItemStackUtils.isEmpty(input.getResult()).booleanValue()) {
            buffer.func_150788_a(input.getResult());
        }
        buffer.writeInt(input.getCount());
        buffer.writeInt(input.getMinimumCount());
    }

    public static Tag deserialize(IFactoryController controller, PacketBuffer buffer) {
        ITag theTag = ItemTags.func_199903_a().func_199910_a(ResourceLocation.func_208304_a((String)buffer.func_150789_c(Short.MAX_VALUE)));
        ItemStack result = buffer.readBoolean() ? buffer.func_150791_c() : ItemStack.field_190927_a;
        int count = buffer.readInt();
        int minCount = buffer.readInt();
        return new Tag((ITag<Item>)theTag, result, count, minCount);
    }

    public static Tag deserialize(IFactoryController controller, CompoundNBT compound) {
        int count;
        ITag.INamedTag theTag = ItemTags.func_199901_a((String)compound.func_74779_i(NBT_TAG));
        ItemStack result = compound.func_150296_c().contains(NBT_RESULT) ? ItemStackUtils.deserializeFromNBT(compound.func_74775_l(NBT_RESULT)) : ItemStackUtils.EMPTY;
        int minCount = count = compound.func_74762_e("size");
        if (compound.func_150296_c().contains(NBT_COUNT)) {
            count = compound.func_74762_e(NBT_COUNT);
            minCount = compound.func_74762_e(NBT_MINCOUNT);
        }
        return new Tag((ITag<Item>)theTag, result, count, minCount);
    }

    @Override
    public Set<TypeToken<?>> getSuperClasses() {
        return TYPE_TOKENS;
    }
}

