/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.colonyEvents.registry;

import com.minecolonies.api.colony.colonyEvents.descriptions.IColonyEventDescription;
import com.minecolonies.api.util.Log;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class ColonyEventDescriptionTypeRegistryEntry
extends ForgeRegistryEntry<ColonyEventDescriptionTypeRegistryEntry> {
    private final Function<CompoundNBT, IColonyEventDescription> nbtEventDescriptionCreator;
    private final Function<PacketBuffer, IColonyEventDescription> packetBufferEventDescriptionCreator;

    public ColonyEventDescriptionTypeRegistryEntry(@NotNull Function<CompoundNBT, IColonyEventDescription> nbtEventCreator, @NotNull Function<PacketBuffer, IColonyEventDescription> packetBufferEventCreator, @NotNull ResourceLocation registryID) {
        if (registryID.func_110623_a().isEmpty()) {
            Log.getLogger().warn("Created empty registry empty for event, supply a name for it!");
        }
        this.nbtEventDescriptionCreator = nbtEventCreator;
        this.packetBufferEventDescriptionCreator = packetBufferEventCreator;
        this.setRegistryName(registryID);
    }

    public IColonyEventDescription deserializeEventDescriptionFromNBT(@Nonnull CompoundNBT compound) {
        return this.nbtEventDescriptionCreator.apply(compound);
    }

    public IColonyEventDescription deserializeEventDescriptionFromPacketBuffer(@Nonnull PacketBuffer buffer) {
        return this.packetBufferEventDescriptionCreator.apply(buffer);
    }
}

