/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.Nullable;

public interface IGuardBuilding
extends IBuilding {
    public static final int PATROL_DISTANCE = 30;

    public static boolean checkIfGuardShouldTakeDamage(AbstractEntityCitizen citizen, PlayerEntity player) {
        IBuilding buildingWorker = citizen.getCitizenColonyHandler().getWorkBuilding();
        if (!(buildingWorker instanceof IGuardBuilding)) {
            return true;
        }
        return !player.equals((Object)((IGuardBuilding)buildingWorker).getPlayerToFollowOrRally());
    }

    public String getTask();

    @Nullable
    public BlockPos getNextPatrolTarget(boolean var1);

    public void arrivedAtPatrolPoint(AbstractEntityCitizen var1);

    public int getPatrolDistance();

    public boolean shallRetrieveOnLowHealth();

    public boolean shallPatrolManually();

    public boolean isTightGrouping();

    public BlockPos getGuardPos();

    public void setGuardPos(BlockPos var1);

    public PlayerEntity getPlayerToFollowOrRally();

    public void setPlayerToFollow(PlayerEntity var1);

    public ILocation getRallyLocation();

    public void setRallyLocation(ILocation var1);

    public BlockPos getPositionToFollow();

    public void addPatrolTargets(BlockPos var1);

    public void resetPatrolTargets();

    public int getBonusVision();

    public void calculateMobs();

    public boolean requiresManualTarget();

    public BlockPos getMinePos();
}

