/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.blocks.decorative;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesFalling;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SixWayBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBlockMinecoloniesConstructionTape<B extends AbstractBlockMinecoloniesConstructionTape<B>>
extends AbstractBlockMinecoloniesFalling<B>
implements IWaterLoggable {
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected VoxelShape[] shapes = new VoxelShape[0];
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty CORNER = BooleanProperty.func_177716_a((String)"corner");

    public AbstractBlockMinecoloniesConstructionTape(AbstractBlock.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[this.getIndex(state)];
    }

    private static int getMask(Direction facing) {
        return 1 << facing.func_176736_b();
    }

    protected int getIndex(BlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((Property)NORTH)).booleanValue()) {
            i |= AbstractBlockMinecoloniesConstructionTape.getMask(Direction.NORTH);
        }
        if (((Boolean)state.func_177229_b((Property)EAST)).booleanValue()) {
            i |= AbstractBlockMinecoloniesConstructionTape.getMask(Direction.EAST);
        }
        if (((Boolean)state.func_177229_b((Property)SOUTH)).booleanValue()) {
            i |= AbstractBlockMinecoloniesConstructionTape.getMask(Direction.SOUTH);
        }
        if (((Boolean)state.func_177229_b((Property)WEST)).booleanValue()) {
            i |= AbstractBlockMinecoloniesConstructionTape.getMask(Direction.WEST);
        }
        return i;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected VoxelShape[] makeShapes(float nodeWidth, float limbWidth, float nodeHeight, float limbBase, float limbTop) {
        float nodeStart = 8.0f - nodeWidth;
        float nodeEnd = 8.0f + nodeWidth;
        float limbStart = 8.0f - limbWidth;
        float limbEnd = 8.0f + limbWidth;
        VoxelShape node = Block.func_208617_a((double)nodeStart, (double)0.0, (double)nodeStart, (double)nodeEnd, (double)nodeHeight, (double)nodeEnd);
        VoxelShape north = Block.func_208617_a((double)limbStart, (double)limbBase, (double)0.0, (double)limbEnd, (double)limbTop, (double)limbEnd);
        VoxelShape south = Block.func_208617_a((double)limbStart, (double)limbBase, (double)limbStart, (double)limbEnd, (double)limbTop, (double)16.0);
        VoxelShape west = Block.func_208617_a((double)0.0, (double)limbBase, (double)limbStart, (double)limbEnd, (double)limbTop, (double)limbEnd);
        VoxelShape east = Block.func_208617_a((double)limbStart, (double)limbBase, (double)limbStart, (double)16.0, (double)limbTop, (double)limbEnd);
        VoxelShape cornernw = VoxelShapes.func_197872_a((VoxelShape)north, (VoxelShape)east);
        VoxelShape cornerse = VoxelShapes.func_197872_a((VoxelShape)south, (VoxelShape)west);
        VoxelShape[] avoxelshape = new VoxelShape[]{VoxelShapes.func_197880_a(), south, west, cornerse, north, VoxelShapes.func_197872_a((VoxelShape)south, (VoxelShape)north), VoxelShapes.func_197872_a((VoxelShape)west, (VoxelShape)north), VoxelShapes.func_197872_a((VoxelShape)cornerse, (VoxelShape)north), east, VoxelShapes.func_197872_a((VoxelShape)south, (VoxelShape)east), VoxelShapes.func_197872_a((VoxelShape)west, (VoxelShape)east), VoxelShapes.func_197872_a((VoxelShape)cornerse, (VoxelShape)east), cornernw, VoxelShapes.func_197872_a((VoxelShape)south, (VoxelShape)cornernw), VoxelShapes.func_197872_a((VoxelShape)west, (VoxelShape)cornernw), VoxelShapes.func_197872_a((VoxelShape)cornerse, (VoxelShape)cornernw)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = VoxelShapes.func_197872_a((VoxelShape)node, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }
}

