/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.globalxp.xpblock;

import bl4ckscor3.mod.globalxp.Configuration;
import bl4ckscor3.mod.globalxp.GlobalXP;
import bl4ckscor3.mod.globalxp.XPUtils;
import bl4ckscor3.mod.globalxp.xpblock.XPBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;

public class XPBlockTileEntity
extends TileEntity
implements ITickableTileEntity {
    private int storedXP = 0;
    private float storedLevels = 0.0f;
    private boolean destroyedByCreativePlayer;

    public XPBlockTileEntity() {
        super(GlobalXP.teTypeXpBlock);
    }

    public void addXP(int amount) {
        this.storedXP += amount;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
    }

    public int removeXP(int amount) {
        int amountRemoved = Math.min(amount, this.storedXP);
        if (amountRemoved <= 0) {
            return 0;
        }
        this.storedXP -= amountRemoved;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 2);
        return amountRemoved;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void setStoredXP(int xp) {
        this.storedXP = xp;
        this.storedLevels = XPUtils.calculateStoredLevels(this.storedXP);
        this.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
        }
    }

    public int getStoredXP() {
        return this.storedXP;
    }

    public float getStoredLevels() {
        return this.storedLevels;
    }

    public void setDestroyedByCreativePlayer(boolean destroyedByCreativePlayer) {
        this.destroyedByCreativePlayer = destroyedByCreativePlayer;
    }

    public boolean isDestroyedByCreativePlayer() {
        return this.destroyedByCreativePlayer;
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("stored_xp", this.storedXP);
        return super.func_189515_b(tag);
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        this.setStoredXP(tag.func_74762_e("stored_xp"));
        super.func_230337_a_(state, tag);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 5L == 0L && ((Boolean)Configuration.SERVER.pickupXP.get()).booleanValue() && !((Boolean)this.func_195044_w().func_177229_b((Property)XPBlock.POWERED)).booleanValue()) {
            this.pickupDroppedXP();
        }
    }

    private void pickupDroppedXP() {
        for (ExperienceOrbEntity entity : this.field_145850_b.func_175647_a(ExperienceOrbEntity.class, this.getPickupArea(), EntityPredicates.field_94557_a)) {
            int amount = entity.func_70526_d();
            if (!entity.func_70089_S() || this.getStoredXP() + amount > this.getCapacity()) continue;
            this.addXP(amount);
            entity.func_70106_y();
        }
    }

    private AxisAlignedBB getPickupArea() {
        double x = (double)this.func_174877_v().func_177958_n() + 0.5;
        double y = (double)this.func_174877_v().func_177956_o() + 0.5;
        double z = (double)this.func_174877_v().func_177952_p() + 0.5;
        double range = (Double)Configuration.SERVER.pickupRange.get() + 0.5;
        return new AxisAlignedBB(x - range, y - range, z - range, x + range, y + range, z + range);
    }

    public int getCapacity() {
        return Integer.MAX_VALUE;
    }
}

