/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.tileentity;

import cofh.core.tileentity.TileCoFH;
import cofh.core.util.control.ISecurableTile;
import cofh.core.util.control.SecurityControlModule;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntityType;

public class ThermalTileSecurable
extends TileCoFH
implements ISecurableTile {
    protected SecurityControlModule securityControl = new SecurityControlModule((ISecurableTile)this);

    public ThermalTileSecurable(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        CompoundNBT nbt = stack.func_190925_c("BlockEntityTag");
        if (this.hasSecurity()) {
            this.securityControl().write(nbt);
        }
        if (!nbt.isEmpty()) {
            stack.func_77983_a("BlockEntityTag", (INBT)nbt);
        }
        return super.createItemStackTag(stack);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.securityControl.read(nbt);
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        this.securityControl.write(nbt);
        return nbt;
    }

    public PacketBuffer getControlPacket(PacketBuffer buffer) {
        super.getControlPacket(buffer);
        this.securityControl.writeToBuffer(buffer);
        return buffer;
    }

    public void handleControlPacket(PacketBuffer buffer) {
        super.handleControlPacket(buffer);
        this.securityControl.readFromBuffer(buffer);
    }

    public SecurityControlModule securityControl() {
        return this.securityControl;
    }
}

