/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.client.renderer.entity;

import cofh.thermal.core.client.renderer.entity.BasalzProjectileRenderer;
import cofh.thermal.core.client.renderer.entity.model.BasalzModel;
import cofh.thermal.core.client.renderer.entity.model.ElementalProjectileModel;
import cofh.thermal.core.entity.monster.BasalzEntity;
import cofh.thermal.core.entity.projectile.BasalzProjectileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BasalzRenderer
extends MobRenderer<BasalzEntity, BasalzModel<BasalzEntity>> {
    private static final ResourceLocation CALM_TEXTURE = new ResourceLocation("thermal:textures/entity/basalz.png");
    private static final ResourceLocation ANGRY_TEXTURE = new ResourceLocation("thermal:textures/entity/basalz_angry.png");
    private final ElementalProjectileModel<BasalzProjectileEntity> projectileModel = new ElementalProjectileModel();

    public BasalzRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new BasalzModel(), 0.5f);
    }

    public void render(BasalzEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (entity.isAngry()) {
            matrixStackIn.func_227860_a_();
            float time = (float)entity.field_70173_aa + partialTicks;
            matrixStackIn.func_227861_a_(0.0, (double)entity.func_213302_cg() * 0.7, 0.0);
            int orbit = entity.getOrbit();
            float inv = 1.0f / (float)orbit;
            float rot = 360.0f * inv;
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(time * Math.max(36.0f * inv, 12.0f)));
            for (int i = 0; i < orbit; ++i) {
                matrixStackIn.func_227860_a_();
                float t = time + (float)i;
                matrixStackIn.func_227861_a_(3.0, (double)(0.5f * MathHelper.func_76126_a((float)(time * 0.15708f - (float)i * inv * 6.2832f))), 0.0);
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(MathHelper.func_76126_a((float)(t * 0.1f)) * 180.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_76134_b((float)(t * 0.1f)) * 180.0f));
                matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
                IVertexBuilder builder = bufferIn.getBuffer(this.projectileModel.func_228282_a_(BasalzProjectileRenderer.TEXTURE));
                this.projectileModel.func_225598_a_(matrixStackIn, builder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 0.8f);
                matrixStackIn.func_227865_b_();
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rot));
            }
            matrixStackIn.func_227865_b_();
        }
        super.func_225623_a_((MobEntity)entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected int getBlockLightLevel(BasalzEntity entityIn, BlockPos partialTicks) {
        return entityIn.isAngry() ? 12 : super.func_225624_a_((Entity)entityIn, partialTicks);
    }

    public ResourceLocation getTextureLocation(BasalzEntity entity) {
        return entity.isAngry() ? ANGRY_TEXTURE : CALM_TEXTURE;
    }
}

