/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.client.gui.container;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integratedterminals.IntegratedTerminals;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.capability.ingredient.IngredientComponentTerminalStorageHandlerConfig;
import org.cyclops.integratedterminals.client.gui.container.ContainerScreenTerminalStorage;
import org.cyclops.integratedterminals.client.gui.container.component.GuiCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingJobGuiData;
import org.cyclops.integratedterminals.core.terminalstorage.crafting.HandlerWrappedTerminalCraftingPlan;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalCraftingJobs;
import org.cyclops.integratedterminals.network.packet.CancelCraftingJobPacket;
import org.cyclops.integratedterminals.network.packet.OpenCraftingJobsPlanGuiPacket;

public class ContainerScreenTerminalCraftingJobs
extends ContainerScreenExtended<ContainerTerminalCraftingJobs> {
    public static int OUTPUT_SLOT_X = 8;
    public static int OUTPUT_SLOT_Y = 17;
    public static int LINE_WIDTH = 221;
    private final PlayerEntity player;
    private WidgetScrollBar scrollBar;
    private int firstRow;

    public ContainerScreenTerminalCraftingJobs(ContainerTerminalCraftingJobs container, PlayerInventory inventory, ITextComponent title) {
        super((ContainerExtended)container, inventory, title);
        this.player = inventory.field_70458_d;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.scrollBar = new WidgetScrollBar(this.field_147003_i + 236, this.field_147009_r + 18, 178, (ITextComponent)new TranslationTextComponent("gui.cyclopscore.scrollbar"), this::setFirstRow, 10);
        this.field_230705_e_.add(this.scrollBar);
        this.scrollBar.setTotalRows(((ContainerTerminalCraftingJobs)this.func_212873_a_()).getCraftingJobs().size() - 1);
        this.func_230480_a_((Widget)new ButtonText(this.field_147003_i + 70, this.field_147009_r + 198, 120, 20, (ITextComponent)new TranslationTextComponent("gui.integratedterminals.terminal_crafting_job.craftingplan.cancel_all"), (ITextComponent)new TranslationTextComponent("gui.integratedterminals.terminal_crafting_job.craftingplan.cancel_all"), b -> this.cancelCraftingJobs(), true));
    }

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integratedterminals", "textures/gui/crafting_plan.png");
    }

    public int getBaseXSize() {
        return 256;
    }

    public int getBaseYSize() {
        return 222;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.scrollBar.drawGuiContainerBackgroundLayer(matrixStack, partialTicks, mouseX, mouseY);
        RenderHelpers.bindTexture((ResourceLocation)this.texture);
        this.drawCraftingPlans(matrixStack, this.field_147003_i, this.field_147009_r, partialTicks, mouseX - this.field_147003_i, mouseY - this.field_147009_r, ContainerScreenTerminalStorage.DrawLayer.BACKGROUND);
        ContainerScreenTerminalCraftingJobs.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)L10NHelpers.localize((String)"parttype.integratedterminals.terminal_crafting_job", (Object[])new Object[0]), (int)(this.field_147003_i + 8), (int)(this.field_147009_r + 5), (int)0xFFFFFF);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        this.drawCraftingPlans(matrixStack, 0, 0, 0.0f, mouseX, mouseY, ContainerScreenTerminalStorage.DrawLayer.FOREGROUND);
    }

    protected List<HandlerWrappedTerminalCraftingPlan> getVisiblePlans() {
        return ((ContainerTerminalCraftingJobs)this.func_212873_a_()).getCraftingJobs().subList(this.firstRow, Math.min(((ContainerTerminalCraftingJobs)this.func_212873_a_()).getCraftingJobs().size(), this.firstRow + this.scrollBar.getVisibleRows()));
    }

    protected void drawCraftingPlans(MatrixStack matrixStack, int x, int y, float partialTicks, int mouseX, int mouseY, ContainerScreenTerminalStorage.DrawLayer layer) {
        int offsetY = OUTPUT_SLOT_Y;
        for (HandlerWrappedTerminalCraftingPlan craftingPlan : this.getVisiblePlans()) {
            this.drawCraftingPlan(matrixStack, craftingPlan, x + OUTPUT_SLOT_X, y + offsetY, layer, partialTicks, mouseX, mouseY);
            offsetY += GuiHelpers.SLOT_SIZE;
        }
    }

    protected void drawCraftingPlan(MatrixStack matrixStack, HandlerWrappedTerminalCraftingPlan craftingPlan, int x, int y, ContainerScreenTerminalStorage.DrawLayer layer, float partialTick, int mouseX, int mouseY) {
        int xOriginal = x;
        ITerminalCraftingPlan plan = craftingPlan.getCraftingPlan();
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND && RenderHelpers.isPointInRegion((int)(x - this.field_147003_i), (int)(y - this.field_147009_r), (int)LINE_WIDTH, (int)GuiHelpers.SLOT_SIZE, (double)mouseX, (double)mouseY)) {
            ContainerScreenTerminalCraftingJobs.func_238467_a_((MatrixStack)matrixStack, (int)(x + 1), (int)(y + 1), (int)(x + LINE_WIDTH + 1), (int)(y + GuiHelpers.SLOT_SIZE), (int)-2130706433);
        }
        x += 4;
        for (IPrototypedIngredient<?, ?> output : plan.getOutputs()) {
            IngredientComponent ingredientComponent = output.getComponent();
            long quantity = ingredientComponent.getMatcher().getQuantity(output.getPrototype());
            int finalX = x;
            ingredientComponent.getCapability(IngredientComponentTerminalStorageHandlerConfig.CAPABILITY).ifPresent(h -> h.drawInstance(matrixStack, output.getPrototype(), quantity, GuiHelpers.quantityToScaledString((long)quantity), (ContainerScreen)this, layer, partialTick, finalX, y + 1, mouseX, mouseY, null));
            x += GuiHelpers.SLOT_SIZE_INNER;
        }
        if (layer == ContainerScreenTerminalStorage.DrawLayer.BACKGROUND) {
            long tickDuration;
            String statusString = L10NHelpers.localize((String)"gui.integratedterminals.craftingplan.status", (Object[])new Object[]{L10NHelpers.localize((String)("gui.integratedterminals.craftingplan.status." + plan.getStatus().name().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0])});
            RenderHelpers.drawScaledStringWithShadow((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)statusString, (int)(xOriginal + LINE_WIDTH - 80), (int)(y + 1), (float)0.5f, (int)0xFFFFFF);
            int dependencies = ContainerScreenTerminalCraftingJobs.getDependencies(plan);
            String dependenciesString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.dependencies", (Object[])new Object[]{dependencies});
            RenderHelpers.drawScaledStringWithShadow((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)dependenciesString, (int)(xOriginal + LINE_WIDTH - 80), (int)(y + 7), (float)0.5f, (int)0xFFFFFF);
            if (plan.getChannel() != -1) {
                String channelString = L10NHelpers.localize((String)"gui.integratedterminals.terminal_crafting_job.craftingplan.crafting_channel", (Object[])new Object[]{plan.getChannel()});
                RenderHelpers.drawScaledStringWithShadow((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)channelString, (int)(xOriginal + LINE_WIDTH - 40), (int)(y + 7), (float)0.5f, (int)0xFFFFFF);
            }
            if ((tickDuration = plan.getTickDuration()) >= 0L) {
                String durationString = GuiCraftingPlan.getDurationString(tickDuration);
                RenderHelpers.drawScaledStringWithShadow((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)durationString, (int)(xOriginal + LINE_WIDTH - 80), (int)(y + 13), (float)0.5f, (int)0xFFFFFF);
            }
        }
    }

    protected static int getDependencies(ITerminalCraftingPlan<?> plan) {
        int count = 1;
        for (ITerminalCraftingPlan<?> dependency : plan.getDependencies()) {
            count += ContainerScreenTerminalCraftingJobs.getDependencies(dependency);
        }
        return count;
    }

    private void cancelCraftingJobs() {
        for (HandlerWrappedTerminalCraftingPlan craftingJob : ((ContainerTerminalCraftingJobs)this.func_212873_a_()).getCraftingJobs()) {
            PartPos center = ((PartTarget)((ContainerTerminalCraftingJobs)this.func_212873_a_()).getTarget().get()).getCenter();
            CraftingJobGuiData data = new CraftingJobGuiData(center.getPos().getBlockPos(), center.getSide(), ((ContainerTerminalCraftingJobs)this.func_212873_a_()).getChannel(), craftingJob.getHandler(), craftingJob.getCraftingPlan().getId());
            IntegratedTerminals._instance.getPacketHandler().sendToServer((PacketBase)new CancelCraftingJobPacket(data));
        }
        this.player.func_71053_j();
    }

    @Nullable
    protected HandlerWrappedTerminalCraftingPlan getHoveredPlan(double mouseX, double mouseY) {
        mouseX -= (double)this.field_147003_i;
        mouseY -= (double)this.field_147009_r;
        if (mouseX > (double)OUTPUT_SLOT_X && mouseX < (double)(OUTPUT_SLOT_X + LINE_WIDTH) && mouseY > (double)OUTPUT_SLOT_Y && mouseY < (double)(OUTPUT_SLOT_Y + GuiHelpers.SLOT_SIZE * this.scrollBar.getVisibleRows())) {
            int index = ((int)mouseY - OUTPUT_SLOT_Y) / GuiHelpers.SLOT_SIZE;
            List<HandlerWrappedTerminalCraftingPlan> plans = this.getVisiblePlans();
            if (index >= 0 && index < plans.size()) {
                return plans.get(index);
            }
        }
        return null;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        HandlerWrappedTerminalCraftingPlan plan = this.getHoveredPlan(mouseX, mouseY);
        if (plan != null) {
            PartPos pos = ((PartTarget)((ContainerTerminalCraftingJobs)this.func_212873_a_()).getTarget().get()).getCenter();
            OpenCraftingJobsPlanGuiPacket.send(pos.getPos().getBlockPos(), pos.getSide(), ((ContainerTerminalCraftingJobs)this.func_212873_a_()).getChannel(), plan);
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int mouseButton, double mouseXPrev, double mouseYPrev) {
        return this.func_241217_q_() != null && this.func_231041_ay__() && mouseButton == 0 && this.func_241217_q_().func_231045_a_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev) ? true : super.func_231045_a_(mouseX, mouseY, mouseButton, mouseXPrev, mouseYPrev);
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    public void onUpdate(int valueId, CompoundNBT value) {
        super.onUpdate(valueId, value);
        if (valueId == ((ContainerTerminalCraftingJobs)this.func_212873_a_()).getValueIdCraftingJobs()) {
            this.func_231160_c_();
        }
    }
}

