/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.addons.hwyla;

import java.text.DecimalFormat;
import java.util.List;
import java.util.stream.Collectors;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import net.darkhax.botanypots.addons.hwyla.BotanyPotsHwylaPlugin;
import net.darkhax.botanypots.block.tileentity.TileEntityBotanyPot;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class BotanyPotComponentProvider
implements IComponentProvider {
    private static final DecimalFormat format = new DecimalFormat("#");

    public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
        TileEntity tile = accessor.getTileEntity();
        if (tile instanceof TileEntityBotanyPot) {
            TileEntityBotanyPot pot = (TileEntityBotanyPot)tile;
            if (config.get(BotanyPotsHwylaPlugin.KEY_SHOW_SOIL) && pot.getSoil() != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("botanypots.tooltip.soil", new Object[]{pot.getSoil().getRenderState().getState().func_177230_c().func_235333_g_()}));
            }
            if (config.get(BotanyPotsHwylaPlugin.KEY_SHOW_CROP) && pot.getCrop() != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("botanypots.tooltip.crop", new Object[]{pot.getCrop().getDisplayState()[0].getState().func_177230_c().func_235333_g_()}));
            }
            if (config.get(BotanyPotsHwylaPlugin.KEY_SHOW_PROGRESS) && pot.getCrop() != null && pot.getSoil() != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("botanypots.tooltip.growth_progress", new Object[]{format.format(pot.getGrowthPercent() * 100.0f)}));
            }
            if (config.get(BotanyPotsHwylaPlugin.KEY_SHOW_TIME) && pot.getCurrentGrowthTicks() > 0) {
                int ticksRemaining = pot.getTotalGrowthTicks() - pot.getCurrentGrowthTicks();
                tooltip.add((ITextComponent)new TranslationTextComponent("botanypots.tooltip.growth_time", new Object[]{BotanyPotComponentProvider.ticksToElapsedTime(ticksRemaining)}));
            }
            if (config.get(BotanyPotsHwylaPlugin.KEY_SHOW_DEBUG)) {
                if (pot.getCrop() != null) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("botanypots.tooltip.crop.id", new Object[]{pot.getCrop().func_199560_c().toString()}).func_240699_a_(TextFormatting.LIGHT_PURPLE));
                    tooltip.add((ITextComponent)new TranslationTextComponent("botanypots.tooltip.crop.ticks", new Object[]{pot.getCrop().getGrowthTicks()}).func_240699_a_(TextFormatting.LIGHT_PURPLE));
                    tooltip.add((ITextComponent)new TranslationTextComponent("botanypots.tooltip.crop.categories", new Object[]{pot.getCrop().getSoilCategories().stream().collect(Collectors.joining(", "))}).func_240699_a_(TextFormatting.LIGHT_PURPLE));
                }
                if (pot.getSoil() != null) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("botanypots.tooltip.soil.id", new Object[]{pot.getSoil().func_199560_c().toString()}).func_240699_a_(TextFormatting.AQUA));
                    tooltip.add((ITextComponent)new TranslationTextComponent("botanypots.tooltip.soil.modifier", new Object[]{Float.valueOf(pot.getSoil().getGrowthModifier())}).func_240699_a_(TextFormatting.AQUA));
                    tooltip.add((ITextComponent)new TranslationTextComponent("botanypots.tooltip.soil.categories", new Object[]{pot.getSoil().getCategories().stream().collect(Collectors.joining(", "))}).func_240699_a_(TextFormatting.AQUA));
                }
                tooltip.add((ITextComponent)new TranslationTextComponent("botanypots.tooltip.pot.totalticks", new Object[]{pot.getTotalGrowthTicks()}).func_240699_a_(TextFormatting.GREEN));
                tooltip.add((ITextComponent)new TranslationTextComponent("botanypots.tooltip.pot.growticks", new Object[]{pot.getCurrentGrowthTicks()}).func_240699_a_(TextFormatting.GREEN));
            }
        }
    }

    private static String ticksToElapsedTime(int ticks) {
        int i = ticks / 20;
        int j = i / 60;
        return (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
    }
}

