/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TeleportDestination {
    private final BlockPos coordinate;
    private final RegistryKey<World> dimension;
    private String name = "";
    private boolean privateAccess = false;
    private Set<String> allowedPlayers = null;

    public TeleportDestination(PacketBuffer buf) {
        int cx = buf.readInt();
        int cy = buf.readInt();
        int cz = buf.readInt();
        this.coordinate = cx == -1 && cy == -1 && cz == -1 ? null : new BlockPos(cx, cy, cz);
        this.dimension = LevelTools.getId((ResourceLocation)buf.func_192575_l());
        this.setName(buf.func_150789_c(Short.MAX_VALUE));
        this.privateAccess = buf.readBoolean();
        int len = buf.readInt();
        if (len == -1) {
            this.allowedPlayers = null;
        } else {
            this.allowedPlayers = new HashSet<String>(len);
            for (int i = 0; i < len; ++i) {
                this.allowedPlayers.add(buf.func_150789_c(Short.MAX_VALUE));
            }
        }
    }

    public TeleportDestination(CompoundNBT tc) {
        this.coordinate = new BlockPos(tc.func_74762_e("x"), tc.func_74762_e("y"), tc.func_74762_e("z"));
        this.dimension = LevelTools.getId((String)tc.func_74779_i("dim"));
        this.name = tc.func_74779_i("name");
        this.privateAccess = tc.func_74767_n("privateAccess");
        if (tc.func_74764_b("allowedPlayers")) {
            ListNBT players = tc.func_150295_c("allowedPlayers", 8);
            this.allowedPlayers = new HashSet<String>(players.size());
            players.forEach(player -> this.allowedPlayers.add(player.func_150285_a_()));
        } else {
            this.allowedPlayers = null;
        }
    }

    public TeleportDestination(BlockPos coordinate, RegistryKey<World> dimension) {
        this.coordinate = coordinate;
        this.dimension = dimension;
    }

    public boolean isValid() {
        return this.coordinate != null;
    }

    public CompoundNBT writeToTag() {
        CompoundNBT tc = new CompoundNBT();
        BlockPos c = this.getCoordinate();
        tc.func_74768_a("x", c.func_177958_n());
        tc.func_74768_a("y", c.func_177956_o());
        tc.func_74768_a("z", c.func_177952_p());
        tc.func_74778_a("dim", this.getDimension().func_240901_a_().toString());
        tc.func_74778_a("name", this.getName());
        tc.func_74757_a("privateAccess", this.privateAccess);
        if (this.allowedPlayers != null) {
            ListNBT list = new ListNBT();
            this.allowedPlayers.forEach(p -> list.add((Object)StringNBT.func_229705_a_((String)p)));
            tc.func_218657_a("allowedPlayers", (INBT)list);
        }
        return tc;
    }

    public void toBytes(PacketBuffer buf) {
        if (this.coordinate == null) {
            buf.writeInt(-1);
            buf.writeInt(-1);
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.coordinate.func_177958_n());
            buf.writeInt(this.coordinate.func_177956_o());
            buf.writeInt(this.coordinate.func_177952_p());
        }
        buf.func_192572_a(this.dimension.func_240901_a_());
        buf.func_180714_a(this.getName());
        buf.writeBoolean(this.privateAccess);
        if (this.allowedPlayers == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.allowedPlayers.size());
            this.allowedPlayers.forEach(arg_0 -> ((PacketBuffer)buf).func_180714_a(arg_0));
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name == null ? "" : name;
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    public boolean isPrivateAccess() {
        return this.privateAccess;
    }

    @Nullable
    public Set<String> getAllowedPlayers() {
        return this.allowedPlayers;
    }

    public void setPrivateAccess(boolean privateAccess) {
        this.privateAccess = privateAccess;
    }

    public boolean isAccessKnown() {
        return this.allowedPlayers != null;
    }

    public boolean checkAccess(World level, UUID player) {
        if (!this.privateAccess) {
            return true;
        }
        ServerPlayerEntity playerByUuid = level.func_73046_m().func_184103_al().func_177451_a(player);
        if (playerByUuid == null) {
            return true;
        }
        return this.allowedPlayers.contains(playerByUuid.func_145748_c_().getString());
    }

    public void setAllowedPlayers(@Nullable Set<String> allowedPlayers) {
        this.allowedPlayers = allowedPlayers == null ? null : new HashSet<String>(allowedPlayers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TeleportDestination that = (TeleportDestination)o;
        return Objects.equals(this.coordinate, that.coordinate) && Objects.equals(this.dimension, that.dimension) && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.coordinate, this.dimension, this.name);
    }
}

