/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modules;

import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.EnergyTools;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.data.IModuleDataContents;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.modules.ScreenModuleHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EnergyBarScreenModule
implements IScreenModule<IModuleDataContents> {
    protected RegistryKey<World> dim = World.field_234918_g_;
    protected BlockPos coordinate = BlockPosTools.INVALID;
    protected Direction side = Direction.DOWN;
    protected ScreenModuleHelper helper = new ScreenModuleHelper();

    public IModuleDataContents getData(IScreenDataHelper h, World worldObj, long millis) {
        ServerWorld world = LevelTools.getLevel((World)worldObj, this.dim);
        if (world == null) {
            return null;
        }
        if (!LevelTools.isLoaded((World)world, (BlockPos)this.coordinate)) {
            return null;
        }
        TileEntity te = world.func_175625_s(this.coordinate);
        if (!EnergyTools.isEnergyTE((TileEntity)te, (Direction)this.side)) {
            return null;
        }
        EnergyTools.EnergyLevel energyLevel = EnergyTools.getEnergyLevelMulti((TileEntity)te, (Direction)this.side);
        long energy = energyLevel.getEnergy();
        long maxEnergy = energyLevel.getMaxEnergy();
        return this.helper.getContentsValue(millis, energy, maxEnergy);
    }

    public void setupFromNBT(CompoundNBT tagCompound, RegistryKey<World> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.helper.setShowdiff(tagCompound.func_74767_n("showdiff"));
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.func_74764_b("monitorx")) {
                this.dim = LevelTools.getId((String)tagCompound.func_74779_i("monitordim"));
                if (Objects.equals(dim, this.dim)) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                        if (tagCompound.func_74764_b("monitorside")) {
                            this.side = OrientationTools.DIRECTION_VALUES[tagCompound.func_74762_e("monitorside")];
                        }
                    }
                }
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)ScreenConfiguration.ENERGY_RFPERTICK.get();
    }

    public void mouseClick(World world, int x, int y, boolean clicked, PlayerEntity player) {
    }
}

