/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.logic.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.blocks.LogicSlabBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.LogicSupport;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolsutility.compat.RFToolsUtilityTOPDriver;
import mcjty.rftoolsutility.modules.logic.LogicBlockModule;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;

public class TimerTileEntity
extends TickingTileEntity
implements TickOrderHandler.IOrderTicker {
    private final LogicSupport support = new LogicSupport();
    private boolean prevIn = false;
    private int timer = 0;
    @GuiValue
    private int delay = 20;
    @GuiValue(name="pauses")
    private boolean redstonePauses = false;
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Timer").containerSupplier(DefaultContainerProvider.empty(LogicBlockModule.CONTAINER_TIMER, (GenericTileEntity)this)).setupSync((GenericTileEntity)this));

    public static LogicSlabBlock createBlock() {
        return new LogicSlabBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsUtilityTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolsutility:logic/timer")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(TimerTileEntity::new));
    }

    public TimerTileEntity() {
        super((TileEntityType)LogicBlockModule.TYPE_TIMER.get());
    }

    public int getTimer() {
        return this.timer;
    }

    protected void tickServer() {
        TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_3;
    }

    public void tickOnServer() {
        int newout;
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        this.prevIn = this.powerLevel > 0;
        this.func_70296_d();
        if (pulse) {
            this.timer = this.delay;
        }
        if (!this.redstonePauses || !this.prevIn) {
            --this.timer;
        }
        if (this.timer <= 0) {
            this.timer = this.delay;
            newout = 15;
        } else {
            newout = 0;
        }
        this.support.setRedstoneState((GenericTileEntity)this, newout);
    }

    public void checkRedstone(World world, BlockPos pos) {
        this.support.checkRedstone((GenericTileEntity)this, world, pos);
    }

    public int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.support.getRedstoneOutput(state, side);
    }

    public void load(CompoundNBT tagCompound) {
        super.load(tagCompound);
        this.support.setPowerOutput(tagCompound.func_74767_n("rs") ? 15 : 0);
        this.prevIn = tagCompound.func_74767_n("prevIn");
        this.timer = tagCompound.func_74762_e("timer");
    }

    public void loadInfo(CompoundNBT tagCompound) {
        super.loadInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.delay = info.func_74762_e("delay");
        this.redstonePauses = info.func_74767_n("redstonePauses");
    }

    public void saveAdditional(@Nonnull CompoundNBT tagCompound) {
        super.saveAdditional(tagCompound);
        tagCompound.func_74757_a("rs", this.support.getPowerOutput() > 0);
        tagCompound.func_74757_a("prevIn", this.prevIn);
        tagCompound.func_74768_a("timer", this.timer);
    }

    public void saveInfo(CompoundNBT tagCompound) {
        super.saveInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("delay", this.delay);
        info.func_74757_a("redstonePauses", this.redstonePauses);
    }
}

