/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.ScrollableLabel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.network.PacketGetListFromServer;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsutility.modules.environmental.EnvironmentalModule;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.ResourceLocation;

public class GuiEnvironmentalController
extends GenericGuiContainer<EnvironmentalControllerTileEntity, GenericContainer> {
    public static final String BLACKLIST = "BL";
    public static final String WHITELIST = "WL";
    public static final String HOSTILE = "Host";
    public static final String PASSIVE = "Pass";
    public static final String MOBS = "Mobs";
    public static final String ALL = "All";
    private List<String> players = null;
    private int listDirty = 0;
    private EnergyBar energyBar;
    private TextField minyTextField;
    private TextField maxyTextField;
    private TextField nameField;
    private WidgetList playersList;
    private ChoiceLabel modeLabel;

    public GuiEnvironmentalController(EnvironmentalControllerTileEntity te, GenericContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)te, (Container)container, inventory, ManualHelper.create((String)"rftoolsutility:machines/environmental"));
    }

    public static void register() {
        GuiEnvironmentalController.register((ContainerType)((ContainerType)EnvironmentalModule.CONTAINER_ENVIRONENTAL_CONTROLLER.get()), GuiEnvironmentalController::new);
    }

    public void func_231160_c_() {
        this.window = new Window((Screen)this, this.tileEntity, RFToolsUtilityMessages.INSTANCE, new ResourceLocation("rftoolsutility", "gui/environmental.gui"));
        super.func_231160_c_();
        this.initializeFields();
        this.setupEvents();
        this.listDirty = 0;
        this.requestPlayers();
    }

    private void initializeFields() {
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.playersList = (WidgetList)this.window.findChild("players");
        this.minyTextField = (TextField)this.window.findChild("miny");
        this.maxyTextField = (TextField)this.window.findChild("maxy");
        this.nameField = (TextField)this.window.findChild("name");
        this.modeLabel = (ChoiceLabel)this.window.findChild("mode");
    }

    private void updateFields() {
        if (this.window == null) {
            return;
        }
        ((ImageChoiceLabel)this.window.findChild("redstone")).setCurrentChoice(((EnvironmentalControllerTileEntity)this.tileEntity).getRSMode().ordinal());
        int r = ((EnvironmentalControllerTileEntity)this.tileEntity).getRadius();
        if (r < 5) {
            r = 5;
        } else if (r > 100) {
            r = 100;
        }
        ((ScrollableLabel)this.window.findChild("radius")).realValue(r);
        this.minyTextField.text(Integer.toString(((EnvironmentalControllerTileEntity)this.tileEntity).getMiny()));
        this.maxyTextField.text(Integer.toString(((EnvironmentalControllerTileEntity)this.tileEntity).getMaxy()));
        switch (((EnvironmentalControllerTileEntity)this.tileEntity).getMode()) {
            case MODE_BLACKLIST: {
                this.modeLabel.choice(BLACKLIST);
                break;
            }
            case MODE_WHITELIST: {
                this.modeLabel.choice(WHITELIST);
                break;
            }
            case MODE_HOSTILE: {
                this.modeLabel.choice(HOSTILE);
                break;
            }
            case MODE_PASSIVE: {
                this.modeLabel.choice(PASSIVE);
                break;
            }
            case MODE_MOBS: {
                this.modeLabel.choice(MOBS);
                break;
            }
            case MODE_ALL: {
                this.modeLabel.choice(ALL);
            }
        }
        this.updateEnergyBar(this.energyBar);
    }

    private void setupEvents() {
        this.window.event("add", (source, params) -> this.addPlayer());
        this.window.event("del", (source, params) -> this.delPlayer());
        this.window.event("mode", (source, params) -> this.changeMode((String)params.get(ChoiceLabel.PARAM_CHOICE)));
        this.window.event("miny", (source, params) -> this.sendBounds(true));
        this.window.event("maxy", (source, params) -> this.sendBounds(false));
    }

    private void changeMode(String newAccess) {
        EnvironmentalControllerTileEntity.EnvironmentalMode newmode = ALL.equals(newAccess) ? EnvironmentalControllerTileEntity.EnvironmentalMode.MODE_ALL : (BLACKLIST.equals(newAccess) ? EnvironmentalControllerTileEntity.EnvironmentalMode.MODE_BLACKLIST : (WHITELIST.equals(newAccess) ? EnvironmentalControllerTileEntity.EnvironmentalMode.MODE_WHITELIST : (MOBS.equals(newAccess) ? EnvironmentalControllerTileEntity.EnvironmentalMode.MODE_MOBS : (PASSIVE.equals(newAccess) ? EnvironmentalControllerTileEntity.EnvironmentalMode.MODE_PASSIVE : EnvironmentalControllerTileEntity.EnvironmentalMode.MODE_HOSTILE))));
        this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, EnvironmentalControllerTileEntity.CMD_SETMODE, TypedMap.builder().put(EnvironmentalControllerTileEntity.PARAM_MODE, (Object)newmode.ordinal()).build());
    }

    private void addPlayer() {
        this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, EnvironmentalControllerTileEntity.CMD_ADDPLAYER, TypedMap.builder().put(EnvironmentalControllerTileEntity.PARAM_NAME, (Object)this.nameField.getText()).build());
        this.listDirty = 0;
    }

    private void delPlayer() {
        this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, EnvironmentalControllerTileEntity.CMD_DELPLAYER, TypedMap.builder().put(EnvironmentalControllerTileEntity.PARAM_NAME, (Object)this.players.get(this.playersList.getSelected())).build());
        this.listDirty = 0;
    }

    private void requestPlayers() {
        RFToolsUtilityMessages.INSTANCE.sendToServer((Object)new PacketGetListFromServer(((EnvironmentalControllerTileEntity)this.tileEntity).func_174877_v(), EnvironmentalControllerTileEntity.CMD_GETPLAYERS.getName()));
    }

    private void populatePlayers() {
        this.players = new ArrayList<String>(((EnvironmentalControllerTileEntity)this.tileEntity).players);
        this.players.sort(null);
        this.playersList.removeChildren();
        for (String player : this.players) {
            this.playersList.children(new Widget[]{((Label)((Label)new Label().text(player)).color(StyleConfig.colorTextInListNormal)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)});
        }
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestPlayers();
            this.listDirty = 20;
        }
    }

    private void sendBounds(boolean minchanged) {
        int miny = -1;
        int maxy = -1;
        try {
            miny = Integer.parseInt(this.minyTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            maxy = Integer.parseInt(this.maxyTextField.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.sendServerCommandTyped(RFToolsUtilityMessages.INSTANCE, EnvironmentalControllerTileEntity.CMD_SETBOUNDS, TypedMap.builder().put(EnvironmentalControllerTileEntity.PARAM_MIN, (Object)miny).put(EnvironmentalControllerTileEntity.PARAM_MAX, (Object)maxy).build());
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        this.updateFields();
        this.requestListsIfNeeded();
        this.populatePlayers();
        this.enableButtons();
        this.drawWindow(matrixStack);
    }

    private void enableButtons() {
        this.window.setFlag("selected", this.playersList.getSelected() != -1);
        String name = this.nameField.getText();
        this.window.setFlag("name", name != null && !name.isEmpty());
    }
}

