/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.crafter.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.ImageChoiceLabel;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsutility.modules.crafter.CrafterModule;
import mcjty.rftoolsutility.modules.crafter.blocks.CrafterBaseTE;
import mcjty.rftoolsutility.modules.crafter.blocks.CrafterContainer;
import mcjty.rftoolsutility.modules.crafter.data.CraftingRecipe;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class GuiCrafter
extends GenericGuiContainer<CrafterBaseTE, CrafterContainer> {
    private EnergyBar energyBar;
    private WidgetList recipeList;
    private Button applyButton;
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftoolsbase", "textures/gui/guielements.png");

    public GuiCrafter(CrafterBaseTE te, CrafterContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)te, (Container)container, inventory, ((BaseBlock)CrafterModule.CRAFTER1.get()).getManualEntry());
    }

    public static void register() {
        GuiCrafter.register((ContainerType)((ContainerType)CrafterModule.CONTAINER_CRAFTER.get()), GuiCrafter::new);
    }

    public void func_231160_c_() {
        this.window = new Window((Screen)this, this.tileEntity, RFToolsUtilityMessages.INSTANCE, new ResourceLocation("rftoolsutility", "gui/crafter.gui"));
        super.func_231160_c_();
        this.initializeFields();
        this.window.event("select", (source, params) -> this.selectRecipe());
    }

    private void initializeFields() {
        this.recipeList = (WidgetList)this.window.findChild("recipes");
        this.energyBar = (EnergyBar)this.window.findChild("energybar");
        this.applyButton = (Button)this.window.findChild("apply");
    }

    private void updateFields() {
        if (this.window == null) {
            return;
        }
        this.recipeList.selected(((CrafterBaseTE)this.tileEntity).getSelected());
        ((ImageChoiceLabel)this.window.findChild("redstone")).setCurrentChoice(((CrafterBaseTE)this.tileEntity).getRSMode().ordinal());
        this.populateList();
        this.updateEnergyBar(this.energyBar);
    }

    private void populateList() {
        this.recipeList.removeChildren();
        for (int i = 0; i < ((CrafterBaseTE)this.tileEntity).getSupportedRecipes(); ++i) {
            CraftingRecipe recipe = ((CrafterBaseTE)this.tileEntity).getRecipe(i);
            this.addRecipeLine(recipe.getResult());
        }
    }

    private void addRecipeLine(ItemStack craftingResult) {
        String readableName = Tools.getReadableName((ItemStack)craftingResult);
        int color = StyleConfig.colorTextInListNormal;
        if (craftingResult.func_190926_b()) {
            readableName = "<no recipe>";
            color = -11513776;
        }
        Panel panel = (Panel)Widgets.horizontal().children(new Widget[]{new BlockRender().renderItem((Object)craftingResult).tooltips(new String[]{"Double click to edit this recipe"}), ((Label)((Label)((Label)Widgets.label((String)readableName).color(color)).horizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).dynamic(true)).tooltips(new String[]{"Double click to edit this recipe"})});
        this.recipeList.children(new Widget[]{panel});
    }

    private void selectRecipe() {
        int selected = this.recipeList.getSelected();
        this.setValue(RFToolsUtilityMessages.INSTANCE, CrafterBaseTE.SELECTED, selected);
    }

    private void updateButtons() {
        if (this.recipeList != null) {
            boolean selected = this.recipeList.getSelected() != -1;
            this.applyButton.enabled(selected);
        } else {
            this.applyButton.enabled(false);
        }
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float v, int x, int y) {
        if (this.window == null) {
            return;
        }
        this.updateFields();
        this.updateButtons();
        this.drawWindow(matrixStack);
        this.drawGhostSlots(matrixStack);
    }

    private void drawGhostSlots(MatrixStack matrixStack) {
        net.minecraft.client.renderer.RenderHelper.func_227784_d_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)this.field_147003_i, (double)this.field_147009_r, 0.0);
        RenderSystem.color4f((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        ItemStackList ghostSlots = ((CrafterBaseTE)this.tileEntity).getGhostSlots();
        this.field_230707_j_.field_77023_b = 100.0f;
        GlStateManager.func_227734_k_();
        GlStateManager.func_227737_l_();
        RenderSystem.enableLighting();
        for (int i = 0; i < ghostSlots.size(); ++i) {
            int slotIdx;
            Slot slot;
            ItemStack stack = (ItemStack)ghostSlots.get(i);
            if (stack.func_190926_b() || (slot = ((CrafterContainer)this.field_147002_h).func_75139_a(slotIdx = i < 26 ? i + 10 : i + 36 - 26)).func_75216_d()) continue;
            this.field_230707_j_.func_180450_b(stack, this.field_147003_i + slot.field_75223_e, this.field_147009_r + slot.field_75221_f);
            RenderSystem.disableLighting();
            GlStateManager.func_227740_m_();
            GlStateManager.func_227731_j_();
            this.field_230706_i_.func_110434_K().func_110577_a(iconGuiElements);
            RenderHelper.drawTexturedModalRect((Matrix4f)matrixStack.func_227866_c_().func_227870_a_(), (int)slot.field_75223_e, (int)slot.field_75221_f, (int)224, (int)48, (int)16, (int)16);
            GlStateManager.func_227734_k_();
            GlStateManager.func_227737_l_();
            RenderSystem.enableLighting();
        }
        this.field_230707_j_.field_77023_b = 0.0f;
        matrixStack.func_227865_b_();
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
    }
}

