/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.world.marker;

import hellfirepvp.astralsorcery.common.constellation.ConstellationRegistry;
import hellfirepvp.astralsorcery.common.constellation.IMajorConstellation;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.CrystalPropertiesAS;
import hellfirepvp.astralsorcery.common.lib.LootAS;
import hellfirepvp.astralsorcery.common.tile.TileCollectorCrystal;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.StructurePiece;

public class MarkerManagerAS {
    public static void handleMarker(String marker, BlockPos pos, IWorld genWorld, Random rand, MutableBoundingBox box) {
        switch (marker) {
            case "brick_shrine_chest": {
                if (rand.nextBoolean()) {
                    MarkerManagerAS.makeChest(genWorld, pos, LootAS.SHRINE_CHEST, rand, box);
                    break;
                }
                genWorld.func_180501_a(pos, BlocksAS.MARBLE_BRICKS.func_176223_P(), 2);
                break;
            }
            case "shrine_chest": {
                if (rand.nextBoolean()) {
                    MarkerManagerAS.makeChest(genWorld, pos, LootAS.SHRINE_CHEST, rand, box);
                    break;
                }
                genWorld.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                break;
            }
            case "random_top_block": {
                if (rand.nextFloat() < 0.7f) {
                    genWorld.func_180501_a(pos, genWorld.func_226691_t_(pos).func_242440_e().func_242502_e().func_204108_a(), 2);
                    break;
                }
                genWorld.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
                break;
            }
            case "crystal": {
                MarkerManagerAS.makeCollectorCrystal(genWorld, pos, rand, box);
            }
        }
    }

    private static void makeCollectorCrystal(IWorld world, BlockPos pos, Random rand, MutableBoundingBox box) {
        if (box.func_175898_b((Vector3i)pos) && world.func_180495_p(pos).func_177230_c() != BlocksAS.ROCK_COLLECTOR_CRYSTAL) {
            world.func_180501_a(pos, BlocksAS.ROCK_COLLECTOR_CRYSTAL.func_176223_P(), 2);
            TileCollectorCrystal tcc = MiscUtils.getTileAt((IBlockReader)world, pos, TileCollectorCrystal.class, true);
            if (tcc != null) {
                IMajorConstellation cst = MiscUtils.getRandomEntry(ConstellationRegistry.getMajorConstellations(), rand);
                tcc.setAttributes(CrystalPropertiesAS.WORLDGEN_SHRINE_COLLECTOR_ATTRIBUTES);
                tcc.setAttunedConstellation(cst);
            }
        }
    }

    private static void makeChest(IWorld world, BlockPos pos, ResourceLocation tableName, Random rand, MutableBoundingBox box) {
        if (box.func_175898_b((Vector3i)pos) && world.func_180495_p(pos).func_177230_c() != Blocks.field_150486_ae) {
            BlockState chest = StructurePiece.func_197528_a((IBlockReader)world, (BlockPos)pos, (BlockState)Blocks.field_150486_ae.func_176223_P());
            world.func_180501_a(pos, chest, 2);
            LockableLootTileEntity.func_195479_a((IBlockReader)world, (Random)rand, (BlockPos)pos, (ResourceLocation)tableName);
        }
    }
}

