/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.collision;

import hellfirepvp.astralsorcery.common.constellation.mantle.effect.MantleEffectAevitas;
import hellfirepvp.astralsorcery.common.util.collision.CustomCollisionHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShapeSpliterator;

public class CollisionManager {
    private static final List<CustomCollisionHandler> customHandlers = new ArrayList<CustomCollisionHandler>();
    private static final int maxCacheSize = 20;
    private static final LinkedList<VoxelShapeSpliterator> accessList = new LinkedList();
    private static final Map<VoxelShapeSpliterator, List<AxisAlignedBB>> instanceFlags = new HashMap<VoxelShapeSpliterator, List<AxisAlignedBB>>();

    public static void init() {
        CollisionManager.register(new MantleEffectAevitas.PlayerWalkableAir());
    }

    public static void register(CustomCollisionHandler handler) {
        customHandlers.add(handler);
    }

    @Nullable
    public static AxisAlignedBB getIteratorBoundingBoxes(VoxelShapeSpliterator iterator, @Nullable Entity entity) {
        List<AxisAlignedBB> boxes;
        if (!instanceFlags.containsKey(iterator)) {
            List<AxisAlignedBB> additionalBoundingBoxes = CollisionManager.getAdditionalBoundingBoxes(entity);
            if (additionalBoundingBoxes.isEmpty()) {
                return null;
            }
            CollisionManager.removeOldestEntry();
            instanceFlags.put(iterator, additionalBoundingBoxes);
            accessList.addFirst(iterator);
        }
        if ((boxes = instanceFlags.get(iterator)) == null || boxes.isEmpty()) {
            return null;
        }
        CollisionManager.markActive(iterator);
        return boxes.remove(0);
    }

    public static boolean needsCustomCollision(@Nullable Entity entity) {
        for (CustomCollisionHandler handler : customHandlers) {
            if (!handler.shouldAddCollisionFor(entity)) continue;
            return true;
        }
        return false;
    }

    public static List<AxisAlignedBB> getAdditionalBoundingBoxes(@Nullable Entity entity) {
        ArrayList<AxisAlignedBB> additionalCollision = new ArrayList<AxisAlignedBB>();
        AxisAlignedBB entityBox = entity != null ? entity.func_174813_aQ() : new AxisAlignedBB(BlockPos.field_177992_a);
        customHandlers.stream().filter(handler -> handler.shouldAddCollisionFor(entity)).forEach(handler -> handler.addCollision(entity, entityBox, additionalCollision));
        return additionalCollision;
    }

    private static void removeOldestEntry() {
        if (accessList.size() >= 20) {
            VoxelShapeSpliterator oldest;
            try {
                oldest = accessList.removeLast();
            }
            catch (NoSuchElementException exc) {
                if (accessList.isEmpty()) {
                    return;
                }
                try {
                    oldest = accessList.get(accessList.size() - 1);
                }
                catch (Exception e) {
                    return;
                }
            }
            if (oldest != null) {
                instanceFlags.remove(oldest);
            }
        }
    }

    private static void markActive(VoxelShapeSpliterator it) {
        if (accessList.remove(it)) {
            accessList.addFirst(it);
        }
    }
}

