/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util.block;

import hellfirepvp.astralsorcery.common.util.block.BlockUtils;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;

public class BlockMatchInformation
implements Predicate<BlockState> {
    private final BlockState matchState;
    private final ItemStack display;
    private final boolean matchExact;

    public BlockMatchInformation(BlockState matchState, boolean matchExact) {
        this.matchState = matchState;
        this.display = new ItemStack((IItemProvider)matchState.func_177230_c());
        this.matchExact = matchExact;
        if (this.display.func_190926_b()) {
            throw new IllegalArgumentException("No display ItemStack passed, and " + matchState.func_177230_c().getRegistryName() + " has no associated ItemBlock!");
        }
    }

    public BlockMatchInformation(BlockState matchState, ItemStack display, boolean matchExact) {
        this.matchState = matchState;
        this.display = display;
        this.matchExact = matchExact;
    }

    public BlockState getMatchState() {
        return this.matchState;
    }

    public boolean doesMatchExact() {
        return this.matchExact;
    }

    @Nonnull
    public ItemStack getDisplayStack() {
        return this.display.func_77946_l();
    }

    @Override
    public boolean test(BlockState state) {
        return this.matchExact ? BlockUtils.matchStateExact(state, this.matchState) : state.func_177230_c().equals(this.matchState.func_177230_c());
    }
}

