/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.util;

import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;

public class DamageSourceUtil {
    public static DamageSource newType(@Nonnull String damageType) {
        return new DamageSource(damageType);
    }

    public static DamageSource withEntityDirect(@Nonnull String damageType, @Nullable Entity source) {
        return new EntityDamageSource(damageType, source);
    }

    public static DamageSource withEntityIndirect(@Nonnull String damageType, @Nullable Entity actualSource, @Nullable Entity indirectSource) {
        return new IndirectEntityDamageSource(damageType, indirectSource, actualSource);
    }

    @Nullable
    public static DamageSource withEntityDirect(@Nonnull DamageSource damageType, @Nullable Entity source) {
        return DamageSourceUtil.override(damageType, source, null);
    }

    @Nullable
    public static DamageSource withEntityIndirect(@Nonnull DamageSource damageType, @Nullable Entity actualSource, @Nullable Entity indirectSource) {
        return DamageSourceUtil.override(damageType, indirectSource, actualSource);
    }

    @Nullable
    public static DamageSource setToFireDamage(@Nonnull DamageSource src) {
        return DamageSourceUtil.changeAttribute(src, DamageSource::func_76361_j);
    }

    @Nullable
    public static DamageSource setToBypassArmor(@Nonnull DamageSource src) {
        return DamageSourceUtil.changeAttribute(src, DamageSource::func_76348_h);
    }

    @Nullable
    public static DamageSource changeAttribute(@Nonnull DamageSource src, Consumer<DamageSource> update) {
        return DamageSourceUtil.overrideWithChanges(src, update);
    }

    private static boolean mayChangeAttributes(DamageSource src) {
        Class<?> srcClass = src.getClass();
        return srcClass.equals(DamageSource.class) || srcClass.equals(EntityDamageSource.class) || srcClass.equals(IndirectEntityDamageSource.class);
    }

    @Nullable
    private static DamageSource overrideWithChanges(@Nonnull DamageSource source, Consumer<DamageSource> run) {
        DamageSource dst = DamageSourceUtil.override(source, null, null);
        if (dst != null) {
            run.accept(dst);
        }
        return dst;
    }

    @Nullable
    private static DamageSource override(DamageSource src, @Nullable Entity directSource, @Nullable Entity trueSource) {
        if (!DamageSourceUtil.mayChangeAttributes(src)) {
            return null;
        }
        Object dst = src.getClass().equals(DamageSource.class) ? new DamageSource(src.func_76355_l()) : (src.getClass().equals(EntityDamageSource.class) ? new EntityDamageSource(src.func_76355_l(), directSource != null ? directSource : src.func_76364_f()) : new IndirectEntityDamageSource(src.func_76355_l(), directSource != null ? directSource : src.func_76364_f(), trueSource != null ? trueSource : (directSource != null ? directSource : src.func_76346_g())));
        DamageSourceUtil.copy(src, dst);
        return dst;
    }

    private static void copy(DamageSource src, DamageSource dest) {
        if (src.func_76357_e()) {
            dest.func_76359_i();
        }
        if (src.func_151517_h()) {
            dest.func_151518_m();
        }
        if (src.func_76352_a()) {
            dest.func_76349_b();
        }
        if (src.func_94541_c()) {
            dest.func_94540_d();
        }
        if (src.func_76347_k()) {
            dest.func_76361_j();
        }
        if (src.func_82725_o()) {
            dest.func_82726_p();
        }
        if (src.func_76350_n()) {
            dest.func_76351_m();
        }
    }
}

