/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.base.network;

import hellfirepvp.astralsorcery.common.auxiliary.link.LinkableTileEntity;
import hellfirepvp.astralsorcery.common.starlight.IStarlightSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.ITransmissionSource;
import hellfirepvp.astralsorcery.common.starlight.transmission.TransmissionNetworkHelper;
import hellfirepvp.astralsorcery.common.tile.base.TileNetwork;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileSourceBase<T extends ITransmissionSource>
extends TileNetwork<T>
implements IStarlightSource<T>,
LinkableTileEntity {
    protected boolean needsNetworkChainRebuild = false;
    private boolean linked = false;
    private final List<BlockPos> positions = new LinkedList<BlockPos>();

    protected TileSourceBase(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public boolean hasBeenLinked() {
        return this.linked;
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.positions.clear();
        if (compound.func_74764_b("linked")) {
            ListNBT list = compound.func_150295_c("linked", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundNBT tag = list.func_150305_b(i);
                this.positions.add(NBTHelper.readBlockPosFromNBT(tag));
            }
        }
        this.linked = compound.func_74767_n("wasLinkedBefore");
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        ListNBT list = new ListNBT();
        for (BlockPos pos : this.positions) {
            CompoundNBT tag = new CompoundNBT();
            NBTHelper.writeBlockPosToNBT(pos, tag);
            list.add((Object)tag);
        }
        compound.func_218657_a("linked", (INBT)list);
        compound.func_74757_a("wasLinkedBefore", this.linked);
    }

    @Override
    @Nonnull
    public BlockPos getTrPos() {
        return this.func_174877_v();
    }

    @Override
    @Nonnull
    public World getTrWorld() {
        return this.func_145831_w();
    }

    @Override
    public void onBlockLinkCreate(PlayerEntity player, BlockPos other) {
        if (other.equals((Object)this.func_174877_v())) {
            return;
        }
        if (TransmissionNetworkHelper.createTransmissionLink(this, other)) {
            if (!this.positions.contains(other)) {
                this.positions.add(other);
                this.needsNetworkChainRebuild = true;
                this.markForUpdate();
            }
            if (!this.hasBeenLinked()) {
                this.linked = true;
            }
        }
    }

    @Override
    public void onEntityLinkCreate(PlayerEntity player, LivingEntity linked) {
    }

    @Override
    public boolean tryLinkBlock(PlayerEntity player, BlockPos other) {
        return !other.equals((Object)this.func_174877_v()) && TransmissionNetworkHelper.canCreateTransmissionLink(this, other);
    }

    @Override
    public boolean tryLinkEntity(PlayerEntity player, LivingEntity other) {
        return false;
    }

    @Override
    public boolean tryUnlink(PlayerEntity player, BlockPos other) {
        if (other.equals((Object)this.func_174877_v())) {
            return false;
        }
        if (TransmissionNetworkHelper.hasTransmissionLink(this, other)) {
            TransmissionNetworkHelper.removeTransmissionLink(this, other);
            this.positions.remove(other);
            this.needsNetworkChainRebuild = true;
            this.markForUpdate();
            return true;
        }
        return false;
    }

    @Override
    public boolean doesAcceptLinks() {
        return false;
    }

    @Override
    public List<BlockPos> getLinkedPositions() {
        return this.positions;
    }

    @Override
    public boolean needsToRefreshNetworkChain() {
        return this.needsNetworkChainRebuild;
    }

    @Override
    public void markChainRebuilt() {
        this.needsNetworkChainRebuild = false;
    }
}

