/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile;

import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.EntityVisualFX;
import hellfirepvp.astralsorcery.client.effect.function.RefreshFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXAlphaFunction;
import hellfirepvp.astralsorcery.client.effect.function.VFXColorFunction;
import hellfirepvp.astralsorcery.client.effect.handler.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.vfx.FXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightbeam;
import hellfirepvp.astralsorcery.client.effect.vfx.FXLightning;
import hellfirepvp.astralsorcery.client.effect.vfx.FXSpritePlane;
import hellfirepvp.astralsorcery.client.lib.EffectTemplatesAS;
import hellfirepvp.astralsorcery.client.lib.SpritesAS;
import hellfirepvp.astralsorcery.common.constellation.DrawnConstellation;
import hellfirepvp.astralsorcery.common.constellation.engraving.EngravedStarMap;
import hellfirepvp.astralsorcery.common.constellation.world.DayTimeHelper;
import hellfirepvp.astralsorcery.common.item.ItemInfusedGlass;
import hellfirepvp.astralsorcery.common.lib.ColorsAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.lib.TileEntityTypesAS;
import hellfirepvp.astralsorcery.common.tile.base.TileEntityTick;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.item.ItemUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import hellfirepvp.astralsorcery.common.util.sound.SoundHelper;
import hellfirepvp.astralsorcery.common.util.tile.NamedInventoryTile;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TileRefractionTable
extends TileEntityTick
implements NamedInventoryTile {
    private static final float RUN_TIME = 200.0f;
    private int runTick = 0;
    private ItemStack glassStack = ItemStack.field_190927_a;
    private int parchmentCount = 0;
    private ItemStack inputStack = ItemStack.field_190927_a;
    private Object effectHalo;

    public TileRefractionTable() {
        super(TileEntityTypesAS.REFRACTION_TABLE);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.func_145831_w().func_201670_d()) {
            this.playEngravingEffects();
        } else if (DayTimeHelper.isNight(this.func_145831_w()) && this.doesSeeSky() && TileRefractionTable.isValidGlassStack(this.getGlassStack())) {
            EngravedStarMap starMap = ItemInfusedGlass.getEngraving(this.getGlassStack());
            if (starMap != null && !this.hasParchment() && !this.getInputStack().func_190926_b() && starMap.canAffect(this.getInputStack())) {
                ++this.runTick;
                if ((float)this.runTick > 200.0f) {
                    this.setInputStack(starMap.applyEffects(this.getInputStack()));
                    ItemStack glassStack = this.getGlassStack();
                    if (glassStack.func_96631_a(1, rand, null)) {
                        glassStack.func_190918_g(1);
                        this.setGlassStack(glassStack);
                        SoundHelper.playSoundAround(SoundEvents.field_187561_bM, SoundCategory.BLOCKS, this.func_145831_w(), (Vector3i)this.func_174877_v(), rand.nextFloat() * 0.5f + 1.0f, rand.nextFloat() * 0.2f + 0.8f);
                    }
                    this.resetWorkTick();
                }
                this.markForUpdate();
            } else {
                this.resetWorkTick();
            }
        } else {
            this.resetWorkTick();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playEngravingEffects() {
        if (this.runTick <= 0) {
            return;
        }
        if (this.effectHalo != null && ((FXSpritePlane)this.effectHalo).isRemoved()) {
            EffectHelper.refresh((FXSpritePlane)this.effectHalo, EffectTemplatesAS.TEXTURE_SPRITE);
        }
        if (this.effectHalo == null) {
            this.effectHalo = ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXSpritePlane)EffectHelper.of(EffectTemplatesAS.TEXTURE_SPRITE).spawn(new Vector3(this).add(0.5, 0.8, 0.5))).setSprite(SpritesAS.SPR_HALO_INFUSION).setAxis(Vector3.RotAxis.Y_AXIS).setNoRotation(0.0f).setScaleMultiplier(0.8f)).setAlphaMultiplier(0.8f)).alpha((fx, alpha, pTicks) -> MathHelper.func_76131_a((float)(alpha * this.getRunProgress()), (float)0.0f, (float)1.0f))).refresh(RefreshFunction.tileExistsAnd(this, (thisTile, fx) -> thisTile.getRunProgress() > 0.0f));
        }
        Vector3 offset = new Vector3(-0.3125, 1.505, -0.1875);
        int random = rand.nextInt(ColorsAS.REFRACTION_TABLE_COLORS.length);
        if (random >= ColorsAS.REFRACTION_TABLE_COLORS.length / 2) {
            offset.addX(1.5);
        }
        offset.addZ((double)(random % (ColorsAS.REFRACTION_TABLE_COLORS.length / 2)) * 0.25);
        offset.add((double)rand.nextFloat() * 0.1, 0.0, (double)rand.nextFloat() * 0.1).add((Vector3i)this.field_174879_c);
        Color color = ColorsAS.REFRACTION_TABLE_COLORS[random];
        ((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(offset)).setGravityStrength(-0.002f)).setScaleMultiplier(0.15f + rand.nextFloat() * 0.1f)).alpha(VFXAlphaFunction.FADE_OUT)).color(VFXColorFunction.constant(color))).setMaxAge(30 + rand.nextInt(30));
        if (rand.nextFloat() < this.getRunProgress() * 2.0f) {
            Vector3 target = new Vector3(this).add(0.5, 0.9, 0.5);
            ((FXLightning)EffectHelper.of(EffectTemplatesAS.LIGHTNING).spawn(offset)).makeDefault(target).color(VFXColorFunction.constant(color));
            FXFacingParticle p = (FXFacingParticle)((EntityComplexFX)((EntityVisualFX)((EntityVisualFX)((FXFacingParticle)EffectHelper.of(EffectTemplatesAS.GENERIC_PARTICLE).spawn(offset)).setScaleMultiplier(0.15f + rand.nextFloat() * 0.1f)).alpha(VFXAlphaFunction.proximity(target::clone, 1.0f))).color(VFXColorFunction.constant(color))).setMaxAge(45);
            Vector3 mov = target.clone().subtract(offset).normalize().multiply(0.05 * (double)rand.nextFloat());
            p.setMotion(mov);
        }
        if (rand.nextInt(3) == 0) {
            ((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(offset)).setup(offset.clone().addY(0.56f + rand.nextFloat() * 0.2f), 0.25, 0.25).color(VFXColorFunction.constant(color));
        }
        if (rand.nextInt(4) == 0) {
            Color beamColor = MiscUtils.eitherOf(rand, ColorsAS.CONSTELLATION_TYPE_MAJOR, ColorsAS.CONSTELLATION_TYPE_WEAK, ColorsAS.CONSTELLATION_TYPE_MINOR);
            Vector3 beamOffset = new Vector3(this).add(0.1 + (double)rand.nextFloat() * 0.8, 0.8, 0.1 + (double)(rand.nextFloat() * 0.8f));
            ((EntityComplexFX)((FXLightbeam)EffectHelper.of(EffectTemplatesAS.LIGHTBEAM).spawn(beamOffset)).setup(beamOffset.clone().addY(1.0 + (double)rand.nextFloat() * 0.5), 0.5, 0.5).color(VFXColorFunction.constant(beamColor))).setMaxAge(25 + rand.nextInt(5));
        }
    }

    private void resetWorkTick() {
        if (this.runTick > 0) {
            this.runTick = 0;
            this.markForUpdate();
        }
    }

    public int addParchment(int toAdd) {
        if (this.inputStack.func_190926_b()) {
            int overflow = Math.max(this.parchmentCount + toAdd - 64, 0);
            int addable = toAdd - overflow;
            this.parchmentCount += addable;
            this.markForUpdate();
            return overflow;
        }
        return toAdd;
    }

    public int getParchmentCount() {
        return this.parchmentCount;
    }

    public boolean hasParchment() {
        return this.parchmentCount > 0;
    }

    public void engraveGlass(List<DrawnConstellation> constellations) {
        if (this.hasParchment() && this.hasUnengravedGlass()) {
            --this.parchmentCount;
            ItemInfusedGlass.setEngraving(this.getGlassStack(), EngravedStarMap.buildStarMap(this.func_145831_w(), constellations));
            this.markForUpdate();
        }
    }

    @Nonnull
    public ItemStack setInputStack(@Nonnull ItemStack inputStack) {
        ItemStack prevInput = this.inputStack.func_77946_l();
        if (this.parchmentCount > 0) {
            prevInput = new ItemStack((IItemProvider)ItemsAS.PARCHMENT, this.parchmentCount);
            this.parchmentCount = 0;
        }
        this.inputStack = inputStack.func_77946_l();
        this.markForUpdate();
        return prevInput;
    }

    @Nonnull
    public ItemStack getInputStack() {
        return this.hasParchment() ? new ItemStack((IItemProvider)ItemsAS.PARCHMENT, this.getParchmentCount()) : this.inputStack.func_77946_l();
    }

    public static boolean isValidGlassStack(@Nonnull ItemStack glassStack) {
        return !glassStack.func_190926_b() && glassStack.func_77973_b() instanceof ItemInfusedGlass;
    }

    @Nonnull
    public ItemStack setGlassStack(@Nonnull ItemStack glassStack) {
        if (!glassStack.func_190926_b() && !TileRefractionTable.isValidGlassStack(glassStack)) {
            return ItemStack.field_190927_a;
        }
        ItemStack prevStack = this.glassStack;
        this.glassStack = glassStack;
        this.markForUpdate();
        return prevStack;
    }

    @Nonnull
    public ItemStack getGlassStack() {
        return this.glassStack;
    }

    public boolean hasUnengravedGlass() {
        return TileRefractionTable.isValidGlassStack(this.getGlassStack()) && ItemInfusedGlass.getEngraving(this.getGlassStack()) == null;
    }

    public float getRunProgress() {
        return MathHelper.func_76131_a((float)((float)this.runTick / 200.0f), (float)0.0f, (float)1.0f);
    }

    public void dropContents() {
        Vector3 at = new Vector3(this).add(0.5, 0.5, 0.5);
        if (!this.getGlassStack().func_190926_b()) {
            ItemUtils.dropItemNaturally(this.func_145831_w(), at.getX(), at.getY(), at.getZ(), this.getGlassStack());
            this.setGlassStack(ItemStack.field_190927_a);
        }
        if (!this.getInputStack().func_190926_b()) {
            ItemUtils.dropItemNaturally(this.func_145831_w(), at.getX(), at.getY(), at.getZ(), this.getInputStack());
            this.setInputStack(ItemStack.field_190927_a);
        }
        this.markForUpdate();
    }

    @Override
    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("screen.astralsorcery.refraction_table");
    }

    @Override
    public void readCustomNBT(CompoundNBT compound) {
        super.readCustomNBT(compound);
        this.runTick = compound.func_74762_e("runTick");
        this.parchmentCount = compound.func_74762_e("parchmentCount");
        this.inputStack = NBTHelper.getStack(compound, "inputStack");
        this.glassStack = NBTHelper.getStack(compound, "glassStack");
    }

    @Override
    public void writeCustomNBT(CompoundNBT compound) {
        super.writeCustomNBT(compound);
        compound.func_74768_a("runTick", this.runTick);
        compound.func_74768_a("parchmentCount", this.parchmentCount);
        NBTHelper.setStack(compound, "inputStack", this.inputStack);
        NBTHelper.setStack(compound, "glassStack", this.glassStack);
    }
}

