/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.structure.types;

import hellfirepvp.observerlib.api.ChangeSubscriber;
import hellfirepvp.observerlib.api.ObserverHelper;
import hellfirepvp.observerlib.api.ObserverProvider;
import hellfirepvp.observerlib.api.util.BlockArray;
import hellfirepvp.observerlib.common.change.ChangeObserverStructure;
import hellfirepvp.observerlib.common.change.ObserverProviderStructure;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class StructureType
implements IForgeRegistryEntry<StructureType> {
    private final ResourceLocation name;
    private final Supplier<BlockArray> structureSupplier;

    public StructureType(ResourceLocation name, Supplier<BlockArray> structureSupplier) {
        this.name = name;
        this.structureSupplier = structureSupplier;
    }

    public BlockArray getStructure() {
        return this.structureSupplier.get();
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(String.format("structure.%s.%s.name", this.name.func_110624_b(), this.name.func_110623_a()));
    }

    public ChangeSubscriber<ChangeObserverStructure> observe(World world, BlockPos pos) {
        return ObserverHelper.getHelper().observeArea(world, pos, (ObserverProvider)new ObserverProviderStructure(this.getRegistryName()));
    }

    public final StructureType setRegistryName(ResourceLocation name) {
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<StructureType> getRegistryType() {
        return StructureType.class;
    }
}

