/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.storage;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class StorageKey {
    @Nonnull
    private final ItemStack stack;

    private StorageKey(@Nonnull ItemStack stack) {
        this.stack = stack;
    }

    public static StorageKey from(ItemStack stack) {
        return new StorageKey(stack);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageKey that = (StorageKey)o;
        Item thisItem = this.stack.func_77973_b();
        Item thatItem = that.stack.func_77973_b();
        return Objects.equals(thisItem.getRegistryName(), thatItem.getRegistryName());
    }

    public int hashCode() {
        return Objects.hash(this.stack.func_77973_b().getRegistryName());
    }

    @Nonnull
    public CompoundNBT serialize() {
        CompoundNBT keyTag = new CompoundNBT();
        keyTag.func_74778_a("name", this.stack.func_77973_b().getRegistryName().toString());
        return keyTag;
    }

    @Nullable
    public static StorageKey deserialize(CompoundNBT nbt) {
        ResourceLocation rl = new ResourceLocation(nbt.func_74779_i("name"));
        Item i = (Item)ForgeRegistries.ITEMS.getValue(rl);
        if (i == null || i == Items.field_190931_a) {
            return null;
        }
        return new StorageKey(new ItemStack((IItemProvider)i));
    }
}

