/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.lib.PerkConvertersAS;
import hellfirepvp.astralsorcery.common.perk.PerkConverter;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.node.focus.KeyGelu;
import hellfirepvp.astralsorcery.common.perk.source.ModifierSource;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;

public class RegistryPerkConverters {
    private RegistryPerkConverters() {
    }

    public static void init() {
        PerkConvertersAS.IDENTITY = RegistryPerkConverters.register(new PerkConverter(AstralSorcery.key("identity")){

            @Override
            @Nonnull
            public PerkAttributeModifier convertModifier(PlayerEntity player, PlayerProgress progress, PerkAttributeModifier modifier, @Nullable ModifierSource owningSource) {
                return modifier;
            }
        });
        PerkConvertersAS.FOCUS_ALCARA = RegistryPerkConverters.register(new PerkConverter(AstralSorcery.key("focus_alcara")){

            @Override
            @Nonnull
            public PerkAttributeModifier convertModifier(PlayerEntity player, PlayerProgress progress, PerkAttributeModifier modifier, @Nullable ModifierSource owningSource) {
                if (modifier.getAttributeType().equals(PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EXP)) {
                    return modifier.convertModifier(PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, modifier.getMode(), modifier.getValue(player, progress));
                }
                return modifier;
            }
        });
        PerkConvertersAS.FOCUS_GELU = RegistryPerkConverters.register(new PerkConverter(AstralSorcery.key("focus_gelu")){

            @Override
            @Nonnull
            public PerkAttributeModifier convertModifier(PlayerEntity player, PlayerProgress progress, PerkAttributeModifier modifier, @Nullable ModifierSource owningSource) {
                if (modifier.getAttributeType().equals(PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT) && owningSource != null && !(owningSource instanceof KeyGelu)) {
                    return modifier.convertModifier(PerkAttributeTypesAS.ATTR_TYPE_INC_PERK_EFFECT, ModifierType.STACKING_MULTIPLY, 1.0f);
                }
                return modifier;
            }
        });
    }

    private static <T extends PerkConverter> T register(T converter) {
        AstralSorcery.getProxy().getRegistryPrimer().register(converter);
        return converter;
    }
}

