/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.registry;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.fluid.BlockLiquidStarlight;
import hellfirepvp.astralsorcery.common.fluid.FluidLiquidStarlight;
import hellfirepvp.astralsorcery.common.fluid.ItemLiquidStarlightBucket;
import hellfirepvp.astralsorcery.common.lib.BlocksAS;
import hellfirepvp.astralsorcery.common.lib.FluidsAS;
import hellfirepvp.astralsorcery.common.lib.ItemsAS;
import hellfirepvp.astralsorcery.common.util.NameUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;

public class RegistryFluids {
    static final List<Block> FLUID_BLOCKS = new LinkedList<Block>();
    static final List<Item> FLUID_HOLDER_ITEMS = new LinkedList<Item>();

    private RegistryFluids() {
    }

    public static void registerFluids() {
        RegistryFluids.makeProperties();
        FluidsAS.LIQUID_STARLIGHT_SOURCE = RegistryFluids.registerFluid(new FluidLiquidStarlight.Source(FluidsAS.LIQUID_STARLIGHT_PROPERTIES));
        FluidsAS.LIQUID_STARLIGHT_FLOWING = RegistryFluids.registerFluid(new FluidLiquidStarlight.Flowing(FluidsAS.LIQUID_STARLIGHT_PROPERTIES));
        BlocksAS.FLUID_LIQUID_STARLIGHT = new BlockLiquidStarlight(() -> FluidsAS.LIQUID_STARLIGHT_SOURCE);
        FLUID_BLOCKS.add((Block)BlocksAS.FLUID_LIQUID_STARLIGHT);
        ItemsAS.BUCKET_LIQUID_STARLIGHT = new ItemLiquidStarlightBucket(() -> FluidsAS.LIQUID_STARLIGHT_SOURCE);
        FLUID_HOLDER_ITEMS.add((Item)ItemsAS.BUCKET_LIQUID_STARLIGHT);
    }

    private static void makeProperties() {
        FluidsAS.LIQUID_STARLIGHT_PROPERTIES = RegistryFluids.makeProperties(FluidLiquidStarlight.class, FluidLiquidStarlight::addAttributes, () -> FluidsAS.LIQUID_STARLIGHT_SOURCE, () -> FluidsAS.LIQUID_STARLIGHT_FLOWING).block(() -> BlocksAS.FLUID_LIQUID_STARLIGHT).bucket(() -> ItemsAS.BUCKET_LIQUID_STARLIGHT);
    }

    private static ForgeFlowingFluid.Properties makeProperties(Class<? extends ForgeFlowingFluid> fluidClass, Function<FluidAttributes.Builder, FluidAttributes.Builder> postProcess, Supplier<ForgeFlowingFluid> stillFluidSupplier, Supplier<ForgeFlowingFluid> flowingFluidSupplier) {
        String name = NameUtil.fromClass(fluidClass, "Fluid").func_110623_a();
        return new ForgeFlowingFluid.Properties(stillFluidSupplier, flowingFluidSupplier, postProcess.apply(RegistryFluids.builderFor(name)));
    }

    private static FluidAttributes.Builder builderFor(String fluidName) {
        ResourceLocation still = AstralSorcery.key("fluid/" + fluidName + "_still");
        ResourceLocation flowing = AstralSorcery.key("fluid/" + fluidName + "_flowing");
        return FluidAttributes.builder((ResourceLocation)still, (ResourceLocation)flowing);
    }

    private static <T extends Fluid> T registerFluid(T fluid) {
        return RegistryFluids.registerFluid(fluid, NameUtil.fromClass(fluid, "Fluid", "Source"));
    }

    private static <T extends Fluid> T registerFluid(T fluid, ResourceLocation name) {
        fluid.setRegistryName(name);
        AstralSorcery.getProxy().getRegistryPrimer().register(fluid);
        return fluid;
    }
}

