/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.type;

import hellfirepvp.astralsorcery.common.CommonProxy;
import hellfirepvp.astralsorcery.common.data.research.PlayerProgress;
import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.modifier.AttributeModifierThorns;
import hellfirepvp.astralsorcery.common.perk.modifier.PerkAttributeModifier;
import hellfirepvp.astralsorcery.common.perk.type.ModifierType;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import hellfirepvp.astralsorcery.common.util.DamageUtil;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class AttributeTypeThorns
extends PerkAttributeType {
    public AttributeTypeThorns() {
        super(PerkAttributeTypesAS.KEY_ATTR_TYPE_INC_THORNS);
    }

    @Override
    protected void attachListeners(IEventBus eventBus) {
        super.attachListeners(eventBus);
        eventBus.addListener(this::onThronsReflect);
    }

    @Override
    @Nonnull
    public PerkAttributeModifier createModifier(float modifier, ModifierType mode) {
        return new AttributeModifierThorns(this, mode, modifier);
    }

    private void onThronsReflect(LivingHurtEvent event) {
        float dmgReflected;
        LogicalSide side;
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        if (!this.hasTypeApplied(player, side = this.getSide((Entity)player))) {
            return;
        }
        PlayerProgress prog = ResearchHelper.getProgress(player, side);
        float reflectAmount = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, prog, this, 0.0f);
        reflectAmount = AttributeEvent.postProcessModded(player, (PerkAttributeType)this, reflectAmount);
        if ((reflectAmount /= 100.0f) <= 0.0f) {
            return;
        }
        reflectAmount = MathHelper.func_76131_a((float)reflectAmount, (float)0.0f, (float)1.0f);
        DamageSource source = event.getSource();
        LivingEntity reflectTarget = null;
        if (source.func_76364_f() != null && source.func_76364_f() instanceof LivingEntity && source.func_76364_f().func_70089_S()) {
            reflectTarget = (LivingEntity)source.func_76364_f();
        }
        if (reflectTarget == null && AttributeEvent.postProcessModded(player, (PerkAttributeType)this, PerkAttributeHelper.getOrCreateMap(player, side).getModifier(player, prog, PerkAttributeTypesAS.ATTR_TYPE_INC_THORNS_RANGED)) > 1.0f && source.func_76346_g() != null && source.func_76346_g() instanceof LivingEntity && source.func_76346_g().func_70089_S()) {
            reflectTarget = (LivingEntity)source.func_76346_g();
        }
        if (reflectTarget != null && (dmgReflected = event.getAmount() * reflectAmount) > 0.0f && !event.getEntityLiving().equals((Object)reflectTarget) && MiscUtils.canPlayerAttackServer(event.getEntityLiving(), reflectTarget)) {
            DamageUtil.attackEntityFrom((Entity)reflectTarget, CommonProxy.DAMAGE_SOURCE_REFLECT, dmgReflected, (Entity)player);
        }
    }
}

