/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.perk.type;

import hellfirepvp.astralsorcery.common.data.research.ResearchHelper;
import hellfirepvp.astralsorcery.common.event.AttributeEvent;
import hellfirepvp.astralsorcery.common.lib.PerkAttributeTypesAS;
import hellfirepvp.astralsorcery.common.perk.PerkAttributeHelper;
import hellfirepvp.astralsorcery.common.perk.type.PerkAttributeType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.LogicalSide;

public class AttributeTypeCritMultiplier
extends PerkAttributeType {
    public AttributeTypeCritMultiplier() {
        super(PerkAttributeTypesAS.KEY_ATTR_TYPE_INC_CRIT_MULTIPLIER, true);
    }

    @Override
    protected void attachListeners(IEventBus eventBus) {
        super.attachListeners(eventBus);
        eventBus.addListener(EventPriority.LOWEST, this::onArrowCrit);
        eventBus.addListener(EventPriority.LOWEST, this::onHitCrit);
    }

    private void onArrowCrit(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ArrowEntity) {
            ArrowEntity arrow = (ArrowEntity)event.getEntity();
            if (!arrow.func_70241_g()) {
                return;
            }
            Entity shooter = arrow.func_234616_v_();
            if (shooter instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)shooter;
                LogicalSide side = this.getSide((Entity)player);
                if (!this.hasTypeApplied(player, side)) {
                    return;
                }
                float dmgMod = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, ResearchHelper.getProgress(player, side), this, 1.0f);
                dmgMod = AttributeEvent.postProcessModded(player, (PerkAttributeType)this, dmgMod);
                arrow.func_70239_b(arrow.func_70242_d() * (double)dmgMod);
            }
        }
    }

    private void onHitCrit(CriticalHitEvent event) {
        LogicalSide side;
        if (!event.isVanillaCritical() && event.getResult() != Event.Result.ALLOW) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (!this.hasTypeApplied(player, side = this.getSide((Entity)player))) {
            return;
        }
        float dmgMod = PerkAttributeHelper.getOrCreateMap(player, side).modifyValue(player, ResearchHelper.getProgress(player, side), this, 1.0f);
        dmgMod = AttributeEvent.postProcessModded(player, (PerkAttributeType)this, dmgMod);
        event.setDamageModifier(event.getDamageModifier() * dmgMod);
    }
}

